/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.controller;

import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.no.code.business.service.DictDataSourceService;
import com.jxdinfo.hussar.formdesign.no.code.model.dict.DictFieldDto;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/dict"})
public class DictDataSourceController {
    @Resource
    private DictDataSourceService dictDataSourceService;

    @GetMapping(value={"/type_tree"})
    public FormDesignResponse<List<JSTreeModel>> getDictTypeTree() {
        return FormDesignResponse.success(this.dictDataSourceService.getDictTypeTree());
    }

    @PostMapping(value={"/add_group"})
    public FormDesignResponse addDictGroup(@RequestBody DicGroup dicGroup) {
        this.dictDataSourceService.addDictGroup(dicGroup);
        return FormDesignResponse.success((Object)"");
    }

    @PostMapping(value={"/add_dict_field"})
    public FormDesignResponse<Boolean> addDictField(@RequestBody DictFieldDto dictFieldDto) {
        return FormDesignResponse.success((Object)this.dictDataSourceService.addDictAndField(dictFieldDto));
    }

    @GetMapping(value={"/get_by_typeId"})
    public FormDesignResponse<List<DicLevelTreeVo>> queryOption(@RequestParam(value="dictTypeId") Long dictTypeId) {
        List<DicLevelTreeVo> dicLevelTreeVos = this.dictDataSourceService.queryDictOptions(dictTypeId);
        return FormDesignResponse.success(dicLevelTreeVos);
    }
}

