/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.GAUSSSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.HIGHGOSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OracleTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.PGSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="JXDNLinkFormMulti")
public class JXDNLinkFormMulti
extends JXDNWidgetDefault {
    @Resource
    private FormOperateService formOperateService;
    private Widget widget;
    private FormSchema form;
    private Map<String, String> idFieldType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleTypeEnum.VARCHAR2.getTypeName());
            this.put("HIGHGO", HIGHGOSqlTypeEnum.TEXT.getTypeName());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.POSTGRE_SQL.name(), PGSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), GAUSSSqlTypeEnum.TEXT.getTypeName());
        }
    };
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleTypeEnum.VARCHAR2.getTypeName());
            this.put("HIGHGO", HIGHGOSqlTypeEnum.TEXT.getTypeName());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.POSTGRE_SQL.name(), PGSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), GAUSSSqlTypeEnum.TEXT.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        DataModelFieldBase.Builder field = new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType));
        if (HussarUtils.equals((Object)this.fieldDbType.get(dbType), (Object)OracleTypeEnum.VARCHAR2.getTypeName())) {
            field.withDataLength(2000);
        }
        fields.add(field.build());
        fields.add(new DataModelFieldBase.Builder().withId(String.format("%s%s", name, "_ref_id")).withName(String.format("%s%s", name, "_ref_id")).withComment("\u5f15\u7528\u6570\u636e\u4e3b\u952e").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.idFieldType.get(dbType)).withDataLength(255).build());
        fields.add(new DataModelFieldBase.Builder().withId(String.format("%s%s", name, "_ref_child_id")).withName(String.format("%s%s", name, "_ref_child_id")).withComment("\u5f15\u7528\u5b50\u8868\u6570\u636e\u7684\u4e3b\u952e").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.idFieldType.get(dbType)).withDataLength(255).build());
        return fields;
    }

    @Override
    public List<ModelFieldDto> withEngineField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<ModelFieldDto> fields = new ArrayList<ModelFieldDto>();
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(name);
        fieldDto.setFieldComment(title);
        fieldDto.setDefaultValue(null);
        fieldDto.setDataType(this.fieldDbType.get(dbType));
        if (HussarUtils.equals((Object)this.fieldDbType.get(dbType), (Object)OracleTypeEnum.VARCHAR2.getTypeName())) {
            fieldDto.setDataLength(Long.valueOf(2000L));
        }
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.STRING.getValue());
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDto.setNeedChangeIsRequired(false);
        fieldDto.setPurpose(widget.getUsage());
        fieldDto.setRequired("0");
        fields.add(fieldDto);
        ModelFieldDto fieldDtoRefId = new ModelFieldDto();
        fieldDtoRefId.setFieldName(String.format("%s%s", name, "_ref_id"));
        fieldDtoRefId.setFieldComment("\u5f15\u7528\u6570\u636e\u4e3b\u952e");
        fieldDtoRefId.setDefaultValue(null);
        fieldDtoRefId.setDataType(this.idFieldType.get(dbType));
        if (HussarUtils.equals((Object)this.idFieldType.get(dbType), (Object)OracleTypeEnum.VARCHAR2.getTypeName())) {
            fieldDtoRefId.setDataLength(Long.valueOf(2000L));
        }
        fieldDtoRefId.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDtoRefId.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDtoRefId.setNeedChangeIsRequired(false);
        fieldDtoRefId.setPurpose(widget.getUsage());
        fieldDtoRefId.setRequired("0");
        fields.add(fieldDtoRefId);
        ModelFieldDto fieldDtoRefChildId = new ModelFieldDto();
        fieldDtoRefChildId.setFieldName(String.format("%s%s", name, "_ref_child_id"));
        fieldDtoRefChildId.setFieldComment("\u5f15\u7528\u5b50\u8868\u6570\u636e\u7684\u4e3b\u952e");
        fieldDtoRefChildId.setDefaultValue(null);
        fieldDtoRefChildId.setDataType(this.idFieldType.get(dbType));
        if (HussarUtils.equals((Object)this.idFieldType.get(dbType), (Object)OracleTypeEnum.VARCHAR2.getTypeName())) {
            fieldDtoRefChildId.setDataLength(Long.valueOf(2000L));
        }
        fieldDtoRefChildId.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDtoRefChildId.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDtoRefChildId.setNeedChangeIsRequired(false);
        fieldDtoRefChildId.setPurpose(widget.getUsage());
        fieldDtoRefChildId.setRequired("0");
        fields.add(fieldDtoRefChildId);
        return fields;
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        Widget linkWidget;
        String type = JsonParser.value(this.widget, "$.props.linkTableInfo.asyncType", String.class, "");
        if (!HussarUtils.equals((Object)type, (Object)"dataSet") && !HussarUtils.equals((Object)type, (Object)"dataSet") && HussarUtils.isNotEmpty((Object)(linkWidget = this.getLinkWidget()))) {
            linkWidget.wrapTitle(title, currentParam);
        }
    }

    private Widget getLinkWidget() {
        FormSchema formSchema;
        String nowAppId = AppContextUtil.getAppId();
        String appId = JsonParser.value(this.widget, "$.props.linkTableInfo.appId", String.class, nowAppId);
        String formId = JsonParser.value(this.widget, "$.props.linkTableInfo.formId", String.class, "");
        String name = JsonParser.value(this.widget, "$.props.linkTableInfo.linkFieldInfo.name", String.class, "");
        if (HussarUtils.isEmpty((Object)appId) || HussarUtils.isEmpty((Object)formId) || HussarUtils.isEmpty((Object)name)) {
            throw new RuntimeException("\u5173\u8054\u8868\u5355\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        }
        AppContextUtil.setAppId((String)appId);
        try {
            formSchema = (FormSchema)this.formOperateService.get(formId).getData();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (HussarUtils.isEmpty((Object)formSchema) || HussarUtils.isEmpty((Object)((Object)formSchema.getFormCanvas()))) {
            throw new RuntimeException("\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        FormCanvasSchema linkForm = formSchema.getFormCanvas();
        AppContextUtil.setAppId((String)nowAppId);
        List<Widget> widgets = linkForm.widgetsWithSys();
        Optional<Widget> first = widgets.stream().filter(v -> v.getName().equals(name)).findFirst();
        if (!first.isPresent()) {
            return null;
        }
        Widget linkedWidget = first.get();
        linkedWidget.setTitle(this.widget.getTitle());
        Widget linkedWidgetIns = linkedWidget.newInstance(formSchema);
        linkedWidgetIns.init(linkedWidget, formSchema);
        return linkedWidgetIns;
    }
}

