/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.GAUSSSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.HIGHGOSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OracleTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.PGSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="JXDNAddress")
public class JXDNAddress
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("HIGHGO", HIGHGOSqlTypeEnum.VARCHAR.name());
            this.put("MYSQL", MysqlType.VARCHAR.name());
            this.put("ORACLE", OracleTypeEnum.VARCHAR2.getTypeName());
            this.put("DM", DMSqlTypeEnum.VARCHAR.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.VARCHAR.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.VARCHAR.getTypeName());
            this.put(DbType.POSTGRE_SQL.name(), PGSqlTypeEnum.VARCHAR.getTypeName());
            this.put(DbType.GAUSS.name(), GAUSSSqlTypeEnum.VARCHAR.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name + "_code").withName(name + "_code").withComment(title + "-\u7701\u5e02\u533a\u7f16\u7801").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(20).build());
        fields.add(new DataModelFieldBase.Builder().withId(name + "_detailed").withName(name + "_detailed").withComment(title + "\u8be6\u7ec6").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(255).build());
        fields.add(this.getLabelField(dbType, widget));
        return fields;
    }

    @Override
    public List<ModelFieldDto> withEngineField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<ModelFieldDto> fields = new ArrayList<ModelFieldDto>();
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(name + "_code");
        fieldDto.setFieldComment(title + "-\u7701\u5e02\u533a\u7f16\u7801");
        fieldDto.setDefaultValue(null);
        fieldDto.setDataLength(Long.valueOf(20L));
        fieldDto.setDataType(this.fieldDbType.get(dbType));
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.STRING.getValue());
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDto.setNeedChangeIsRequired(false);
        fieldDto.setPurpose(widget.getUsage());
        fieldDto.setRequired("0");
        fields.add(fieldDto);
        ModelFieldDto fieldDtoDetail = new ModelFieldDto();
        fieldDtoDetail.setFieldName(name + "_detailed");
        fieldDtoDetail.setFieldComment(title + "\u8be6\u7ec6");
        fieldDtoDetail.setDefaultValue(null);
        fieldDtoDetail.setDataLength(Long.valueOf(255L));
        fieldDtoDetail.setDataType(this.fieldDbType.get(dbType));
        fieldDtoDetail.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDtoDetail.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDtoDetail.setNeedChangeIsRequired(false);
        fieldDtoDetail.setPurpose(widget.getUsage());
        fieldDtoDetail.setRequired("0");
        fields.add(fieldDtoDetail);
        ModelFieldDto fieldDtoLabel = new ModelFieldDto();
        fieldDtoLabel.setFieldName(name + "_label");
        fieldDtoLabel.setFieldComment(title);
        fieldDtoLabel.setDefaultValue(null);
        fieldDtoLabel.setDataLength(Long.valueOf(255L));
        fieldDtoLabel.setDataType(this.fieldDbType.get(dbType));
        fieldDtoLabel.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDtoLabel.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDtoLabel.setNeedChangeIsRequired(false);
        fieldDtoLabel.setPurpose(widget.getUsage());
        fieldDtoLabel.setRequired("0");
        fields.add(fieldDtoLabel);
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = widget.getTitle();
        return new DataModelFieldBase.Builder().withId(name + "_name").withName(name + "_label").withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(255).build();
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("derived", String.format("%s%s,%s%s", this.widget.getName(), "_label", this.widget.getName(), "_detailed"));
    }

    @Override
    public Object getModelByWidgetType(String name, Map<String, SysUsers> mapUserNameSysUsers, Map<String, OrganizationBo> mapOrganNameSysOrgans, Map<Long, List<RegionVo>> parentIdRegionVoMap, Integer addressLevel) {
        Long code = this.getCode(name, addressLevel, parentIdRegionVoMap);
        JSONObject userObject = new JSONObject();
        userObject.put("code", (Object)(HussarUtils.isEmpty((Object)code) ? "" : String.valueOf(code)));
        userObject.put("label", (Object)(HussarUtils.isEmpty((Object)code) ? "" : name));
        return userObject;
    }

    private Long getCode(String address, Integer addressLevel, Map<Long, List<RegionVo>> parentIdRegionVoMap) {
        RegionVo regionVo;
        Map nameRegionVoMap;
        List<RegionVo> regionVos;
        if (HussarUtils.isEmpty((Object)address)) {
            return null;
        }
        Long currentCode = null;
        String[] addressList = address.split("/");
        Long parentId = 0L;
        if (addressLevel >= 1) {
            if (addressList.length < 1) {
                return null;
            }
            String addressCurrent = addressList[0];
            List<RegionVo> regionVos2 = parentIdRegionVoMap.get(parentId);
            if (regionVos2 != null && regionVos2.size() > 0) {
                Map nameRegionVoMap2 = regionVos2.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1));
                RegionVo regionVo2 = (RegionVo)nameRegionVoMap2.get(addressCurrent);
                if (HussarUtils.isEmpty((Object)regionVo2)) {
                    return null;
                }
                parentId = currentCode = regionVo2.getId();
            }
        }
        if (addressLevel >= 2) {
            if (addressList.length < 2) {
                return null;
            }
            regionVos = parentIdRegionVoMap.get(parentId);
            if (regionVos != null && regionVos.size() > 0) {
                nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1));
                regionVo = (RegionVo)nameRegionVoMap.get(addressList[1]);
                if (HussarUtils.isEmpty((Object)regionVo)) {
                    return null;
                }
                parentId = currentCode = regionVo.getId();
            }
        }
        if (addressLevel >= 3) {
            if (addressList.length < 3) {
                return null;
            }
            regionVos = parentIdRegionVoMap.get(parentId);
            if (regionVos != null && regionVos.size() > 0) {
                nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1));
                regionVo = (RegionVo)nameRegionVoMap.get(addressList[2]);
                if (HussarUtils.isEmpty((Object)regionVo)) {
                    return null;
                }
                parentId = currentCode = regionVo.getId();
            }
        }
        if (addressLevel >= 4) {
            if (addressList.length < 4) {
                return null;
            }
            regionVos = parentIdRegionVoMap.get(parentId);
            if (HussarUtils.isNotEmpty(regionVos)) {
                nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1));
                regionVo = (RegionVo)nameRegionVoMap.get(addressList[3]);
                if (HussarUtils.isEmpty((Object)regionVo)) {
                    return null;
                }
                parentId = currentCode = regionVo.getId();
            }
        }
        return currentCode;
    }
}

