/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.storage.SettingStorageImpl;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="no.code.submit")
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class SubmitStorageImpl
implements SettingSchemaService<SubmitSchema> {
    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(SubmitSchema submitSchema, String formId) throws Exception {
        SettingSchemaService settingService = (SettingSchemaService)SpringUtil.getBean(SettingStorageImpl.class);
        FormDesignResponse response = settingService.get(formId);
        FormSettingSchema responseSetting = (FormSettingSchema)((Object)response.getData());
        if (HussarUtils.isEmpty((Object)((Object)responseSetting))) {
            FormSettingSchema newSetting = new FormSettingSchema();
            newSetting.setSubmitSchema(submitSchema);
            FormDesignResponse<Boolean> save = settingService.saveOrUpdate(newSetting, formId);
            if (((Boolean)save.getData()).booleanValue()) {
                return FormDesignResponse.success((Object)save.getData());
            }
        }
        responseSetting.setSubmitSchema(submitSchema);
        FormDesignResponse<Boolean> save = settingService.saveOrUpdate(responseSetting, formId);
        if (((Boolean)save.getData()).booleanValue()) {
            return FormDesignResponse.success((Object)save.getData());
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u4fdd\u5b58\u8868\u5355\u63d0\u4ea4\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)save.getData(), (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u4fdd\u5b58\u8868\u5355\u63d0\u4ea4\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<SubmitSchema> get(String formId) {
        SettingSchemaService settingService = (SettingSchemaService)SpringUtil.getBean(SettingStorageImpl.class);
        FormDesignResponse res = settingService.get(formId);
        if (HussarUtils.isEmpty((Object)res.getData())) {
            return FormDesignResponse.success(null, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8868\u5355id\u7684\u8868\u5355\u8bbe\u7f6e->\u8868\u5355\u63d0\u4ea4");
        }
        return FormDesignResponse.success((Object)((FormSettingSchema)((Object)res.getData())).getSubmitSchema());
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        FormSettingSchema setting = (FormSettingSchema)((Object)((SettingStorageImpl)SpringUtil.getBean(SettingStorageImpl.class)).get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)setting))) {
            ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u8868\u5355\u8bbe\u7f6e ==> Storage\u5220\u9664\u8868\u5355\u63d0\u4ea4\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u5220\u9664\u8868\u5355\u8bbe\u7f6e ==> Storage\u5220\u9664\u8868\u5355\u63d0\u4ea4\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }
}

