/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.db;

import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.db.SettingDBImpl;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnDB;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="no.code.fieldControl")
@Conditional(value={NoCodeConditionOnDB.class})
public class FieldControlDBImpl
implements SettingSchemaService<FieldControlSchema> {
    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FieldControlSchema controlSchema, String formId) throws Exception {
        SettingSchemaService settingService = (SettingSchemaService)SpringUtil.getBean(SettingDBImpl.class);
        FormDesignResponse response = settingService.get(formId);
        FormSettingSchema responseSetting = (FormSettingSchema)((Object)response.getData());
        if (HussarUtils.isEmpty((Object)((Object)responseSetting))) {
            FormSettingSchema newSetting = new FormSettingSchema();
            newSetting.setFieldControl(controlSchema);
            FormDesignResponse<Boolean> save = settingService.saveOrUpdate(newSetting, formId);
            if (((Boolean)save.getData()).booleanValue()) {
                return FormDesignResponse.success((Object)save.getData());
            }
        }
        responseSetting.setFieldControl(controlSchema);
        FormDesignResponse<Boolean> save = settingService.saveOrUpdate(responseSetting, formId);
        if (((Boolean)save.getData()).booleanValue()) {
            return FormDesignResponse.success((Object)save.getData());
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> DB\u4fdd\u5b58\u5b57\u6bb5\u63a7\u5236\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)save.getData(), (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> DB\u4fdd\u5b58\u5b57\u6bb5\u63a7\u5236\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<FieldControlSchema> get(String formId) {
        FormSettingSchema setting = (FormSettingSchema)((Object)((SettingDBImpl)SpringUtil.getBean(SettingDBImpl.class)).get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)setting))) {
            return FormDesignResponse.success(null, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8868\u5355id\u7684\u8868\u5355\u8bbe\u7f6e->\u5b57\u6bb5\u63a7\u5236");
        }
        return FormDesignResponse.success((Object)setting.getFieldControl());
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        return FormDesignResponse.success((Object)true);
    }
}

