/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.InvokeService;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class InvokeServiceImpl
implements InvokeService {
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private EngineApiService engineApiService;

    @Override
    public ResponseEntity<ApiResponse<Object>> queryBusinessData(String appId, String formId, Map<String, Object> params) {
        String invokeMethod;
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        if (HussarUtils.equals((Object)formCanvasSchema.getFormType(), (Object)"1")) {
            String viewId = ViewIdEnum.SYS_FLOW_ALL_DATA.getId();
            invokeMethod = String.format("%s%s", "TableQuery", viewId);
        } else {
            invokeMethod = "TableQuery";
        }
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, invokeMethod);
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> queryReferTable(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TableQuery");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> tableQuery(String appId, String formId, String viewId, Map<String, Object> params) {
        Object value;
        String invokeMethod = HussarUtils.isNotEmpty((Object)params.get("singlePageQuery")) && (Boolean)params.get("singlePageQuery") != false ? (HussarUtils.isEmpty((Object)viewId) ? "SinglePageQuery" : String.format("%s%s", "SinglePageQuery", viewId)) : (HussarUtils.isEmpty((Object)viewId) ? "TableQuery" : String.format("%s%s", "TableQuery", viewId));
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, invokeMethod);
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        if ((HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)dbType)) && HussarUtils.isNotEmpty((Object)(value = params.get("$REVERSE_CHILD")))) {
            String v = value.toString();
            params.put("$REVERSE_CHILD", v.toLowerCase());
        }
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> tableQueryAll(String appId, String formId) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TableQueryAll");
        return this.engineApiService.invokeByReturnEntity(businessId, null, new HashMap());
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> tableQueryByCondition(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TableQueryAll");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> tableQueryByConditionWithAuth(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TableQueryAll");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public void tableSave(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TableSave");
        this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public void saveBatchMore(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "SaveBatchMore");
        this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> formQuery(String appId, String formId, String id, boolean isOutLinkQuery, Map<String, Object> tableQueryParams) {
        String businessId = this.getBusinessId(HttpMethod.GET.name(), appId, formId, "FormQuery");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        if (isOutLinkQuery) {
            params.put("BC8D215A-26F1-9B83-4DE2-7867003DA241", "BC8D215A-26F1-9B83-4DE2-7867003DA241");
        }
        params.putAll(tableQueryParams);
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> formQueryFormRefer(String appId, String formId, String id) {
        String businessId = this.getBusinessId(HttpMethod.GET.name(), appId, formId, "FormQuery");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> formVerify(String appId, String formId, String id) {
        String businessId = this.getBusinessId(HttpMethod.GET.name(), appId, formId, "FormVerify");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> deleteBatch(String appId, String formId, String ids) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlagDeleteBatch");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ids", ids);
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> formSave(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FormSave");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> formIncrementSave(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FormIncrementSave");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(String appId, String formId, Map<String, Object> params) {
        Boolean isGetRevokeNode = Optional.ofNullable((Boolean)params.get("isGetRevokeNode")).orElse(false);
        String businessId = isGetRevokeNode != false ? this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowSubmitReject") : this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowFormSubmit");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> flowFormSubmits(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowStartAndSubmitBatch");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> flowFormRecall(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowFormRecall");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> initialNodeReject(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "InitialNodeReject");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> prevNodeReject(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "PrevNodeReject");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> anyNodeReject(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "AnyNodeReject");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> flowFormRejectBatch(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowRejectBatch");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> flowFormSubmitBatch(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowSubmitBatch");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> taskEntrust(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TaskEntrust");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> endProcess(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "EndProcess");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> flowEditAssignee(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "AddOrDelAssignee");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> flowFreeJump(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FreeJump");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }
}

