/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.GAUSSSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OracleTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.PGSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="JXDNOrgMulti")
public class JXDNOrgMulti
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleTypeEnum.CLOB.getTypeName());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.POSTGRE_SQL.name(), PGSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), GAUSSSqlTypeEnum.TEXT.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        fields.add(new DataModelFieldBase.Builder().withId(String.format("%s%s", name, "_id")).withName(String.format("%s%s", name, "_id")).withComment(String.format("%s%s", title, "_id")).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        fields.add(new DataModelFieldBase.Builder().withId(String.format("%s%s", name, "_label")).withName(String.format("%s%s", name, "_label")).withComment(String.format("%s%s", title, "_label")).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        return fields;
    }

    @Override
    public List<ModelFieldDto> withEngineField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<ModelFieldDto> fields = new ArrayList<ModelFieldDto>();
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(name);
        fieldDto.setFieldComment(title);
        fieldDto.setDefaultValue(null);
        fieldDto.setDataType(this.fieldDbType.get(dbType));
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.STRING.getValue());
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDto.setNeedChangeIsRequired(false);
        fieldDto.setPurpose(widget.getUsage());
        fieldDto.setRequired("0");
        fields.add(fieldDto);
        ModelFieldDto fieldDtoID = new ModelFieldDto();
        fieldDtoID.setFieldName(String.format("%s%s", name, "_id"));
        fieldDtoID.setFieldComment(String.format("%s%s", title, "_id"));
        fieldDtoID.setDefaultValue(null);
        fieldDtoID.setDataType(this.fieldDbType.get(dbType));
        fieldDtoID.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDtoID.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDtoID.setNeedChangeIsRequired(false);
        fieldDtoID.setPurpose(widget.getUsage());
        fieldDtoID.setRequired("0");
        fields.add(fieldDtoID);
        ModelFieldDto fieldDtoLabel = new ModelFieldDto();
        fieldDtoLabel.setFieldName(String.format("%s%s", name, "_label"));
        fieldDtoLabel.setFieldComment(String.format("%s%s", title, "_label"));
        fieldDtoLabel.setDefaultValue(null);
        fieldDtoLabel.setDataType(this.fieldDbType.get(dbType));
        fieldDtoLabel.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDtoLabel.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDtoLabel.setNeedChangeIsRequired(false);
        fieldDtoLabel.setPurpose(widget.getUsage());
        fieldDtoLabel.setRequired("0");
        fields.add(fieldDtoLabel);
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType, Widget widget) {
        return this.withField(dbType, widget).get(0);
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("derived", String.format("%s%s", this.widget.getName(), "_label"));
    }

    @Override
    public Object getModelByWidgetType(String name, Map<String, SysUsers> mapUserNameSysUsers, Map<String, OrganizationBo> mapOrganNameSysOrgans, Map<Long, List<RegionVo>> parentIdRegionVoMap, Integer addressLevel) {
        ArrayList<JSONObject> organs = new ArrayList<JSONObject>();
        if (HussarUtils.isEmpty((Object)name)) {
            return organs;
        }
        String[] lables = this.getLables(name);
        for (int i = 0; i < lables.length; ++i) {
            String label = lables[i];
            OrganizationBo sysOrgan = mapOrganNameSysOrgans.get(label);
            if (!HussarUtils.isNotEmpty((Object)sysOrgan)) continue;
            this.getOrgans(sysOrgan, organs);
        }
        return organs;
    }

    private void getOrgans(OrganizationBo sysOrgan, List<JSONObject> organs) {
        JSONObject organObject = new JSONObject();
        organObject.put("label", (Object)sysOrgan.getOrganName());
        organObject.put("id", (Object)String.valueOf(sysOrgan.getId()));
        organs.add(organObject);
    }

    private String[] getLables(String name) {
        String[] lables = name.contains(",") ? name.split(",") : (name.contains("\uff0c") ? name.split("\uff0c") : new String[]{name});
        return lables;
    }
}

