/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SysMiddleFileStorageService;
import com.jxdinfo.hussar.formdesign.no.code.model.SysMiddleFileStorage;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FileToDB {
    protected static final Logger logger = LoggerFactory.getLogger(FileToDB.class);
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private SysMiddleFileStorageService sysMiddleFileStorageService;
    @Resource
    private ISysFormService sysFormService;

    public void syncFileToDB() {
        try {
            String baseFolderPath = this.getBaseFolderPath();
            File baseFolder = new File(baseFolderPath);
            File[] appIds = baseFolder.listFiles(File::isDirectory);
            if (appIds != null) {
                for (File appId : appIds) {
                    this.processAppId(appId, "reference".equals(appId.getName()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteFile(File baseFolder) {
        File[] files;
        if (baseFolder.exists() && baseFolder.isDirectory() && (files = baseFolder.listFiles()) != null) {
            for (File file : files) {
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                if (!file.isDirectory() || "expPages".equals(file.getName())) continue;
                this.deleteFilesInFolder(file);
            }
        }
    }

    private void deleteFilesInFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.deleteFilesInFolder(file);
            }
        }
        folder.delete();
    }

    private String getBaseFolderPath() {
        String backProjectPath = this.formDesignProperties.getBackProjectPath();
        String noCodeStore = ".noCode-store";
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), backProjectPath, noCodeStore});
    }

    private void processAppId(File file, boolean referenceFlag) {
        String appId = file.getName();
        if (!referenceFlag) {
            List appIdList = this.sysFormService.getAllAppId();
            for (Long appIdDB : appIdList) {
                if (!String.valueOf(appIdDB).equals(appId)) continue;
                File[] folders = file.listFiles(File::isDirectory);
                if (folders == null) {
                    return;
                }
                List formIdList = this.sysFormService.getAllFormId(appIdDB);
                for (File folder : folders) {
                    String formName = folder.getName();
                    for (Long formId : formIdList) {
                        File[] innerFolders;
                        if (!formName.equals(String.valueOf(formId)) || (innerFolders = folder.listFiles(File::isDirectory)) == null) continue;
                        block13: for (File innerFolder : innerFolders) {
                            File[] jsonFiles = innerFolder.listFiles();
                            switch (innerFolder.getName()) {
                                case "canvas": {
                                    this.readFileAndSync2DB(jsonFiles, ".fd", "id", appId, innerFolder.getName());
                                    continue block13;
                                }
                                case "setting": {
                                    this.readFileAndSync2DB(jsonFiles, ".setting", "formId", appId, innerFolder.getName());
                                    continue block13;
                                }
                                case "view": {
                                    this.readFileAndSync2DB(jsonFiles, ".vd", "formId", appId, innerFolder.getName());
                                }
                            }
                        }
                    }
                }
                this.deleteFilesInFolder(file);
            }
        } else {
            File[] folders = file.listFiles(File::isDirectory);
            if (folders == null) {
                return;
            }
            for (File folder : folders) {
                File[] jsonFiles;
                for (File jsonFile : jsonFiles = folder.listFiles()) {
                    if (!jsonFile.getName().endsWith(".ref")) continue;
                    String jsonContent = this.readJsonFile(jsonFile);
                    JSONArray resultArray = JSONArray.parseArray((String)jsonContent);
                    for (Object item : resultArray) {
                        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"MIDDLE_FILE_INFO", (Object)JSON.toJSONString(item))).eq((Object)"FILE_TYPE", (Object)"reference")).eq((Object)"DEL_FLAG", (Object)"1");
                        SysMiddleFileStorage sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper));
                        if (!HussarUtils.isEmpty((Object)((Object)sysMiddleFileStorage))) continue;
                        sysMiddleFileStorage = new SysMiddleFileStorage();
                        sysMiddleFileStorage.setFileType("4");
                        sysMiddleFileStorage.setMiddleFileInfo(JSON.toJSONString(item));
                        sysMiddleFileStorage.setDelFlag("1");
                        this.sysMiddleFileStorageService.save((Object)sysMiddleFileStorage);
                    }
                }
            }
            this.deleteFilesInFolder(file);
        }
    }

    private Boolean readFileAndSync2DB(File[] folder, String suffix, String key, String appId, String name) {
        if (folder != null) {
            for (File jsonFile : folder) {
                String formId;
                Wrapper wrapper;
                SysMiddleFileStorage sysMiddleFileStorage;
                String jsonContent;
                JSONObject jsonObject;
                String fileType = "";
                switch (name) {
                    case "canvas": {
                        fileType = "1";
                        break;
                    }
                    case "setting": {
                        fileType = "2";
                        break;
                    }
                    case "view": {
                        fileType = "3";
                    }
                }
                if (!jsonFile.getName().endsWith(suffix) || !HussarUtils.isNotEmpty((Object)(jsonObject = JSONObject.parseObject((String)(jsonContent = this.readJsonFile(jsonFile))))) || !HussarUtils.isEmpty((Object)((Object)(sysMiddleFileStorage = (SysMiddleFileStorage)((Object)this.sysMiddleFileStorageService.getOne(wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)Long.parseLong(formId = jsonObject.getString(key)))).eq((Object)"FILE_TYPE", (Object)fileType)).eq((Object)"DEL_FLAG", (Object)"1"))))))) continue;
                sysMiddleFileStorage = new SysMiddleFileStorage();
                sysMiddleFileStorage.setAppId(Long.parseLong(appId));
                sysMiddleFileStorage.setFormId(Long.parseLong(formId));
                sysMiddleFileStorage.setMiddleFileInfo(jsonContent);
                sysMiddleFileStorage.setFileType(fileType);
                sysMiddleFileStorage.setDelFlag("1");
                this.sysMiddleFileStorageService.save((Object)sysMiddleFileStorage);
            }
        }
        return true;
    }

    private String readJsonFile(File jsonFile) {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(jsonFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new BaseException("\u8bfb\u53d6\u6587\u4ef6\u53d1\u751f\u5f02\u5e38");
        }
        return content.toString();
    }
}

