/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.factory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CanvasServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.PageBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PageBuilderFactory
implements InitializingBean,
ApplicationContextAware {
    private static final ConcurrentHashMap<String, PageBuilder> STRATEGY = new ConcurrentHashMap();
    private ApplicationContext context;
    private static String defaultViewSchema;
    private static String defaultFlowViewSchema;
    private static String processInfoWidgets;
    private static String processTaskInfoWidgets;
    private static String systemWidgets;
    private static String defaultSettingSchema;
    private static String defaultProcessBpmInternet;
    private static String taskProcessInfo;

    public static PageBuilder strategy(String strategy) {
        if (!STRATEGY.containsKey(strategy)) {
            throw new IllegalArgumentException("\u6a21\u578b\u7b56\u7565\u4e0d\u5b58\u5728\uff1a" + strategy);
        }
        return STRATEGY.get(strategy);
    }

    public void afterPropertiesSet() {
        this.context.getBeansOfType(PageBuilder.class).values().forEach(strategy -> STRATEGY.put(strategy.strategy(), (PageBuilder)strategy));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public static FormViewSchema getDefaultViewSchema() {
        if (HussarUtils.isEmpty((Object)defaultViewSchema)) {
            defaultViewSchema = ToolUtil.loadResource(ViewServiceImpl.class, (String)"/default_view_schema.json");
        }
        return (FormViewSchema)JSON.parseObject((String)defaultViewSchema, FormViewSchema.class);
    }

    public static FormViewSchema getDefaultFlowViewSchema() {
        if (HussarUtils.isEmpty((Object)defaultFlowViewSchema)) {
            defaultFlowViewSchema = ToolUtil.loadResource(ViewServiceImpl.class, (String)"/default_flow_view_schema.json");
        }
        return (FormViewSchema)JSON.parseObject((String)defaultFlowViewSchema, FormViewSchema.class);
    }

    public static List<Widget> getProcessInfoWidgets() {
        if (HussarUtils.isEmpty((Object)processInfoWidgets)) {
            processInfoWidgets = ToolUtil.loadResource(CanvasServiceImpl.class, (String)"/process_info_widgets.json");
        }
        return JSON.parseArray((String)processInfoWidgets, Widget.class);
    }

    public static List<Widget> getProcessTaskInfoWidgets() {
        if (HussarUtils.isEmpty((Object)processTaskInfoWidgets)) {
            processTaskInfoWidgets = ToolUtil.loadResource(CanvasServiceImpl.class, (String)"/process_task_info_widgets.json");
        }
        return JSON.parseArray((String)processTaskInfoWidgets, Widget.class);
    }

    public static List<Widget> getSystemWidgets() {
        if (HussarUtils.isEmpty((Object)systemWidgets)) {
            systemWidgets = ToolUtil.loadResource(PageBuilderFactory.class, (String)"/system_widgets.json");
        }
        return JSON.parseArray((String)systemWidgets, Widget.class);
    }

    public static FormSettingSchema getDefaultSettingSchema() {
        if (HussarUtils.isEmpty((Object)defaultSettingSchema)) {
            defaultSettingSchema = ToolUtil.loadResource(PageBuilderFactory.class, (String)"/default_setting_schema.json");
        }
        return (FormSettingSchema)((Object)JSON.parseObject((String)defaultSettingSchema, FormSettingSchema.class));
    }

    public static JSONObject getDefaultProcessBpmInternet() {
        if (HussarUtils.isEmpty((Object)defaultProcessBpmInternet)) {
            defaultProcessBpmInternet = ToolUtil.loadResource(PageBuilderFactory.class, (String)"/default_process_bpm_internet.json");
        }
        return JSON.parseObject((String)defaultProcessBpmInternet);
    }

    public static String getTaskProcessInfo() {
        if (HussarUtils.isEmpty((Object)taskProcessInfo)) {
            taskProcessInfo = ToolUtil.loadResource(PageBuilderFactory.class, (String)"/task/process_info.json");
        }
        return taskProcessInfo;
    }
}

