/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class FormCanvasUtil {
    public static void getFieldControl(List<Widget> widgets, List<FieldControl> addOrEdit) {
        ArrayList delControls = new ArrayList();
        CollectionUtils.addAll(delControls, (Object[])new Object[addOrEdit.size()]);
        Collections.copy(delControls, addOrEdit);
        for (Widget widget : widgets) {
            boolean isRepeat = false;
            for (FieldControl control : addOrEdit) {
                if (!control.getField().equals(widget.getName())) continue;
                control.setTitle(widget.getTitle());
                control.setInChild(widget.getIsInChild());
                isRepeat = true;
                delControls.remove(control);
                if (!WidgetTool.isChildrenTable(widget)) break;
                if (HussarUtils.isEmpty((Object)control.getChildren())) {
                    control.setChildren(new ArrayList());
                }
                FormCanvasUtil.getFieldControl(widget.getChildren(), control.getChildren());
                break;
            }
            if (isRepeat) continue;
            FieldControl control = new FieldControl();
            control.setField(widget.getName());
            control.setType(widget.getType());
            control.setTitle(widget.getTitle());
            control.setReadOnly(widget.isReadOnly());
            control.setVisible(true);
            control.setWitable(true);
            control.setRequired(false);
            control.setInChild(widget.getIsInChild());
            if (WidgetTool.isChildrenTable(widget)) {
                control.setChildren(new ArrayList());
                FormCanvasUtil.getFieldControl(widget.getChildren(), control.getChildren());
            }
            addOrEdit.add(control);
        }
        if (HussarUtils.isNotEmpty(delControls)) {
            addOrEdit.removeAll(delControls);
        }
    }

    public static void sortFieldControl(List<FieldControl> fieldControls, List<String> orders) {
        fieldControls.sort((o1, o2) -> {
            int io1 = orders.indexOf(o1.getField());
            int io2 = orders.indexOf(o2.getField());
            if (io1 == -1 && io2 == -1) {
                return 0;
            }
            if (io1 == -1 || io2 == -1) {
                return io1 == -1 ? 1 : -1;
            }
            return Integer.compare(io1, io2);
        });
    }

    public static void dealUseExistingRule(FormCanvasSchema formCanvasSchema) {
        if (HussarUtils.isEmpty(formCanvasSchema.getWidgets())) {
            return;
        }
        List serialWidgets = WidgetTool.flatAllWidget(formCanvasSchema.getWidgets()).stream().filter(item -> HussarUtils.equals((Object)item.getType(), (Object)WidgetType.JXDNSerialNumber.getType())).collect(Collectors.toList());
        for (Widget widget : serialWidgets) {
            JSONObject props = widget.getProps();
            if (!"existing".equals(props.getString("defaultRule"))) continue;
            String ruleCodeId = props.getString("defaultRuleExisting");
            ISysCodeRuleService iSysCodeRuleService = (ISysCodeRuleService)SpringUtil.getBean(ISysCodeRuleService.class);
            ApiResponse pageApiResponse = iSysCodeRuleService.getCodeRule(Long.valueOf(ruleCodeId));
            SysCodeRuleVo record = (SysCodeRuleVo)pageApiResponse.getData();
            if (!HussarUtils.isEmpty((Object)record)) continue;
            props.put("defaultRule", (Object)"custom");
            props.put("defaultRuleExisting", (Object)"");
            props.put("defaultRuleExistingLabel", (Object)"");
            props.put("ruleCode", (Object)"");
            List serialNumRuleDTOS = JsonParser.array(widget, "$.props.rules", SerialNumRuleDTO.class).orElse(null);
            if (!ToolUtil.isNotEmpty((Object)serialNumRuleDTOS)) continue;
            for (SerialNumRuleDTO serialNumRuleDTO : serialNumRuleDTOS) {
                serialNumRuleDTO.getConfig().setId(null);
            }
            JSONPath.set((Object)widget, (String)"$.props.rules", (Object)serialNumRuleDTOS);
        }
    }
}

