/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.button.vo.SysCustomButtonVo;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormCheckConfigDto;
import com.jxdinfo.hussar.formdesign.application.form.model.BriefReference;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormReferenceService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormCheckConfigVo;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLink;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkOpen;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkSingleStatus;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkOpenService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleStatusService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extension.api.dto.canvas.FormCanvasSchemaDto;
import com.jxdinfo.hussar.formdesign.extension.api.service.ICanvasHookService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.util.FormCanvasUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.util.HookUtil;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineOperationType;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ReferenceService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.ResourceReference;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.CanvasScriptRefer;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleConfig;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleQueryVO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.SummarySchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.staff.StaffScopeHistory;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.EngineDataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.EngineModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNSerialNumber;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelSaveDto;
import com.jxdinfo.hussar.support.engine.api.service.ModelSaveService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class CanvasServiceImpl
implements CanvasService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanvasServiceImpl.class);
    private static final String SCRIPTSREFER_KEY = "scriptsRefer";
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private ISysCustomButtonService customButtonService;
    @Resource
    private ViewService viewService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private ISysApplicationExternalService appExternalService;
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    @Resource
    private ReferenceService referenceService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private ISysFormLinkSingleStatusService sysFormLinkSingleStatusService;
    @Resource
    private ISysFormLinkOpenService sysFormLinkOpenService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private IFormReferenceService formReferenceService;
    @Autowired(required=false)
    private ICanvasHookService iCanvasHookService;
    @Resource
    private ModelSaveService modelSaveService;
    @Resource
    private HookUtil hookUtil;

    @Override
    @HussarTransactional
    public FormDesignResponse<Boolean> saveCanvas(FormCanvasSchema newCanvas) throws Exception {
        long start = System.currentTimeMillis();
        newCanvas = this.beforeSaveCanvas(newCanvas);
        newCanvas.setPrimaryKey("RECORD_ID");
        final FormSchema formSchemaOld = (FormSchema)this.formOperateService.get(newCanvas.getId()).getData();
        final FormCanvasSchema oldCanvas = formSchemaOld.getFormCanvas();
        if (HussarUtils.isEmpty((Object)((Object)oldCanvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u4fe1\u606f\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)newCanvas.getId());
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u4fe1\u606f\u5931\u8d25");
        }
        if (HussarUtils.isNotEmpty((Object)oldCanvas.getId()) && newCanvas.getVersion() <= oldCanvas.getVersion()) {
            ToolUtil.getLogger(this.getClass()).error("\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u52ff\u591a\u7a97\u53e3\u7f16\u8f91\u6216\u8005\u591a\u4eba\u540c\u65f6\u7f16\u8f91\uff0c\u8bf7\u5237\u65b0\u6d4f\u89c8\u5668\u91cd\u8bd5\uff01 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)newCanvas.getId());
            return FormDesignResponse.fail((Object)false, (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u52ff\u591a\u7a97\u53e3\u7f16\u8f91\u6216\u8005\u591a\u4eba\u540c\u65f6\u7f16\u8f91\uff0c\u8bf7\u5237\u65b0\u6d4f\u89c8\u5668\u91cd\u8bd5\uff01");
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCompletion(int status) {
                if (status == 0) {
                    return;
                }
                try {
                    CanvasServiceImpl.this.canvasSchemaService.saveOrUpdate(oldCanvas);
                    CanvasServiceImpl.this.viewSchemaService.saveOrUpdate(formSchemaOld.getView());
                    SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
                    settingSchemaService.saveOrUpdate(formSchemaOld.getSetting(), formSchemaOld.getFormCanvas().getId());
                }
                catch (Exception e) {
                    LOGGER.error("\u56de\u6eda\u753b\u5e03\u6570\u636e\u9519\u8bef\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
            }
        });
        this.cascade(newCanvas, oldCanvas);
        FormDesignResponse<FormSchema> form = this.formOperateService.get(newCanvas.getId());
        if ("custom".equals(((FormSchema)form.getData()).getSetting().getDataTitle().getMode())) {
            List<TitleParam> dataTitles = ((FormSchema)form.getData()).getSetting().getDataTitle().getParams();
            List widgets = (List)this.formOperateService.widgetsForSetting(null, newCanvas.getId(), true).getData();
            Boolean hasWidgets = CollectionUtils.isNotEmpty((Collection)widgets);
            String custom = ((FormSchema)form.getData()).getSetting().getDataTitle().getCustom();
            Boolean hasCustom = custom != null;
            Iterator<TitleParam> iterator = dataTitles.iterator();
            while (iterator.hasNext()) {
                TitleParam dataTitle = iterator.next();
                boolean isDel = true;
                if ("formName".equals(dataTitle.getId())) continue;
                if (hasWidgets.booleanValue()) {
                    for (WidgetField widget : widgets) {
                        if (!dataTitle.getId().equals(widget.getName())) continue;
                        isDel = false;
                        break;
                    }
                }
                if (!isDel) continue;
                iterator.remove();
                if (!hasCustom.booleanValue()) continue;
                String delcustom = "${" + dataTitle.getId() + "}";
                custom = custom.replace(delcustom, "");
            }
            if (!custom.equals(((FormSchema)form.getData()).getSetting().getDataTitle().getCustom())) {
                ((FormSchema)form.getData()).getSetting().getDataTitle().setParams(dataTitles);
                ((FormSchema)form.getData()).getSetting().getDataTitle().setCustom(custom);
                SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.title", SettingSchemaService.class);
                FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(((FormSchema)form.getData()).getSetting().getDataTitle(), newCanvas.getId());
                if (!((Boolean)updateForm.getData()).booleanValue()) {
                    ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6807\u9898\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)newCanvas.getId());
                    return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6807\u9898\u5931\u8d25");
                }
            }
        }
        this.updateTableAndSync(EngineOperationType.UPDATE.getOperationType(), (FormSchema)form.getData(), formSchemaOld);
        ToolUtil.getLogger(CanvasServiceImpl.class).info("\u4fdd\u5b58\u753b\u5e03\u8017\u65f6\uff1a{}", (Object)ToolUtil.logTime((long)start));
        Long formId = Long.valueOf(newCanvas.getId());
        ToolUtil.getLogger(CanvasServiceImpl.class).info("\u521d\u59cb\u5316\u8868\u5355\u5916\u94fe\u76f8\u5173\u5b57\u6bb5\u6743\u9650\u5f00\u59cb\uff0c\u8868\u5355id\uff1a{}", (Object)formId);
        this.sysFormLinkService.initFormLinkField(formId);
        this.sysFormLinkSingleStatusService.initFormLinkSingleField(formId.longValue());
        this.sysFormLinkOpenService.getShowList(formId);
        ToolUtil.getLogger(CanvasServiceImpl.class).info("\u521d\u59cb\u5316\u8868\u5355\u5916\u94fe\u76f8\u5173\u5b57\u6bb5\u6743\u9650\u7ed3\u675f\uff0c\u8868\u5355id\uff1a{}", (Object)formId);
        this.checkSecrecySetOutLink(newCanvas);
        newCanvas = this.afterSaveCanvas(newCanvas);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public void updateTableAndSync(String operationType, FormSchema formSchema, FormSchema oldForm) throws Exception {
        LOGGER.info("=================\u5f00\u59cb\u8c03\u7528\u89e3\u6790\u5f15\u64ce\u6574\u5408\u63a5\u53e3\uff1a\u8868\u5355ID-[{}]=============", (Object)formSchema.getFormCanvas().getId());
        EngineDataModelBuilder dataModelBuilder = EngineModelBuilderAdapter.adaptBuilder(formSchema);
        ModelInfoDto modelInfoDto = dataModelBuilder.direct(operationType, oldForm);
        if (HussarUtils.isEmpty((Object)modelInfoDto.getIndexList())) {
            modelInfoDto.setIndexList((List)Lists.newArrayListWithExpectedSize((int)0));
        }
        this.checkModelParam(modelInfoDto);
        ModelSaveDto modelSaveDto = new ModelSaveDto();
        ArrayList modelInfoDtos = Lists.newArrayListWithCapacity((int)1);
        modelInfoDtos.add(modelInfoDto);
        modelSaveDto.setSaveModelList((List)modelInfoDtos);
        long startT = System.currentTimeMillis();
        this.modelSaveService.saveModel(modelSaveDto);
        LOGGER.info("=================\u7ed3\u675f\u8c03\u7528\u89e3\u6790\u5f15\u64ce\u6574\u5408\u63a5\u53e3\uff1a\u8868\u5355ID-[{}],\u8017\u65f6{}ms=============", (Object)formSchema.getFormCanvas().getId(), (Object)(System.currentTimeMillis() - startT));
    }

    private void checkModelParam(ModelInfoDto modelInfoDto) {
        List fieldList = modelInfoDto.getFieldList();
        HashSet<String> uniqueFieldNames = new HashSet<String>();
        for (ModelFieldDto field : fieldList) {
            if (uniqueFieldNames.add(field.getFieldName())) continue;
            throw new HussarException("\u5b57\u6bb5\u540d\u79f0\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6b63\u5b57\u6bb5\u540d\u79f0\u914d\u7f6e\u3002");
        }
        List children = modelInfoDto.getChildren();
        if (HussarUtils.isNotEmpty((Object)children)) {
            children.forEach(this::checkModelParam);
        }
    }

    private void addDefaultSort(FormCanvasSchema newCanvas, FormViewSchema formViewSchema) {
        FormViewSchema viewSchema = new FormViewSchema();
        if ("0".equals(newCanvas.getFormType())) {
            viewSchema = PageBuilderFactory.getDefaultViewSchema();
        }
        if ("1".equals(newCanvas.getFormType())) {
            viewSchema = PageBuilderFactory.getDefaultFlowViewSchema();
        }
        List<DataView> sysViews = viewSchema.getViews();
        ArrayList<String> widgetNames = new ArrayList<String>();
        for (Widget widget : newCanvas.widgets()) {
            widgetNames.add(widget.getName());
        }
        for (DataView view : formViewSchema.getViews()) {
            List<String> sysFields = new ArrayList<String>();
            Optional<List> showFields1 = sysViews.stream().filter(x -> HussarUtils.equals((Object)view.getId(), (Object)x.getId())).findFirst().map(x -> x.getShowFields());
            if (showFields1.isPresent()) {
                sysFields = showFields1.get().stream().map(ShowField::getName).collect(Collectors.toList());
            }
            sysFields.addAll(HussarUtils.isNotEmpty(widgetNames) ? widgetNames : new ArrayList<String>());
            ArrayList<String> showFields = sysFields;
            List orderBys = view.getOrderBy();
            orderBys.removeIf(orderBy -> !HussarUtils.contains(showFields.iterator(), (Object)orderBy.getColumn().split("_label")[0]));
            if (!HussarUtils.isEmpty((Object)orderBys)) continue;
            OrderItem createTime = new OrderItem();
            createTime.setColumn("createTime_date");
            createTime.setAsc(false);
            ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
            orderItems.add(createTime);
            view.setOrderBy(orderItems);
        }
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId, SysForm form) {
        ApiResponse formCheckConfig;
        SettingSchemaService settingSchemaService;
        FormDesignResponse submitSchemaFormDesignResponse;
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(formId, form);
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvasSchema))) {
            return FormDesignResponse.success((Object)((Object)new FormCanvasSchema()));
        }
        if (HussarUtils.isEmpty((Object)canvasSchema.getTitle()) || HussarUtils.isEmpty((Object)canvasSchema.getIcon())) {
            canvasSchema.setTitle(form.getFormName());
            canvasSchema.setIcon(form.getFormIcon());
        }
        if (HussarUtils.isEmpty((Object)canvasSchema.getProps().get("submitSchema")) && HussarUtils.isNotEmpty((Object)(submitSchemaFormDesignResponse = (settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.submit", SettingSchemaService.class)).get(formId)).getData())) {
            canvasSchema.getProps().put("submitSchema", JSONObject.toJSON((Object)submitSchemaFormDesignResponse.getData()));
        }
        if ((formCheckConfig = this.sysFormCheckConfigService.getFormCheckConfig(Long.valueOf(formId))).isSuccess() && HussarUtils.isNotEmpty((Object)formCheckConfig.getData())) {
            String checkConfig = ((SysFormCheckConfigVo)formCheckConfig.getData()).getCheckConfig();
            JSONObject sysFormCheckConfig = (JSONObject)JSONObject.toJSON((Object)formCheckConfig.getData());
            JSONArray checkConfigs = JSON.parseArray((String)checkConfig);
            sysFormCheckConfig.put("checkConfig", (Object)checkConfigs);
            canvasSchema.getProps().put("sysFormCheckConfig", sysFormCheckConfig);
        } else {
            SysFormCheckConfigVo sysFormCheckConfigVo = new SysFormCheckConfigVo();
            sysFormCheckConfigVo.setFormId(Long.valueOf(formId));
            JSONObject sysFormCheckConfig = (JSONObject)JSONObject.toJSON((Object)sysFormCheckConfigVo);
            sysFormCheckConfig.put("checkConfig", (Object)new JSONArray());
            canvasSchema.getProps().put("sysFormCheckConfig", sysFormCheckConfig);
        }
        this.dealOldWidget(canvasSchema);
        return FormDesignResponse.success((Object)((Object)canvasSchema));
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId) {
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(formId));
        return this.get(formId, form);
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(SysForm form) {
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(form);
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvasSchema))) {
            return FormDesignResponse.success((Object)((Object)new FormCanvasSchema()));
        }
        return this.wrapFormCanvasSchema(canvasSchema, Long.toString(form.getId()));
    }

    private FormDesignResponse<FormCanvasSchema> wrapFormCanvasSchema(FormCanvasSchema canvasSchema, String formId) {
        ApiResponse formCheckConfig;
        SettingSchemaService settingSchemaService;
        FormDesignResponse submitSchemaFormDesignResponse;
        if (HussarUtils.isEmpty((Object)canvasSchema.getTitle()) || HussarUtils.isEmpty((Object)canvasSchema.getIcon())) {
            SysForm form = this.appExternalService.getFormDetailById(Long.valueOf(formId));
            canvasSchema.setTitle(form.getFormName());
            canvasSchema.setIcon(form.getFormIcon());
        }
        if (HussarUtils.isEmpty((Object)canvasSchema.getProps().get("submitSchema")) && HussarUtils.isNotEmpty((Object)(submitSchemaFormDesignResponse = (settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.submit", SettingSchemaService.class)).get(formId)).getData())) {
            canvasSchema.getProps().put("submitSchema", JSONObject.toJSON((Object)submitSchemaFormDesignResponse.getData()));
        }
        if ((formCheckConfig = this.sysFormCheckConfigService.getFormCheckConfig(Long.valueOf(formId))).isSuccess() && HussarUtils.isNotEmpty((Object)formCheckConfig.getData())) {
            String checkConfig = ((SysFormCheckConfigVo)formCheckConfig.getData()).getCheckConfig();
            JSONObject sysFormCheckConfig = (JSONObject)JSONObject.toJSON((Object)formCheckConfig.getData());
            JSONArray checkConfigs = JSON.parseArray((String)checkConfig);
            sysFormCheckConfig.put("checkConfig", (Object)checkConfigs);
            canvasSchema.getProps().put("sysFormCheckConfig", sysFormCheckConfig);
        } else {
            SysFormCheckConfigVo sysFormCheckConfigVo = new SysFormCheckConfigVo();
            sysFormCheckConfigVo.setFormId(Long.valueOf(formId));
            JSONObject sysFormCheckConfig = (JSONObject)JSONObject.toJSON((Object)sysFormCheckConfigVo);
            sysFormCheckConfig.put("checkConfig", (Object)new JSONArray());
            canvasSchema.getProps().put("sysFormCheckConfig", sysFormCheckConfig);
        }
        return FormDesignResponse.success((Object)((Object)canvasSchema));
    }

    @Override
    public FormDesignResponse<Boolean> resetFieldControl(FormCanvasSchema canvas) throws Exception {
        return this.updateFieldControl(canvas, null);
    }

    @Override
    public void saveCanvasForImport(FormCanvasSchema newCanvas, ImportMappingDto importMappingDto) throws Exception {
        this.saveCodeRule(newCanvas);
        if (FormCreateTypeEnum.TABLE_TO_FORM.getType().equals(newCanvas.getCreateSource())) {
            newCanvas.setCreateSource(null);
        }
        this.canvasSchemaService.saveOrUpdate(newCanvas);
        String formId = newCanvas.getId();
        List<Widget> widgets = newCanvas.widgets();
        for (Widget childTable : newCanvas.childTables()) {
            widgets.addAll(childTable.getChildren());
        }
        this.saveNewestScope(formId, widgets);
        this.saveReference(newCanvas, null);
    }

    @Override
    public void saveCanvasForUpgrade(FormCanvasSchema newCanvas, ImportMappingDto importMappingDto) throws Exception {
        this.saveCodeRule(newCanvas);
        this.canvasSchemaService.saveOrUpdate(newCanvas);
        String formId = newCanvas.getId();
        List<Widget> widgets = newCanvas.widgets();
        for (Widget childTable : newCanvas.childTables()) {
            widgets.addAll(childTable.getChildren());
        }
        this.saveNewestScope(formId, widgets);
        this.saveReference(newCanvas, null);
    }

    @Override
    public void dealOldWidget(FormCanvasSchema Canvas2) {
        List<Widget> originals = Canvas2.getWidgets();
        if (HussarUtils.isNotEmpty(originals)) {
            this.dealSubTableOrder(originals);
            for (Widget widget : originals) {
                if ("JXDNGraphicDisplay".equals(widget.getType())) {
                    widget.setIsRealField(true);
                    widget.setVirtualField(true);
                }
                if ("JXDNChildrenTable".equals(widget.getType()) || "JXDNChildrenTableAgg".equals(widget.getType())) {
                    List<Widget> children = widget.getChildren();
                    this.dealSubTableOrder(children);
                    for (Widget child : children) {
                        if ("createUser_user".equals(child.getName())) {
                            child.setTitle("\u521b\u5efa\u4eba\u6807\u8bc6");
                        }
                        if (!"updateUser_user".equals(child.getName())) continue;
                        child.setTitle("\u4fee\u6539\u4eba\u6807\u8bc6");
                    }
                }
                this.dealOldWidgetRecursion(widget);
            }
        }
    }

    @Override
    public void dealOldWidgetRecursion(Widget widget) {
        List<Widget> children;
        if (HussarUtils.isNotEmpty((Object)widget) && HussarUtils.isNotEmpty(children = widget.getChildren())) {
            for (Widget child : children) {
                if ("JXDNGraphicDisplay".equals(child.getType())) {
                    child.setIsRealField(true);
                    child.setVirtualField(true);
                }
                if ("JXDNChildrenTable".equals(child.getType()) || "JXDNChildrenTableAgg".equals(child.getType())) {
                    this.dealSubTableOrder(child.getChildren());
                    for (Widget newchild : child.getChildren()) {
                        if ("createUser_user".equals(newchild.getName())) {
                            newchild.setTitle("\u521b\u5efa\u4eba\u6807\u8bc6");
                        }
                        if (!"updateUser_user".equals(newchild.getName())) continue;
                        newchild.setTitle("\u4fee\u6539\u4eba\u6807\u8bc6");
                    }
                }
                this.dealOldWidgetRecursion(child);
            }
        }
    }

    @Override
    public void dealSubTableOrder(List<Widget> widgets) {
        if (HussarUtils.isNotEmpty(widgets)) {
            List filteredWidgets = widgets.stream().filter(widget -> widget.getUsage() != null && !"".equals(widget.getUsage())).collect(Collectors.toList());
            widgets.removeAll(filteredWidgets);
            List<String> fixedNameOrder = Arrays.asList("createUser_user", "createUserName", "updateUser_user", "updateUserName", "createTime_date", "updateTime_date", "post", "postName", "dataOrgan", "dataOrganName", "staff", "securityLevel");
            HashMap<String, Integer> nameToIndex = new HashMap<String, Integer>();
            for (int i = 0; i < fixedNameOrder.size(); ++i) {
                nameToIndex.put(fixedNameOrder.get(i), i);
            }
            List sortedWidgets = filteredWidgets.stream().sorted(Comparator.comparingInt(w -> nameToIndex.getOrDefault(w.getName(), Integer.MAX_VALUE))).collect(Collectors.toList());
            widgets.addAll(sortedWidgets);
        }
    }

    @Override
    public FormDesignResponse<CanvasScriptRefer> getScriptConfigRefer(long formId) {
        ApiResponse buttons;
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)this.canvasService.get(String.valueOf(formId)).getData());
        if (ToolUtil.isEmpty((Object)((Object)canvasSchema))) {
            return FormDesignResponse.success(null);
        }
        CanvasScriptRefer canvasScriptRefer = new CanvasScriptRefer();
        canvasScriptRefer.setCanvasRefer(ToolUtil.isNotEmpty((Object)canvasSchema.getProps().get(SCRIPTSREFER_KEY)) ? (Map)canvasSchema.getProps().get(SCRIPTSREFER_KEY) : null);
        FormViewSchema viewSchema = (FormViewSchema)this.viewService.get(String.valueOf(formId)).getData();
        if (ToolUtil.isNotEmpty((Object)viewSchema) && ToolUtil.isNotEmpty(viewSchema.getViews())) {
            List<DataView> views = viewSchema.getViews();
            ArrayList<Map<String, Object>> viewRefer = new ArrayList<Map<String, Object>>();
            for (DataView view : views) {
                JSONArray scriptsRefers;
                Object scriptsRefersObj = ToolUtil.isEmpty((Object)view.getConfigs()) ? null : view.getConfigs().get(SCRIPTSREFER_KEY);
                if (null == scriptsRefersObj) continue;
                if (scriptsRefersObj instanceof JSONArray) {
                    scriptsRefers = scriptsRefersObj;
                    for (Object scriptRefer : scriptsRefers) {
                        viewRefer.add((Map)scriptRefer);
                    }
                    continue;
                }
                if (!(scriptsRefersObj instanceof JSONObject)) continue;
                scriptsRefers = scriptsRefersObj;
                viewRefer.add((Map<String, Object>)scriptsRefers);
            }
            canvasScriptRefer.setViewRefer(viewRefer);
        }
        if (ToolUtil.isNotEmpty((Object)(buttons = this.customButtonService.listSysCustomButtonByFormId(Long.valueOf(formId))).getData())) {
            ArrayList<Map<String, Object>> customRefer = new ArrayList<Map<String, Object>>();
            for (SysCustomButtonVo btn : (List)buttons.getData()) {
                customRefer.add(ToolUtil.isNotEmpty((Object)btn.getCustomAction().get((Object)SCRIPTSREFER_KEY)) ? (Map)btn.getCustomAction().get((Object)SCRIPTSREFER_KEY) : null);
            }
            canvasScriptRefer.setCustomRefer(customRefer);
        }
        return FormDesignResponse.success((Object)canvasScriptRefer);
    }

    @Override
    public ApiResponse<Page<SerialNumRuleQueryVO>> getListCodeRules(ApiResponse<Page<SysCodeRuleVo>> sysCodeRuleVo) {
        if (HussarUtils.isEmpty(sysCodeRuleVo) || HussarUtils.isEmpty((Object)sysCodeRuleVo.getData())) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u6d41\u6c34\u53f7\u89c4\u5219");
        }
        List records = ((Page)sysCodeRuleVo.getData()).getRecords();
        Page serialNumRuleQueryVOPage = new Page();
        if (HussarUtils.isEmpty((Object)records)) {
            return ApiResponse.success((Object)serialNumRuleQueryVOPage, (String)"\u672a\u67e5\u8be2\u5230\u6d41\u6c34\u53f7\u89c4\u5219");
        }
        List<Object> newRecords = new ArrayList();
        try {
            newRecords = records.stream().map(this::convertToSerialNumRuleQueryVO).collect(Collectors.toList());
        }
        catch (ClassCastException e) {
            List mapList = JSON.parseArray((String)JSONObject.toJSONString((Object)records), JSONObject.class);
            newRecords = mapList.stream().map(map -> {
                SysCodeRuleVo codeRuleVo = new SysCodeRuleVo();
                codeRuleVo.setCodeRuleId(map.getLong("codeRuleId"));
                codeRuleVo.setCodeRuleCode(map.getString("codeRuleCode"));
                codeRuleVo.setCodeRuleName(map.getString("codeRuleName"));
                codeRuleVo.setCodeRuleDesc(map.getString("codeRuleDesc"));
                codeRuleVo.setSys(map.getString("sys"));
                codeRuleVo.setLevel(map.getString("level"));
                codeRuleVo.setCreateTime((LocalDateTime)JSON.parseObject((String)JSONObject.toJSONString((Object)map.get((Object)"createTime")), LocalDateTime.class));
                codeRuleVo.setCreator(map.getLong("creator"));
                codeRuleVo.setLastTime((LocalDateTime)JSON.parseObject((String)JSONObject.toJSONString((Object)map.get((Object)"lastTime")), LocalDateTime.class));
                codeRuleVo.setLastEditor(map.getLong("lastEditor"));
                if (HussarUtils.isNotEmpty((Object)map.get((Object)"sysCodeRuleInfoList"))) {
                    codeRuleVo.setSysCodeRuleInfoList(JSON.parseArray((String)JSONObject.toJSONString((Object)map.get((Object)"sysCodeRuleInfoList")), SysCodeRuleInfo.class));
                }
                return codeRuleVo;
            }).collect(Collectors.toList()).stream().map(this::convertToSerialNumRuleQueryVO).collect(Collectors.toList());
        }
        serialNumRuleQueryVOPage.setRecords(newRecords);
        return ApiResponse.success((Object)serialNumRuleQueryVOPage);
    }

    private SerialNumRuleQueryVO convertToSerialNumRuleQueryVO(SysCodeRuleVo record) {
        SerialNumRuleQueryVO newRecord = new SerialNumRuleQueryVO();
        newRecord.setCodeRuleId(record.getCodeRuleId());
        newRecord.setCodeRuleCode(record.getCodeRuleCode());
        newRecord.setCodeRuleName(record.getCodeRuleName());
        newRecord.setCodeRuleDesc(record.getCodeRuleDesc());
        newRecord.setSys(record.getSys());
        newRecord.setLevel(record.getLevel());
        newRecord.setCreateTime(record.getCreateTime());
        newRecord.setCreator(record.getCreator());
        newRecord.setLastTime(record.getLastTime());
        newRecord.setLastEditor(record.getLastEditor());
        List<SerialNumRuleDTO> rules = record.getSysCodeRuleInfoList().stream().map(this::convertToSerialNumRuleDTO).collect(Collectors.toList());
        newRecord.setRules(rules);
        return newRecord;
    }

    private SerialNumRuleDTO convertToSerialNumRuleDTO(SysCodeRuleInfo sysCodeRuleInfo) {
        SerialNumRuleDTO serialNumRuleDTO = new SerialNumRuleDTO();
        SerialNumRuleConfig config = new SerialNumRuleConfig();
        String type = sysCodeRuleInfo.getElementType();
        serialNumRuleDTO.setType(type);
        switch (type) {
            case "variable": {
                serialNumRuleDTO.setName(sysCodeRuleInfo.getElementPattern());
                serialNumRuleDTO.setType("field");
                config.setValue("");
                config.setLengthFixed(false);
                break;
            }
            case "serialNumber": {
                serialNumRuleDTO.setName(type);
                serialNumRuleDTO.setLabel("\u81ea\u52a8\u8ba1\u6570");
                serialNumRuleDTO.setType(type);
                config.setLengthFixed(true);
                config.setCountLength(sysCodeRuleInfo.getSerialNumberLength());
                config.setInitialVal(sysCodeRuleInfo.getSerialNumberStart());
                config.setResetType("1");
                break;
            }
            case "constant": {
                serialNumRuleDTO.setName(type);
                serialNumRuleDTO.setLabel("\u56fa\u5b9a\u5b57\u7b26");
                serialNumRuleDTO.setType(type);
                config.setValue(sysCodeRuleInfo.getElementPattern());
                config.setLengthFixed(false);
                break;
            }
            case "codeDateTime": {
                serialNumRuleDTO.setName(type);
                serialNumRuleDTO.setLabel("\u63d0\u4ea4\u65e5\u671f");
                serialNumRuleDTO.setType(type);
                config.setValue(sysCodeRuleInfo.getElementPattern());
                config.setLengthFixed(false);
                break;
            }
            default: {
                serialNumRuleDTO.setName(type);
                serialNumRuleDTO.setType(type);
                config.setValue(type);
                config.setLengthFixed(false);
                if (sysCodeRuleInfo.getElementPattern() != null) {
                    config.setCountLength(Integer.valueOf(sysCodeRuleInfo.getElementPattern()));
                    break;
                }
                config.setCountLength(0);
            }
        }
        config.setId(sysCodeRuleInfo.getId());
        serialNumRuleDTO.setConfig(config);
        return serialNumRuleDTO;
    }

    private void cascade(FormCanvasSchema newCanvas, FormCanvasSchema oldCanvas) throws Exception {
        FormDesignResponse<Boolean> summaryRes;
        FormDesignResponse<Boolean> fieldControlRes;
        FormDesignResponse<Boolean> viewRes;
        this.saveCodeRule(newCanvas);
        this.saveFormCheckConfig(newCanvas);
        FormDesignResponse<Boolean> updateForm = this.canvasSchemaService.saveOrUpdate(newCanvas);
        String formId = newCanvas.getId();
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u66f4\u65b0\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        }
        if (!((Boolean)(viewRes = this.updateView(newCanvas, oldCanvas)).getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u66f4\u65b0\u89c6\u56fe\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        }
        if (!((Boolean)(fieldControlRes = this.updateFieldControl(newCanvas)).getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u66f4\u65b0\u5b57\u6bb5\u63a7\u5236\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        }
        if (!((Boolean)(summaryRes = this.updateDataSummary(newCanvas)).getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u66f4\u65b0\u6570\u636e\u6458\u8981\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        }
        this.deleteFieldCallback(newCanvas, oldCanvas);
        List<Widget> widgets = newCanvas.widgets();
        for (Widget childTable : newCanvas.childTables()) {
            widgets.addAll(childTable.getChildren());
        }
        this.saveNewestScope(formId, widgets);
        this.saveReference(newCanvas, oldCanvas);
    }

    private FormDesignResponse<Boolean> updateView(FormCanvasSchema newCanvas, FormCanvasSchema oldCanvas) throws Exception {
        FormViewSchema viewSchema = (FormViewSchema)this.viewSchemaService.get(newCanvas.getId()).getData();
        if (HussarUtils.isEmpty((Object)viewSchema)) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u89c6\u56fe\u4e3a\u7a7a\u5bfc\u81f4\u7ea7\u8054\u66f4\u65b0\u89c6\u56fe\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)newCanvas.getId());
        }
        List<Widget> newWidgets = newCanvas.widgetsWithSys();
        newWidgets.addAll(newCanvas.childTables());
        List<Widget> oldWidgets = oldCanvas.widgetsWithSys();
        oldWidgets.addAll(oldCanvas.childTables());
        List<Widget> newFilterWidgets = WidgetTool.settingWidgets(newWidgets, widget -> WidgetTool.anyMatch(widget.getType(), WidgetType.JXDNEmbed.getType(), WidgetType.JXDNGraphicDisplay.getType()) || WidgetTool.anyMatch(widget.getName(), WidgetTool.showFieldsExcludeFields()));
        List<Widget> oldFilterWidgets = WidgetTool.settingWidgets(oldWidgets, widget -> WidgetTool.anyMatch(widget.getType(), WidgetType.JXDNEmbed.getType(), WidgetType.JXDNGraphicDisplay.getType()) || WidgetTool.anyMatch(widget.getName(), WidgetTool.showFieldsExcludeFields()));
        Changes changes = this.changesOverrideOld(oldFilterWidgets, newFilterWidgets);
        changes.setOrders(newCanvas.widgets().stream().map(Widget::getName).collect(Collectors.toList()));
        changes.setOldWidgets(oldCanvas.widgets());
        this.addDefaultSort(newCanvas, viewSchema);
        this.updateBaseInfo(newCanvas, viewSchema);
        return this.viewSchemaService.saveOrUpdate(viewSchema);
    }

    private void updateBaseInfo(FormCanvasSchema newCanvas, FormViewSchema viewSchema) {
        viewSchema.setPrimaryKey(newCanvas.getPrimaryKey());
    }

    private FormDesignResponse<Boolean> updateFieldControl(FormCanvasSchema canvas) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class);
        FormDesignResponse fieldControlResponse = settingSchemaService.get(canvas.getId());
        FieldControlSchema fieldControlSchema = (FieldControlSchema)fieldControlResponse.getData();
        return this.updateFieldControl(canvas, fieldControlSchema);
    }

    private FormDesignResponse<Boolean> updateFieldControl(FormCanvasSchema canvas, FieldControlSchema oldFieldControlSchema) throws Exception {
        List<Widget> widgets = canvas.widgets();
        widgets.addAll(canvas.childTables());
        FieldControlSchema fieldControlSchema = HussarUtils.isEmpty((Object)oldFieldControlSchema) ? new FieldControlSchema() : (FieldControlSchema)HussarUtils.copyProperties((Object)oldFieldControlSchema, FieldControlSchema.class);
        ArrayList<FieldControl> add = HussarUtils.isEmpty((Object)fieldControlSchema.getAdd()) ? new ArrayList() : fieldControlSchema.getAdd();
        ArrayList<FieldControl> edit = HussarUtils.isEmpty((Object)fieldControlSchema.getEdit()) ? new ArrayList() : fieldControlSchema.getEdit();
        ArrayList<FieldControl> detail = HussarUtils.isEmpty((Object)fieldControlSchema.getDetail()) ? new ArrayList() : fieldControlSchema.getDetail();
        FormCanvasUtil.getFieldControl(widgets, add);
        FormCanvasUtil.getFieldControl(widgets, edit);
        FormCanvasUtil.getFieldControl(widgets, detail);
        List<String> orders = canvas.widgetsWithChildren().stream().map(Widget::getName).collect(Collectors.toList());
        FormCanvasUtil.sortFieldControl(add, orders);
        FormCanvasUtil.sortFieldControl(edit, orders);
        FormCanvasUtil.sortFieldControl(detail, orders);
        fieldControlSchema.setAdd(add);
        fieldControlSchema.setEdit(edit);
        fieldControlSchema.setDetail(detail);
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class);
        return settingSchemaService.saveOrUpdate(fieldControlSchema, canvas.getId());
    }

    private void sortFieldControl(List<FieldControl> fieldControls, List<String> orders) {
        fieldControls.sort((o1, o2) -> {
            int io1 = orders.indexOf(o1.getField());
            int io2 = orders.indexOf(o2.getField());
            if (io1 == -1 && io2 == -1) {
                return 0;
            }
            if (io1 == -1 || io2 == -1) {
                return io1 == -1 ? 1 : -1;
            }
            return Integer.compare(io1, io2);
        });
    }

    private FormDesignResponse<Boolean> updateDataSummary(FormCanvasSchema canvas) throws Exception {
        List<Widget> newWidgets = canvas.widgetsWithSys();
        newWidgets.removeIf(widget -> WidgetTool.anyMatch(widget.getName(), WidgetTool.excludeFields()));
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.summary", SettingSchemaService.class);
        SummarySchema summarySchema = (SummarySchema)((Object)settingSchemaService.get(canvas.getId()).getData());
        summarySchema = HussarUtils.isEmpty((Object)((Object)summarySchema)) ? new SummarySchema() : summarySchema;
        List<String> dataSummary = summarySchema.getDataSummary();
        this.getDataSummary(newWidgets, dataSummary);
        return settingSchemaService.saveOrUpdate(summarySchema, canvas.getId());
    }

    private Changes changesOverrideOld(List<Widget> old, List<Widget> news) {
        ArrayList<Widget> newWidgets = new ArrayList<Widget>();
        ArrayList<Widget> delWidgets = new ArrayList<Widget>();
        ArrayList<String> sameWidgets = new ArrayList<String>();
        CollectionUtils.addAll(delWidgets, (Object[])new Object[old.size()]);
        Collections.copy(delWidgets, old);
        news.forEach(widget -> {
            boolean noRepeat = true;
            for (Widget column : old) {
                if (!column.getName().equals(widget.getName())) continue;
                noRepeat = false;
                sameWidgets.add(widget.getName());
                delWidgets.remove(column);
                break;
            }
            if (noRepeat) {
                newWidgets.add((Widget)widget);
            }
        });
        old.replaceAll(column -> news.stream().filter(override -> override.getName().equals(column.getName())).findFirst().orElse((Widget)column));
        return new Changes(newWidgets, delWidgets, sameWidgets);
    }

    private Changes changesNoOverride(List<Widget> old, List<Widget> news) {
        ArrayList<Widget> newWidgets = new ArrayList<Widget>();
        ArrayList<Widget> delWidgets = new ArrayList<Widget>();
        ArrayList<String> sameWidgets = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(old)) {
            CollectionUtils.addAll(delWidgets, (Object[])new Object[old.size()]);
            Collections.copy(delWidgets, old);
        }
        news.forEach(widget -> {
            boolean noRepeat = true;
            if (ToolUtil.isNotEmpty((Object)old)) {
                for (Widget column : old) {
                    if (!column.getName().equals(widget.getName())) continue;
                    noRepeat = false;
                    sameWidgets.add(widget.getName());
                    delWidgets.remove(column);
                    break;
                }
            }
            if (noRepeat) {
                newWidgets.add((Widget)widget);
            }
        });
        return new Changes(newWidgets, delWidgets, sameWidgets);
    }

    private void updateShowFields(List<DataView> views, Changes changes, String formType) {
        List<Widget> delWidgets = changes.getDelWidgets();
        List<Widget> newWidgets = changes.getNewWidgets();
        if (HussarUtils.isNotEmpty(newWidgets)) {
            List<ShowField> showFields = CanvasServiceImpl.showFields(newWidgets, widgetName -> newWidgets.stream().map(Widget::getName).anyMatch(newName -> newName.equals(widgetName)));
            views.forEach(dataView -> {
                if ("1".equals(formType)) {
                    if (dataView.getTabType().equals("0")) {
                        dataView.getShowFields().addAll(changes.getOldWidgets().size() + 3, showFields);
                    }
                    if (dataView.getTabType().equals("2")) {
                        dataView.getShowFields().addAll(changes.getOldWidgets().size() + 4, showFields);
                    }
                    if (dataView.getTabType().equals("1")) {
                        dataView.getShowFields().addAll(changes.getOldWidgets().size() + 6, showFields);
                    }
                    if (dataView.getTabType().equals("3")) {
                        dataView.getShowFields().addAll(changes.getOldWidgets().size() + 1, showFields);
                    }
                } else if ("0".equals(formType)) {
                    dataView.getShowFields().addAll(changes.getOldWidgets().size() + 1, showFields);
                }
            });
        }
        if (HussarUtils.isNotEmpty(delWidgets)) {
            for (DataView view : views) {
                for (Widget delWidget : delWidgets) {
                    view.getShowFields().removeIf(showField -> delWidget.getName().equals(showField.getName()));
                }
            }
        }
        this.showFieldDeduplicate(views);
        this.sortViews(views, changes.getOrders());
    }

    private void showFieldDeduplicate(List<DataView> views) {
        for (DataView view : views) {
            ArrayList<ShowField> newShowFields = new ArrayList<ShowField>();
            for (ShowField outterShowField : view.getShowFields()) {
                boolean repeat = false;
                for (ShowField innerShowField : newShowFields) {
                    if (!innerShowField.getName().equals(outterShowField.getName())) continue;
                    repeat = true;
                    break;
                }
                if (repeat) continue;
                newShowFields.add(outterShowField);
            }
            view.setShowFields(newShowFields);
        }
    }

    private void sortViews(List<DataView> views, List<String> orders) {
        for (DataView view : views) {
            view.getShowFields().sort((o1, o2) -> {
                int io1 = orders.indexOf(o1.getName());
                int io2 = orders.indexOf(o2.getName());
                return io1 == -1 || io2 == -1 ? 0 : io1 - io2;
            });
        }
    }

    private static List<ShowField> showFields(List<Widget> widgets, Predicate<String> predicate) {
        ArrayList<ShowField> newShowFields = new ArrayList<ShowField>();
        for (Widget widget : widgets) {
            ShowField showField = new ShowField();
            showField.setChecked(predicate.test(widget.getName()));
            showField.setName(widget.getName());
            showField.setAlign("center");
            showField.setWidth(68 + widget.getTitle().length() * 14);
            showField.setIsMinWidth(true);
            showField.setI18nKeys(widget.getI18nKeys());
            showField.setAlias(widget.getAlias());
            newShowFields.add(showField);
        }
        return newShowFields;
    }

    private void getDataSummary(List<Widget> newWidgets, List<String> dataSummary) {
        if (HussarUtils.isEmpty(dataSummary)) {
            return;
        }
        ArrayList delSummary = new ArrayList();
        CollectionUtils.addAll(delSummary, (Object[])new Object[dataSummary.size()]);
        Collections.copy(delSummary, dataSummary);
        block0: for (Widget newWidget : newWidgets) {
            for (String summary : dataSummary) {
                if (!summary.equals(newWidget.getName())) continue;
                delSummary.remove(summary);
                continue block0;
            }
        }
        if (HussarUtils.isNotEmpty(delSummary)) {
            dataSummary.removeAll(delSummary);
        }
    }

    private void getFieldControl(List<Widget> widgets, List<FieldControl> addOrEdit) {
        ArrayList delControls = new ArrayList();
        CollectionUtils.addAll(delControls, (Object[])new Object[addOrEdit.size()]);
        Collections.copy(delControls, addOrEdit);
        for (Widget widget : widgets) {
            boolean isRepeat = false;
            for (FieldControl control : addOrEdit) {
                if (!control.getField().equals(widget.getName())) continue;
                control.setTitle(widget.getTitle());
                isRepeat = true;
                delControls.remove(control);
                if (!WidgetTool.isChildrenTable(widget)) break;
                if (HussarUtils.isEmpty((Object)control.getChildren())) {
                    control.setChildren(new ArrayList());
                }
                this.getFieldControl(widget.getChildren(), control.getChildren());
                break;
            }
            if (isRepeat) continue;
            FieldControl control = new FieldControl();
            control.setField(widget.getName());
            control.setType(widget.getType());
            control.setTitle(widget.getTitle());
            control.setReadOnly(widget.isReadOnly());
            control.setVisible(true);
            control.setWitable(true);
            control.setRequired(false);
            if (WidgetTool.isChildrenTable(widget)) {
                control.setChildren(new ArrayList());
                this.getFieldControl(widget.getChildren(), control.getChildren());
            }
            addOrEdit.add(control);
        }
        if (HussarUtils.isNotEmpty(delControls)) {
            addOrEdit.removeAll(delControls);
        }
    }

    private void deleteFieldCallback(FormCanvasSchema newCanvas, FormCanvasSchema oldCanvas) {
        List<Widget> newWidgets = WidgetTool.settingWidgets(newCanvas.widgetsWithSys(), widget -> WidgetTool.anyMatch(widget.getType(), WidgetType.JXDNRichText.getType()) || WidgetTool.anyMatch(widget.getName(), WidgetTool.showFieldsExcludeFields()));
        List<Widget> oldWidgets = WidgetTool.settingWidgets(oldCanvas.widgetsWithSys(), widget -> WidgetTool.anyMatch(widget.getType(), WidgetType.JXDNRichText.getType()) || WidgetTool.anyMatch(widget.getName(), WidgetTool.showFieldsExcludeFields()));
        Changes changes = this.changesOverrideOld(oldWidgets, newWidgets);
        List widgetNames = changes.getDelWidgets().stream().map(Widget::getName).collect(Collectors.toList());
        if (HussarUtils.isEmpty(widgetNames)) {
            return;
        }
        this.appExternalService.deleteLogicFilterByIds(widgetNames, newCanvas.getId());
    }

    private void saveNewestScope(String formId, List<Widget> widgets) throws JsonProcessingException {
        for (Widget widget : widgets) {
            if (!WidgetTool.anyMatch(widget.getType(), WidgetType.JXDNUser.getType(), WidgetType.JXDNUserMulti.getType(), WidgetType.JXDNOrg.getType(), WidgetType.JXDNOrgMulti.getType())) continue;
            JSONObject props = widget.getProps();
            Optional<String> value = JsonParser.value(props, "$.rangeId", String.class);
            FormDesignResponse<StaffScopeHistory> response = new FormDesignResponse<StaffScopeHistory>();
            if (!value.isPresent() || !HussarUtils.isNotEmpty((Object)(response = this.staffScopeScemaService.getHistoryByName(formId, widget.getName(), value.get())).getData())) continue;
            this.staffScopeScemaService.saveOrUpdate(((StaffScopeHistory)response.getData()).getContent());
        }
    }

    @Override
    public void saveReference(FormCanvasSchema newCanvas, FormCanvasSchema oldCanvas) throws JsonProcessingException {
        List<Widget> newWidgets = newCanvas.widgets();
        ArrayList<Widget> newChildren = new ArrayList<Widget>();
        for (Widget widget2 : newCanvas.childTables()) {
            newChildren.addAll(widget2.getChildren());
        }
        newWidgets.addAll(newChildren);
        List<Widget> oldWidgets = null;
        if (ToolUtil.isNotEmpty((Object)((Object)oldCanvas))) {
            oldWidgets = oldCanvas.widgets();
            ArrayList<Widget> oldChildren = new ArrayList<Widget>();
            for (Widget widget3 : oldCanvas.childTables()) {
                oldChildren.addAll(widget3.getChildren());
            }
            oldWidgets.addAll(oldChildren);
        }
        Changes changesAllWidgets = this.changesNoOverride(oldWidgets, newWidgets);
        this.updateWidgetsReference(changesAllWidgets.getDelWidgets(), newWidgets, newCanvas);
        List<Widget> linkFormWidgets = newWidgets.stream().filter(widget -> WidgetType.JXDNLinkForm.getType().equals(widget.getType()) || WidgetType.JXDN_CASCADER.getType().equals(widget.getType()) || WidgetType.JXDN_CASCADER_MULTI.getType().equals(widget.getType()) || WidgetType.JXDN_DATA_QUERY.getType().equals(widget.getType())).collect(Collectors.toList());
        List oldLinkFormWidgets = null;
        if (ToolUtil.isNotEmpty(oldWidgets)) {
            oldLinkFormWidgets = oldWidgets.stream().filter(widget -> WidgetType.JXDNLinkForm.getType().equals(widget.getType()) || WidgetType.JXDN_CASCADER.getType().equals(widget.getType()) || WidgetType.JXDN_CASCADER_MULTI.getType().equals(widget.getType()) || WidgetType.JXDN_DATA_QUERY.getType().equals(widget.getType())).collect(Collectors.toList());
        }
        Changes changes = this.changesNoOverride(oldLinkFormWidgets, linkFormWidgets);
        FormDesignResponse<List<ResourceReference>> listFormDesignResponse = this.referenceService.get();
        ArrayList<ResourceReference> references = (ArrayList<ResourceReference>)listFormDesignResponse.getData();
        if (HussarUtils.isEmpty((Object)references)) {
            references = new ArrayList<ResourceReference>();
        }
        List<Widget> delRefWidgets = changes.getDelWidgets();
        List<Widget> newRefWidgets = changes.getNewWidgets();
        List<String> widgetNames = changes.getSameWidgets();
        if (ToolUtil.isNotEmpty(widgetNames)) {
            for (String widgetName : widgetNames) {
                Optional<Widget> newWidget = linkFormWidgets.stream().filter(w -> HussarUtils.equals((Object)w.getName(), (Object)widgetName)).findFirst();
                Object oldWidget = null;
                if (ToolUtil.isNotEmpty(oldLinkFormWidgets)) {
                    oldWidget = oldLinkFormWidgets.stream().filter(w -> HussarUtils.equals((Object)w.getName(), (Object)widgetName)).findFirst();
                }
                if (!this.isUpdate(newWidget, (Optional<Widget>)oldWidget) || !newWidget.isPresent()) continue;
                delRefWidgets.add(newWidget.get());
                newRefWidgets.add(newWidget.get());
            }
        }
        ArrayList<ResourceReference> delRes = new ArrayList<ResourceReference>();
        for (Widget widget4 : delRefWidgets) {
            for (ResourceReference reference : references) {
                if (!HussarUtils.equals(reference.getSourceKey(), Arrays.asList(AppContextUtil.getAppId(), newCanvas.getId(), widget4.getName()))) continue;
                delRes.add(reference);
            }
        }
        references.removeAll(delRes);
        for (Widget widget4 : newRefWidgets) {
            ResourceReference reference = new ResourceReference();
            reference.setReferType("form");
            reference.setSourceKey(Arrays.asList(AppContextUtil.getAppId(), newCanvas.getId(), widget4.getName()));
            reference.setReferKey(this.linkKeys(widget4));
            if (this.exist(references, reference)) continue;
            references.add(reference);
        }
        this.referenceService.write(references);
    }

    private void updateWidgetsReference(List<Widget> delWidgets, List<Widget> newWidgets, FormCanvasSchema newCanvas) {
        BriefReference briefReference;
        String sourceFormId;
        String sourceAppId;
        List delNames = newWidgets.stream().map(Widget::getName).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(delWidgets)) {
            delNames.addAll(delWidgets.stream().map(Widget::getName).collect(Collectors.toList()));
        }
        this.formReferenceService.delReferenceByReferId(delNames);
        List widgetsRefer = newWidgets.stream().filter(widget -> HussarUtils.isNotEmpty((Object)widget.getProps().getJSONObject("dataLinkage"))).collect(Collectors.toList());
        List linkForms = newWidgets.stream().filter(widget -> WidgetTool.anyMatch(widget.getType(), WidgetType.JXDNLinkForm.getType(), WidgetType.JXDN_CASCADER.getType(), WidgetType.JXDN_CASCADER_MULTI.getType(), WidgetType.JXDN_DATA_QUERY.getType())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(widgetsRefer)) {
            for (Widget widgetRefer : widgetsRefer) {
                sourceAppId = widgetRefer.getProps().getJSONObject("dataLinkage").getJSONObject("data").getString("appId");
                sourceFormId = widgetRefer.getProps().getJSONObject("dataLinkage").getJSONObject("data").getString("formId");
                if (newCanvas.getId().equals(sourceFormId)) continue;
                briefReference = new BriefReference();
                briefReference.setReferAppId(Long.valueOf(Long.parseLong(AppContextUtil.getAppId())));
                briefReference.setReferFormId(Long.valueOf(Long.parseLong(newCanvas.getId())));
                briefReference.setSourceAppId(Long.valueOf(Long.parseLong(sourceAppId)));
                briefReference.setSourceFormId(Long.valueOf(Long.parseLong(sourceFormId)));
                briefReference.setReferId(widgetRefer.getName());
                briefReference.setType("widget");
                this.formReferenceService.saveBriefReference(briefReference);
            }
        }
        if (HussarUtils.isNotEmpty(linkForms)) {
            for (Widget linkForm : linkForms) {
                sourceAppId = linkForm.getProps().getJSONObject("linkTableInfo").getString("appId");
                sourceFormId = linkForm.getProps().getJSONObject("linkTableInfo").getString("formId");
                if (newCanvas.getId().equals(sourceFormId)) continue;
                briefReference = new BriefReference();
                briefReference.setReferAppId(Long.valueOf(Long.parseLong(AppContextUtil.getAppId())));
                briefReference.setReferFormId(Long.valueOf(Long.parseLong(newCanvas.getId())));
                briefReference.setSourceAppId(Long.valueOf(Long.parseLong(sourceAppId)));
                briefReference.setSourceFormId(Long.valueOf(Long.parseLong(sourceFormId)));
                briefReference.setReferId(linkForm.getName());
                briefReference.setType("widget");
                this.formReferenceService.saveBriefReference(briefReference);
            }
        }
    }

    private boolean exist(List<ResourceReference> references, ResourceReference reference) {
        for (ResourceReference r : references) {
            if (!HussarUtils.equals((Object)reference.getReferType(), (Object)r.getReferType()) || !HussarUtils.equals(reference.getSourceKey(), r.getSourceKey()) || !HussarUtils.equals(reference.getReferKey(), r.getReferKey())) continue;
            return true;
        }
        return false;
    }

    private boolean isUpdate(Optional<Widget> newWidget, Optional<Widget> oldWidget) {
        if (oldWidget.isPresent() && newWidget.isPresent()) {
            return !HussarUtils.equals(this.linkKeys(newWidget.get()), this.linkKeys(oldWidget.get()));
        }
        return false;
    }

    private List<String> linkKeys(Widget widget) {
        String app = JsonParser.value(widget, "$.props.linkTableInfo.appId", String.class, "");
        String form = JsonParser.value(widget, "$.props.linkTableInfo.formId", String.class, "");
        String name = JsonParser.value(widget, "$.props.linkTableInfo.linkFieldInfo.name", String.class, "");
        return Arrays.asList(app, form, name);
    }

    private void saveCodeRule(FormCanvasSchema newCanvas) throws JsonProcessingException {
        String formId = newCanvas.getId();
        List<Widget> widgets = newCanvas.widgets();
        FormSchema formSchema = (FormSchema)this.formOperateService.get(formId).getData();
        formSchema.setFormCanvas(newCanvas);
        for (Widget widget : widgets) {
            if (!HussarUtils.equals((Object)widget.getType(), (Object)WidgetType.JXDNSerialNumber.getType())) continue;
            JXDNSerialNumber serialNumber = (JXDNSerialNumber)SpringContextUtil.getBean((String)WidgetType.JXDNSerialNumber.getType());
            serialNumber.init(widget, formSchema);
            if (!HussarUtils.isNotEmpty((Object)widget.getProps()) || HussarUtils.equals((Object)"existing", (Object)widget.getProps().getString("defaultRule"))) continue;
            serialNumber.saveCodeRule();
        }
    }

    @Override
    public void saveCanvasForCopy(FormCanvasSchema newCanvas) throws Exception {
        AppContextUtil.setAppId((String)String.valueOf(newCanvas.getAppId()));
        String formId = newCanvas.getId();
        List<Widget> widgets = newCanvas.widgets();
        FormSchema formSchema = (FormSchema)this.formOperateService.get(formId).getData();
        formSchema.setFormCanvas(newCanvas);
        for (Widget widget : widgets) {
            if (!HussarUtils.equals((Object)widget.getType(), (Object)WidgetType.JXDNSerialNumber.getType())) continue;
            JXDNSerialNumber serialNumber = (JXDNSerialNumber)SpringContextUtil.getBean((String)WidgetType.JXDNSerialNumber.getType());
            serialNumber.init(widget, formSchema);
            serialNumber.saveCodeRule();
            if (!HussarUtils.isNotEmpty((Object)widget.getProps()) || !HussarUtils.equals((Object)"existing", (Object)widget.getProps().getString("defaultRule"))) continue;
            JSONObject props = widget.getProps();
            props.put("defaultRule", (Object)"custom");
            props.put("defaultRuleExisting", null);
        }
        this.canvasSchemaService.saveOrUpdate(newCanvas);
    }

    private void compatibleOldShowFields(List<DataView> views, List<Widget> widgets, int index, String formType) {
        List<ShowField> oldShowFields = CanvasServiceImpl.showFields(widgets, widgetName -> widgets.stream().map(Widget::getName).anyMatch(newName -> newName.equals(widgetName)));
        List fieldList = views.get(0).getShowFields();
        List fieldNames = fieldList.stream().map(ShowField::getName).collect(Collectors.toList());
        ArrayList<ShowField> showFields = new ArrayList<ShowField>();
        for (ShowField oldShowField : oldShowFields) {
            if (fieldNames.contains(oldShowField.getName())) continue;
            showFields.add(oldShowField);
        }
        views.forEach(dataView -> {
            if ("1".equals(formType)) {
                if (dataView.getTabType().equals("0")) {
                    dataView.getShowFields().addAll(index + 3, showFields);
                }
                if (dataView.getTabType().equals("2")) {
                    dataView.getShowFields().addAll(index + 4, showFields);
                }
                if (dataView.getTabType().equals("1")) {
                    dataView.getShowFields().addAll(index + 6, showFields);
                }
                if (dataView.getTabType().equals("3")) {
                    dataView.getShowFields().addAll(index, showFields);
                }
            } else if ("0".equals(formType)) {
                dataView.getShowFields().addAll(index + 1, showFields);
            }
        });
    }

    private void saveFormCheckConfig(FormCanvasSchema newCanvas) {
        Object sysFormCheckConfig = newCanvas.getProps().get("sysFormCheckConfig");
        if (HussarUtils.isEmpty((Object)sysFormCheckConfig)) {
            return;
        }
        SysFormCheckConfigDto sysFormCheckConfigDto = (SysFormCheckConfigDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sysFormCheckConfig), SysFormCheckConfigDto.class);
        if (HussarUtils.isEmpty((Object)sysFormCheckConfigDto.getFormId())) {
            sysFormCheckConfigDto.setFormId(Long.valueOf(newCanvas.getId()));
        }
        this.sysFormCheckConfigService.saveFormCheckConfig(sysFormCheckConfigDto);
        newCanvas.getProps().remove("sysFormCheckConfig");
    }

    private FormCanvasSchema afterSaveCanvas(FormCanvasSchema newCanvas) {
        ToolUtil.getLogger(CanvasServiceImpl.class).info("\u4fdd\u5b58\u753b\u5e03\u540e\u8c03\u7528\u7b2c\u4e09\u65b9\u5b9e\u73b0\u5904\u7406\u753b\u5e03\u4fe1\u606f");
        FormCanvasSchemaDto formCanvasSchemaDto = (FormCanvasSchemaDto)HussarUtils.copyProperties((Object)((Object)newCanvas), FormCanvasSchemaDto.class);
        if (this.iCanvasHookService != null) {
            this.iCanvasHookService.afterSaveCanvas(formCanvasSchemaDto);
        }
        this.hookUtil.afterSaveCanvas(formCanvasSchemaDto);
        newCanvas = (FormCanvasSchema)((Object)HussarUtils.copyProperties((Object)formCanvasSchemaDto, FormCanvasSchema.class));
        return newCanvas;
    }

    private FormCanvasSchema beforeSaveCanvas(FormCanvasSchema newCanvas) {
        ToolUtil.getLogger(CanvasServiceImpl.class).info("\u4fdd\u5b58\u753b\u5e03\u524d\u8c03\u7528\u7b2c\u4e09\u65b9\u5b9e\u73b0\u5904\u7406\u753b\u5e03\u4fe1\u606f");
        FormCanvasSchemaDto formCanvasSchemaDto = (FormCanvasSchemaDto)HussarUtils.copyProperties((Object)((Object)newCanvas), FormCanvasSchemaDto.class);
        if (this.iCanvasHookService != null) {
            this.iCanvasHookService.beforeSaveCanvas(formCanvasSchemaDto);
        }
        this.hookUtil.beforeSaveCanvas(formCanvasSchemaDto);
        newCanvas = (FormCanvasSchema)((Object)HussarUtils.copyProperties((Object)formCanvasSchemaDto, FormCanvasSchema.class));
        return newCanvas;
    }

    private void checkSecrecySetOutLink(FormCanvasSchema newCanvas) {
        JSONObject secrecyRule;
        Boolean isOpen;
        Object secrecyRuleObject = newCanvas.getProps().get("secrecyRule");
        if (HussarUtils.isNotEmpty((Object)secrecyRuleObject) && (isOpen = (Boolean)JSON.parseObject((String)JSONObject.toJSONString((Object)(secrecyRule = (JSONObject)JSON.parseObject((String)JSONObject.toJSONString((Object)secrecyRuleObject), JSONObject.class)).get((Object)"isOpen")), Boolean.class)).booleanValue()) {
            LambdaQueryWrapper queryWrapper2;
            SysFormLinkOpen sysFormLinkOpen;
            LambdaQueryWrapper queryWrapper1;
            SysFormLinkSingleStatus sysFormLinkSingleStatus;
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFormLink::getFormId, (Object)newCanvas.getId());
            SysFormLink sysFormLink = (SysFormLink)this.sysFormLinkService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysFormLink)) {
                sysFormLink.setLinkStatus(Integer.valueOf(0));
                this.sysFormLinkService.updateById((Object)sysFormLink);
            }
            if (HussarUtils.isNotEmpty((Object)(sysFormLinkSingleStatus = (SysFormLinkSingleStatus)this.sysFormLinkSingleStatusService.getOne((Wrapper)(queryWrapper1 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFormLinkSingleStatus::getFormId, (Object)newCanvas.getId())))))) {
                sysFormLinkSingleStatus.setSingleStatus(Integer.valueOf(0));
                this.sysFormLinkSingleStatusService.updateById((Object)sysFormLinkSingleStatus);
            }
            if (HussarUtils.isNotEmpty((Object)(sysFormLinkOpen = (SysFormLinkOpen)this.sysFormLinkOpenService.getOne((Wrapper)(queryWrapper2 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFormLinkOpen::getFormId, (Object)newCanvas.getId())))))) {
                sysFormLinkOpen.setLinkStatus(Integer.valueOf(0));
                this.sysFormLinkOpenService.updateById((Object)sysFormLinkOpen);
            }
        }
    }

    public static class Changes {
        List<Widget> newWidgets;
        List<Widget> oldWidgets;
        List<Widget> delWidgets;
        List<String> sameWidgets;
        List<String> orders;

        public Changes(List<Widget> newWidgets, List<Widget> delWidgets, List<String> sameWidgets) {
            this.newWidgets = newWidgets;
            this.delWidgets = delWidgets;
            this.sameWidgets = sameWidgets;
        }

        public List<Widget> getOldWidgets() {
            return this.oldWidgets;
        }

        public void setOldWidgets(List<Widget> oldWidgets) {
            this.oldWidgets = oldWidgets;
        }

        public List<Widget> getNewWidgets() {
            return this.newWidgets;
        }

        public List<Widget> getDelWidgets() {
            return this.delWidgets;
        }

        public List<String> getSameWidgets() {
            return this.sameWidgets;
        }

        public List<String> getOrders() {
            return this.orders;
        }

        public void setOrders(List<String> orders) {
            this.orders = orders;
        }
    }
}

