/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSONPath;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleConfigDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeSaveDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeUpdateDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.Path;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNSerialNumber")
public class JXDNSerialNumber
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    @Resource
    private ISysCodeRuleService iSysCodeRuleService;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleType.CLOB.name());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        widget.setUsage("serialNumber");
        return fields;
    }

    @Override
    public List<ModelFieldDto> withEngineField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<ModelFieldDto> fields = new ArrayList<ModelFieldDto>();
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(name);
        fieldDto.setFieldComment(title);
        fieldDto.setDefaultValue(null);
        fieldDto.setDataType(this.fieldDbType.get(dbType));
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.STRING.getValue());
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDto.setNeedChangeIsRequired(false);
        fieldDto.setPurpose("serialNumber");
        fieldDto.setRequired("0");
        fields.add(fieldDto);
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType, Widget widget) {
        return this.withField(dbType, widget).get(0);
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("inputMode", JsonParser.value(this.widget, Path.Widgets.INPUT_MODE.getPath(), String.class).orElse("text"));
    }

    public void saveCodeRule() {
        String ruleCode = this.form.getFormCanvas().getName();
        String title = this.form.getFormCanvas().getTitle();
        ApiResponse sysCodeRuleVoApiResponse = this.iSysCodeRuleService.getCodeRuleByCode(ruleCode);
        SysCodeRuleVo record = null;
        if (HussarUtils.isNotEmpty((Object)sysCodeRuleVoApiResponse) && HussarUtils.isNotEmpty((Object)sysCodeRuleVoApiResponse.getData()) && HussarUtils.isNotEmpty((Object)((SysCodeRuleVo)sysCodeRuleVoApiResponse.getData()).getCodeRuleCode())) {
            record = (SysCodeRuleVo)sysCodeRuleVoApiResponse.getData();
        }
        Optional<List<SerialNumRuleDTO>> codeRulesOpt = JsonParser.array(this.widget, "$.props.rules", SerialNumRuleDTO.class);
        ArrayList<SysCodeRuleConfigDto> sysCodeSaveDTOs = new ArrayList<SysCodeRuleConfigDto>();
        if (!codeRulesOpt.isPresent()) {
            return;
        }
        List<SerialNumRuleDTO> serialNumRuleDTOS = codeRulesOpt.get();
        for (SerialNumRuleDTO codeRule : serialNumRuleDTOS) {
            SysCodeRuleConfigDto sysCodeRuleInfo = new SysCodeRuleConfigDto();
            String type = codeRule.getType();
            sysCodeRuleInfo.setElementType(type);
            Long id = codeRule.getConfig().getId();
            if (HussarUtils.isEmpty((Object)id)) {
                id = IdWorker.getId((Object)sysCodeRuleInfo);
                codeRule.getConfig().setId(id);
            }
            sysCodeRuleInfo.setCodeRuleInfoId(id);
            if (HussarUtils.equals((Object)type, (Object)"serialNumber")) {
                sysCodeRuleInfo.setElementPattern("1");
                sysCodeRuleInfo.setSerialNumberLength(codeRule.getConfig().getCountLength());
                sysCodeRuleInfo.setSerialNumberStart(codeRule.getConfig().getInitialVal());
                sysCodeRuleInfo.setResetPeriod(codeRule.getConfig().getResetType());
            }
            if (HussarUtils.equals((Object)type, (Object)"constant") || HussarUtils.equals((Object)type, (Object)"codeDateTime")) {
                sysCodeRuleInfo.setElementPattern(codeRule.getConfig().getValue());
            }
            if (HussarUtils.equals((Object)type, (Object)"field")) {
                sysCodeRuleInfo.setElementType("variable");
                sysCodeRuleInfo.setElementPattern(codeRule.getName());
            }
            if (HussarUtils.equals((Object)type, (Object)"randomNumber") || HussarUtils.equals((Object)type, (Object)"randomCode") || HussarUtils.equals((Object)type, (Object)"timeStamp")) {
                sysCodeRuleInfo.setElementPattern(String.valueOf(codeRule.getConfig().getCountLength()));
            }
            sysCodeSaveDTOs.add(sysCodeRuleInfo);
        }
        JSONPath.set((Object)this.widget, (String)"$.props.rules", serialNumRuleDTOS);
        if (HussarUtils.isNotEmpty((Object)record)) {
            SysCodeUpdateDto sysCodeUpdateDto = new SysCodeUpdateDto();
            Long codeRuleId = record.getCodeRuleId();
            sysCodeUpdateDto.setCodeRuleId(codeRuleId);
            sysCodeUpdateDto.setCodeRuleCode(ruleCode);
            sysCodeUpdateDto.setCodeRuleName(title);
            sysCodeUpdateDto.setCodeRuleDesc(title);
            sysCodeUpdateDto.setSys("0");
            sysCodeUpdateDto.setLevel("0");
            sysCodeUpdateDto.setSysCodeRuleConfigList(sysCodeSaveDTOs);
            this.iSysCodeRuleService.updateCodeRule(sysCodeUpdateDto);
        } else {
            SysCodeSaveDto sysCodeSaveDto = new SysCodeSaveDto();
            sysCodeSaveDto.setCodeRuleName(title);
            sysCodeSaveDto.setCodeRuleCode(ruleCode);
            sysCodeSaveDto.setCodeRuleDesc(title);
            sysCodeSaveDto.setSys("0");
            sysCodeSaveDto.setLevel("0");
            sysCodeSaveDto.setSysCodeRuleConfigList(sysCodeSaveDTOs);
            this.iSysCodeRuleService.saveCodeRule(sysCodeSaveDto);
        }
    }
}

