/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.formdesign.application.util.ExcelCellTypeAnalysisUtil;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.Path;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNDate")
public class JXDNDate
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.DATETIME.name());
            this.put("ORACLE", OracleType.TIMESTAMP.name());
            this.put("DM", DMSqlTypeEnum.TIMESTAMP.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.TIMESTAMP.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TIMESTAMP.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.DATE.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(0).build());
        return fields;
    }

    @Override
    public List<ModelFieldDto> withEngineField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<ModelFieldDto> fields = new ArrayList<ModelFieldDto>();
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(name);
        fieldDto.setFieldComment(title);
        fieldDto.setDataLength(Long.valueOf(0L));
        fieldDto.setDataType(this.fieldDbType.get(dbType));
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.DATE.getValue());
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDto.setNeedChangeIsRequired(false);
        fieldDto.setPurpose(widget.getUsage());
        fieldDto.setRequired("0");
        fields.add(fieldDto);
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType, Widget widget) {
        return this.withField(dbType, widget).get(0);
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("format", JsonParser.value(this.widget, Path.Widgets.FORMAT.getPath(), String.class).orElse("yyyy-MM-dd"));
    }

    @Override
    public Object getModelByWidgetType(String name, Map<String, SysUsers> mapUserNameSysUsers, Map<String, OrganizationBo> mapOrganNameSysOrgans, Map<Long, List<RegionVo>> parentIdRegionVoMap, Integer addressLevel) {
        String model = HussarUtils.isEmpty((Object)name) ? "" : (ExcelCellTypeAnalysisUtil.analysisDate((String)name) || ExcelCellTypeAnalysisUtil.analysisDateTime((String)name) || ExcelCellTypeAnalysisUtil.analysisDateYear((String)name) || ExcelCellTypeAnalysisUtil.analysisYearMonth((String)name) || ExcelCellTypeAnalysisUtil.analysisYearMonthTimeMiu((String)name) ? name : "");
        return model;
    }
}

