/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNCascader")
public class JXDNCascader
extends JXDNWidgetDefault {
    @Resource
    private FormOperateService formOperateService;
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleType.CLOB.name());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        fields.add(new DataModelFieldBase.Builder().withId(String.format("%s%s", name, "_label")).withName(String.format("%s%s", name, "_label")).withComment("\u8bb0\u5f55\u6240\u9009\u8282\u70b9\u7684\u5b8c\u6574\u8def\u5f84\u63cf\u8ff0").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        return fields;
    }

    @Override
    public List<ModelFieldDto> withEngineField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<ModelFieldDto> fields = new ArrayList<ModelFieldDto>();
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(name);
        fieldDto.setFieldComment(title);
        fieldDto.setDefaultValue(null);
        fieldDto.setDataType(this.fieldDbType.get(dbType));
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.STRING.getValue());
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDto.setNeedChangeIsRequired(false);
        fieldDto.setPurpose(widget.getUsage());
        fieldDto.setRequired("0");
        fields.add(fieldDto);
        ModelFieldDto fieldDtoRefChildId = new ModelFieldDto();
        fieldDtoRefChildId.setFieldName(String.format("%s%s", name, "_label"));
        fieldDtoRefChildId.setFieldComment("\u8bb0\u5f55\u6240\u9009\u8282\u70b9\u7684\u5b8c\u6574\u8def\u5f84\u63cf\u8ff0");
        fieldDtoRefChildId.setDefaultValue(null);
        fieldDtoRefChildId.setDataType(this.fieldDbType.get(dbType));
        fieldDtoRefChildId.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDtoRefChildId.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDtoRefChildId.setNeedChangeIsRequired(false);
        fieldDtoRefChildId.setPurpose(widget.getUsage());
        fieldDtoRefChildId.setRequired("0");
        fields.add(fieldDtoRefChildId);
        return fields;
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        Widget linkWidget;
        String type = JsonParser.value(this.widget, "$.props.linkTableInfo.asyncType", String.class, "");
        if (!HussarUtils.equals((Object)type, (Object)"dataSet") && !HussarUtils.equals((Object)type, (Object)"dataSet") && HussarUtils.isNotEmpty((Object)(linkWidget = this.getLinkWidget()))) {
            linkWidget.wrapTitle(title, currentParam);
            currentParam.setWidgetType(this.widget.getType());
            currentParam.putDetail("derived", String.format("%s%s", this.widget.getName(), "_label"));
            currentParam.putDetail("showAllLevels", this.widget.getProps().getBoolean("showAllLevels"));
        }
    }

    private Widget getLinkWidget() {
        FormSchema formSchema;
        String nowAppId = AppContextUtil.getAppId();
        String appId = JsonParser.value(this.widget, "$.props.linkTableInfo.appId", String.class, nowAppId);
        String formId = JsonParser.value(this.widget, "$.props.linkTableInfo.formId", String.class, "");
        String name = JsonParser.value(this.widget, "$.props.linkTableInfo.linkFieldInfo.name", String.class, "");
        if (HussarUtils.isEmpty((Object)appId) || HussarUtils.isEmpty((Object)formId) || HussarUtils.isEmpty((Object)name)) {
            throw new RuntimeException("\u5173\u8054\u8868\u5355\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        }
        AppContextUtil.setAppId((String)appId);
        try {
            formSchema = (FormSchema)this.formOperateService.get(formId).getData();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (HussarUtils.isEmpty((Object)formSchema) || HussarUtils.isEmpty((Object)((Object)formSchema.getFormCanvas()))) {
            throw new RuntimeException("\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        FormCanvasSchema linkForm = formSchema.getFormCanvas();
        AppContextUtil.setAppId((String)nowAppId);
        List<Widget> widgets = linkForm.widgetsWithSys();
        Optional<Widget> first = widgets.stream().filter(v -> v.getName().equals(name)).findFirst();
        if (!first.isPresent()) {
            return null;
        }
        Widget linkedWidget = first.get();
        linkedWidget.setTitle(this.widget.getTitle());
        Widget linkedWidgetIns = linkedWidget.newInstance(formSchema);
        return linkedWidgetIns;
    }
}

