/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.util;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.data.mongodb")
public class FileToMongoDB {
    protected static final Logger logger = LoggerFactory.getLogger(FileToMongoDB.class);
    @Resource
    private FormDesignProperties formDesignProperties;
    private String host;
    private int port;
    private String database;
    private String username;
    private String password;
    private String authenticationDatabase = "admin";

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getAuthenticationDatabase() {
        return this.authenticationDatabase;
    }

    public void setAuthenticationDatabase(String authenticationDatabase) {
        this.authenticationDatabase = authenticationDatabase;
    }

    public void syncFile2MongoDB() {
        String baseFolderPath = this.getBaseFolderPath();
        File baseFolder = new File(baseFolderPath);
        File[] appIds = baseFolder.listFiles(File::isDirectory);
        if (appIds != null) {
            for (File appId : appIds) {
                this.processAppId(appId, "reference".equals(appId.getName()));
            }
        }
    }

    private String getBaseFolderPath() {
        String backProjectPath = this.formDesignProperties.getBackProjectPath();
        String noCodeStore = ".noCode-store";
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), backProjectPath, noCodeStore});
    }

    private void processAppId(File file, boolean referenceFlag) {
        MongoClientSettings settings;
        String dbName = this.database;
        String appId = file.getName();
        MongoClientSettings.Builder baseBuilder = MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(Arrays.asList(new ServerAddress(this.host, this.port))));
        if (StringUtils.isNotEmpty((CharSequence)this.username) && StringUtils.isNotEmpty((CharSequence)this.password)) {
            MongoCredential credential = MongoCredential.createCredential((String)this.username, (String)this.authenticationDatabase, (char[])this.password.toCharArray());
            settings = baseBuilder.credential(credential).build();
        } else {
            settings = baseBuilder.build();
        }
        try (MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings);){
            MongoDatabase database = mongoClient.getDatabase(dbName);
            if (!referenceFlag) {
                File[] folders = file.listFiles(File::isDirectory);
                if (folders == null) {
                    return;
                }
                for (File folder : folders) {
                    File[] innerFolders = folder.listFiles(File::isDirectory);
                    if (innerFolders == null) continue;
                    for (File innerFolder : innerFolders) {
                        String collectionName = this.getCollectionName(innerFolder);
                        MongoCollection collection = database.getCollection(collectionName);
                        File[] jsonFiles = innerFolder.listFiles();
                        Document document = null;
                        switch (innerFolder.getName()) {
                            case "canvas": {
                                document = this.readFileAndSync2MongoDB(jsonFiles, ".fd", "id", appId);
                                break;
                            }
                            case "setting": {
                                document = this.readFileAndSync2MongoDB(jsonFiles, ".setting", "formId", appId);
                                break;
                            }
                            case "view": {
                                document = this.readFileAndSync2MongoDB(jsonFiles, ".vd", "formId", appId);
                                break;
                            }
                            case "staff": {
                                this.readStaffScopeAndSync2MongoDB(database, jsonFiles, appId);
                            }
                        }
                        if (document == null) continue;
                        collection.insertOne(document);
                    }
                }
            } else {
                MongoCollection collection = database.getCollection("resourceReference");
                File[] folders = file.listFiles(File::isDirectory);
                if (folders == null) {
                    return;
                }
                for (File folder : folders) {
                    File[] jsonFiles;
                    for (File jsonFile : jsonFiles = folder.listFiles()) {
                        if (!jsonFile.getName().endsWith(".ref")) continue;
                        String jsonContent = this.readJsonFile(jsonFile);
                        JSONArray resultArray = JSONArray.parseArray((String)jsonContent);
                        for (Object item : resultArray) {
                            Document result = Document.parse((String)item.toString());
                            collection.insertOne((Object)result);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8fde\u63a5mongodb\u5931\u8d25", (Throwable)e);
            throw new BaseException("\u8fde\u63a5mongodb\u5931\u8d25,\u8bf7\u68c0\u67e5\u540e\u53f0\u65e5\u5fd7");
        }
    }

    private void readStaffScopeAndSync2MongoDB(MongoDatabase database, File[] jsonFiles, String appId) {
        if (jsonFiles != null) {
            for (File file : jsonFiles) {
                if (!file.getName().endsWith(".stf")) continue;
                String collectionName = file.getName().endsWith("history.stf") ? "staffScopeHistory" : "staffScope";
                MongoCollection collection = database.getCollection(collectionName);
                String jsonFile = this.readJsonFile(file);
                JSONArray jsonArray = JSONArray.parseArray((String)jsonFile);
                for (Object item : jsonArray) {
                    Document result = Document.parse((String)item.toString());
                    if (file.getName().endsWith("history.stf")) {
                        Object value = result.get((Object)"stepKey");
                        result.remove((Object)"stepKey");
                        result.append("_id", value);
                    } else {
                        result.append("appId", (Object)appId);
                    }
                    collection.insertOne((Object)result);
                }
            }
        }
    }

    private Document readFileAndSync2MongoDB(File[] folder, String suffix, String key, String appId) {
        Document document = null;
        if (folder != null) {
            for (File jsonFile : folder) {
                if (!jsonFile.getName().endsWith(suffix)) continue;
                String jsonContent = this.readJsonFile(jsonFile);
                document = Document.parse((String)jsonContent);
                String formId = document.get((Object)key).toString();
                String mongoId = String.format("%s:%s", appId, formId);
                document.append("_id", (Object)mongoId);
                document.append("appId", (Object)appId);
                document.remove((Object)"mongoId");
            }
        }
        return document;
    }

    private String getCollectionName(File userFolder) {
        String canvasFolderName = userFolder.getName();
        String collectionName = "Form" + canvasFolderName.substring(0, 1).toUpperCase() + canvasFolderName.substring(1) + "Schema";
        return collectionName;
    }

    private String readJsonFile(File jsonFile) {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(jsonFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new BaseException("\u8bfb\u53d6\u6587\u4ef6\u53d1\u751f\u5f02\u5e38");
        }
        return content.toString();
    }
}

