/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.tool;

import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;

public class DataTypeConvert {
    public static String convertApiDataType(Integer typeNum) {
        String dataType = "";
        switch (typeNum) {
            case 0: {
                dataType = "boolean";
                break;
            }
            case 1: {
                dataType = "Integer";
                break;
            }
            case 2: {
                dataType = "long";
                break;
            }
            case 3: {
                dataType = "double";
                break;
            }
            case 4: {
                dataType = "string";
                break;
            }
            case 5: {
                dataType = "date";
                break;
            }
            default: {
                dataType = "string";
            }
        }
        return dataType;
    }

    public static String convertPacketDataType(String fieldType) {
        boolean isBooleanType;
        boolean isStringType;
        boolean isTimeType;
        boolean isLocalDateTimeType;
        boolean isDoubleType;
        boolean isIntegerType;
        boolean isLongType;
        boolean bl = isLongType = "BIGINT".equalsIgnoreCase(fieldType) || "NUMBER".equalsIgnoreCase(fieldType) || (fieldType.startsWith("numeric(") || fieldType.startsWith("NUMERIC(") || fieldType.startsWith("bigint(")) && fieldType.endsWith(")");
        if (isLongType) {
            return "string";
        }
        boolean bl2 = isIntegerType = "INT".equalsIgnoreCase(fieldType) || "MEDIUMINT".equalsIgnoreCase(fieldType) || "SMALLINT".equalsIgnoreCase(fieldType) || "TINYINT".equalsIgnoreCase(fieldType) || fieldType.startsWith("int(") && fieldType.endsWith(")");
        if (isIntegerType) {
            return "Integer";
        }
        boolean bl3 = isDoubleType = "DECIMAL".equalsIgnoreCase(fieldType) || "FLOAT".equalsIgnoreCase(fieldType) || "DOUBLE".equalsIgnoreCase(fieldType) || "double precision".equalsIgnoreCase(fieldType) || "real".equalsIgnoreCase(fieldType) || fieldType.startsWith("FLOAT");
        if (isDoubleType) {
            return "double";
        }
        boolean isDateType = "DATE".equalsIgnoreCase(fieldType);
        if (isDateType) {
            return "date";
        }
        boolean bl4 = isLocalDateTimeType = "DATETIME".equalsIgnoreCase(fieldType) || "DATETIME2".equalsIgnoreCase(fieldType) || "timestamp without time zone".equalsIgnoreCase(fieldType) || "TIMESTAMP".equalsIgnoreCase(fieldType) || (fieldType.startsWith("TIMESTAMP(") || fieldType.startsWith("timestamp(")) && fieldType.endsWith(")") || fieldType.startsWith("timestamp(") && fieldType.endsWith(") without time zone");
        if (isLocalDateTimeType) {
            return "localdatetime";
        }
        boolean bl5 = isTimeType = "TIME".equalsIgnoreCase(fieldType) || "time without time zone".equalsIgnoreCase(fieldType);
        if (isTimeType) {
            return "date";
        }
        boolean bl6 = isStringType = "CHAR".equalsIgnoreCase(fieldType) || "VARCHAR".equalsIgnoreCase(fieldType) || "VARCHAR2".equalsIgnoreCase(fieldType) || "BPCHAR".equalsIgnoreCase(fieldType) || "NVARCHAR".equalsIgnoreCase(fieldType) || "NCHAR".equalsIgnoreCase(fieldType) || "TINYTEXT".equalsIgnoreCase(fieldType) || "TEXT".equalsIgnoreCase(fieldType) || "CLOB".equalsIgnoreCase(fieldType) || "MEDIUMTEXT".equalsIgnoreCase(fieldType) || "LONGTEXT".equalsIgnoreCase(fieldType) || (fieldType.startsWith("character varying(") || fieldType.startsWith("NVARCHAR(") || fieldType.startsWith("character(") || fieldType.startsWith("VARCHAR2(")) && fieldType.endsWith(")");
        if (isStringType) {
            return "string";
        }
        boolean bl7 = isBooleanType = "TINYINT(1)".equalsIgnoreCase(fieldType) || "NUMBER(1)".equalsIgnoreCase(fieldType) || "BIT".equalsIgnoreCase(fieldType) || "BOOLEAN".equalsIgnoreCase(fieldType) || "BOOL".equalsIgnoreCase(fieldType);
        if (isBooleanType) {
            return "boolean";
        }
        return "string";
    }

    public static String convertJavaDataType(String javaType) {
        String dataTypeClass;
        String[] parts = javaType.split("\\.");
        String dataType = dataTypeClass = parts[parts.length - 1];
        if (!dataTypeClass.equals("Integer")) {
            dataType = dataTypeClass.toLowerCase();
        }
        return dataType;
    }

    public static String dataTypeConvertWidget(String dataType) {
        String widgetType = "";
        switch (dataType) {
            case "string": 
            case "array": 
            case "arrayPrimary": 
            case "object": 
            case "treeObject": {
                widgetType = WidgetType.INPUT.getType();
                break;
            }
            case "date": 
            case "localdatetime": {
                widgetType = WidgetType.DATE.getType();
                break;
            }
            case "int": 
            case "long": 
            case "double": 
            case "Integer": {
                widgetType = WidgetType.NUMBER.getType();
                break;
            }
            case "boolean": {
                widgetType = WidgetType.JXDNSwitch.getType();
                break;
            }
            case "text": {
                widgetType = WidgetType.TEXTAREA.getType();
                break;
            }
            default: {
                widgetType = WidgetType.INPUT.getType();
            }
        }
        return widgetType;
    }
}

