/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.storage.SettingStorageImpl;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.SummarySchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="no.code.summary")
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class SummaryStorageImpl
implements SettingSchemaService<SummarySchema> {
    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(SummarySchema summarySchema, String formId) throws Exception {
        SettingSchemaService settingService = (SettingSchemaService)SpringUtil.getBean(SettingStorageImpl.class);
        FormDesignResponse response = settingService.get(formId);
        FormSettingSchema responseSetting = (FormSettingSchema)((Object)response.getData());
        if (HussarUtils.isEmpty((Object)((Object)responseSetting))) {
            FormSettingSchema newSetting = new FormSettingSchema();
            newSetting.setDataSummary(summarySchema.getDataSummary());
            FormDesignResponse<Boolean> save = settingService.saveOrUpdate(newSetting, formId);
            if (((Boolean)save.getData()).booleanValue()) {
                return FormDesignResponse.success((Object)save.getData());
            }
        }
        responseSetting.setDataSummary(summarySchema.getDataSummary());
        FormDesignResponse<Boolean> save = settingService.saveOrUpdate(responseSetting, formId);
        if (((Boolean)save.getData()).booleanValue()) {
            return FormDesignResponse.success((Object)save.getData());
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u4fdd\u5b58\u6570\u636e\u6458\u8981\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)save.getData(), (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u4fdd\u5b58\u6570\u636e\u6458\u8981\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<SummarySchema> get(String formId) {
        FormSettingSchema setting = (FormSettingSchema)((Object)((SettingStorageImpl)SpringUtil.getBean(SettingStorageImpl.class)).get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)setting))) {
            return FormDesignResponse.success(null, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8868\u5355id\u7684\u8868\u5355\u8bbe\u7f6e->\u6570\u636e\u6458\u8981");
        }
        SummarySchema summarySchema = new SummarySchema();
        summarySchema.setDataSummary(setting.getDataSummary());
        return FormDesignResponse.success((Object)((Object)summarySchema));
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        FormSettingSchema setting = (FormSettingSchema)((Object)((SettingStorageImpl)SpringUtil.getBean(SettingStorageImpl.class)).get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)setting))) {
            ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u8868\u5355\u8bbe\u7f6e ==> Storage\u5220\u9664\u6570\u636e\u6458\u8981\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u5220\u9664\u8868\u5355\u8bbe\u7f6e ==> Storage\u5220\u9664\u6570\u636e\u6458\u8981\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }
}

