/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.FilterField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.TableButton;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CustomViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineOperationType;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ViewServiceImpl
implements ViewService {
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private CustomViewServiceImpl customViewService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ISysFormService sysFormService;
    private static Logger logger = LoggerFactory.getLogger(ViewServiceImpl.class);
    private static final String[] SYS_SHOW_FIELDS_NAME = new String[]{"title", "createTime_date", "updateTime_date", "dataOrganName", "createUser_user", "updateUser_user", "PROCESS_STATE", "PROCESS_NODE", "START_TIME", "TASK_DEF_NAME", "CREATE_TIME", "END_TIME", "FINISH_TIME", "securityLevel"};

    @Override
    @HussarTransactional
    public FormDesignResponse<Boolean> save(FormViewSchema formViewSchema) throws Exception {
        FormDesignResponse<Boolean> updateForm = this.viewSchemaService.saveOrUpdate(formViewSchema);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formViewSchema.getFormId());
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25");
        }
        FormDesignResponse<FormSchema> form = this.formOperateService.get(formViewSchema.getFormId());
        this.canvasService.updateTableAndSync(EngineOperationType.ADD.getOperationType(), (FormSchema)form.getData(), null);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    @HussarTransactional
    public FormDesignResponse<Boolean> saveWithPublic(FormViewSchema formViewSchema) throws Exception {
        List<DataView> views = formViewSchema.getViews();
        ArrayList<DataView> publicViews = new ArrayList<DataView>();
        ArrayList<DataView> sysViews = new ArrayList<DataView>();
        ArrayList<String> order = new ArrayList<String>();
        for (DataView view : views) {
            order.add(view.getName());
            if (HussarUtils.equals((Object)view.getCategory(), (Object)"sys")) {
                sysViews.add(view);
                continue;
            }
            publicViews.add(view);
        }
        formViewSchema.setViewOrder(order);
        List dataViews = (List)this.customViewService.get(formViewSchema.getFormId()).getData();
        if (HussarUtils.isNotEmpty((Object)dataViews)) {
            List oldPublicView = dataViews.stream().filter(v -> HussarUtils.equals((Object)v.getCategory(), (Object)"public")).collect(Collectors.toList());
            ArrayList<String> delIds = new ArrayList<String>();
            for (DataView oldView : oldPublicView) {
                if (!publicViews.stream().noneMatch(x -> HussarUtils.equals((Object)x.getId(), (Object)oldView.getId()))) continue;
                delIds.add(oldView.getId());
            }
            if (HussarUtils.isNotEmpty(delIds)) {
                this.customViewService.removeByIds(delIds);
            }
        }
        if (HussarUtils.isNotEmpty(publicViews)) {
            this.customViewService.updateBatch(formViewSchema.getFormId(), publicViews);
        }
        formViewSchema.setViews(sysViews);
        FormDesignResponse<Boolean> updateForm = this.viewSchemaService.saveOrUpdate(formViewSchema);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formViewSchema.getFormId());
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<FormViewSchema> get(String formId) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)((Object)formId));
        return this.get(sysForm, true);
    }

    @Override
    public FormDesignResponse<FormViewSchema> get(SysForm form, boolean updateView) {
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(form).getData());
        if (HussarUtils.isEmpty((Object)((Object)formCanvasSchema))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)form.getId());
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        return this.get(form, formCanvasSchema, updateView);
    }

    @Override
    public FormDesignResponse<FormViewSchema> get(SysForm form, FormCanvasSchema formCanvasSchema, boolean updateView) {
        FormViewSchema view = (FormViewSchema)this.viewSchemaService.get(form).getData();
        if (HussarUtils.isEmpty((Object)view)) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)form.getId());
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25");
        }
        List<Widget> widgetsWithSys = formCanvasSchema.widgetsWithSys();
        if ("1".equals(formCanvasSchema.getFormType())) {
            ViewServiceImpl.addFlow(widgetsWithSys);
        }
        List<Widget> childedTables = formCanvasSchema.childTables();
        widgetsWithSys.addAll(childedTables);
        widgetsWithSys = WidgetTool.settingWidgets(widgetsWithSys, widget -> WidgetTool.anyMatch(widget.getName(), "post", "dataOrgan", "staff", "PROCESS_INST_ID", "TASK_ID", "TASK_DEF_KEY"));
        view.setColumns(widgetsWithSys);
        if (updateView) {
            this.updateShowFieldsNew(formCanvasSchema, view);
        }
        FormViewSchema newView = this.contrastTemplateView(view);
        return FormDesignResponse.success((Object)view);
    }

    public static void addFlow(List<Widget> widgets) {
        widgets.addAll(PageBuilderFactory.getProcessInfoWidgets());
        widgets.addAll(PageBuilderFactory.getProcessTaskInfoWidgets());
    }

    @Override
    public FormDesignResponse<FormViewSchema> getWithPublic(String formId) {
        FormViewSchema view = (FormViewSchema)this.viewSchemaService.get(formId).getData();
        if (HussarUtils.isEmpty((Object)view)) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25");
        }
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)formCanvasSchema))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        List<Widget> widgetsWithSys = formCanvasSchema.widgets();
        if ("1".equals(formCanvasSchema.getFormType())) {
            ViewServiceImpl.addFlow(widgetsWithSys);
        }
        List<Widget> childedTables = formCanvasSchema.childTables();
        widgetsWithSys.addAll(childedTables);
        widgetsWithSys = WidgetTool.settingWidgets(widgetsWithSys, x -> HussarUtils.equals((Object)true, (Object)x.isVirtualField()));
        widgetsWithSys.addAll(formCanvasSchema.systemWidgets());
        widgetsWithSys = WidgetTool.settingWidgets(widgetsWithSys, widget -> WidgetTool.anyMatch(widget.getName(), "post", "dataOrgan", "staff", "PROCESS_INST_ID", "TASK_ID", "TASK_DEF_KEY"));
        view.setColumns(widgetsWithSys);
        this.updateShowFieldsNew(formCanvasSchema, view);
        List customViews = (List)this.customViewService.get(formId).getData();
        ArrayList<DataView> allViews = new ArrayList<DataView>();
        ArrayList<DataView> result = new ArrayList<DataView>();
        if (HussarUtils.isNotEmpty((Object)customViews)) {
            for (DataView customView : customViews) {
                if (!HussarUtils.equals((Object)customView.getCategory(), (Object)"public")) continue;
                allViews.add(customView);
            }
        }
        List<DataView> views = view.getViews();
        List<String> widgets = Arrays.asList("JXDNGroups", "JXDNChildrenTable", "JXDNEmbed", "JXDNGraphicDisplay", "JXDNDivider", "JXDNChildrenTableAgg", "JXDNAmountCapital", "JXDNTab", "JXDNTabs", WidgetType.JXDN_CASCADER.getType(), WidgetType.JXDN_CASCADER_MULTI.getType());
        if (HussarUtils.isNotEmpty(views)) {
            for (DataView dataView : views) {
                Map map = dataView.getStyles();
                List filterFields = dataView.getFilterFields();
                if (HussarUtils.isEmpty((Object)filterFields)) {
                    ArrayList filterFieldList = new ArrayList();
                    dataView.getShowFields().forEach(showField -> {
                        String fieldName = showField.getName();
                        view.getColumns().forEach(widget -> {
                            if (widget.getName().equals(fieldName) && !widgets.contains(widget.getType())) {
                                FilterField filterField = new FilterField();
                                filterField.setName(widget.getName());
                                filterField.setTitle(widget.getTitle());
                                filterFieldList.add(filterField);
                            }
                        });
                    });
                    dataView.setFilterFields(filterFieldList);
                }
                if (HussarUtils.isEmpty(map.get("clickDataTitle"))) {
                    map.put("clickDataTitle", 1);
                }
                if (HussarUtils.isEmpty(map.get("clickRow"))) {
                    map.put("clickRow", 0);
                }
                if (HussarUtils.isEmpty(map.get("triggerModeType"))) {
                    map.put("triggerModeType", 0);
                }
                if (HussarUtils.isEmpty(map.get("drawerOrientations"))) {
                    map.put("drawerOrientations", 0);
                }
                if (HussarUtils.isEmpty(map.get("showOperationColumn"))) {
                    map.put("showOperationColumn", 1);
                }
                dataView.setStyles(map);
            }
        }
        allViews.addAll(view.getViews());
        List widgetNames = widgetsWithSys.stream().map(Widget::getName).collect(Collectors.toList());
        for (DataView dataView : allViews) {
            List showFieldNames;
            List showFields = dataView.getShowFields();
            if (HussarUtils.isNotEmpty((Object)showFields)) {
                showFields = showFields.stream().filter(showField -> widgetNames.contains(showField.getName())).collect(Collectors.toList());
                dataView.setShowFields(showFields);
            }
            List filterFields = dataView.getFilterFields();
            List topFilterFields = dataView.getTopFilterFields();
            if (HussarUtils.isNotEmpty((Object)filterFields) && !"fieldCleared".equals(((FilterField)filterFields.get(0)).getName())) {
                showFieldNames = dataView.getShowFields().stream().map(ShowField::getName).collect(Collectors.toList());
                filterFields = filterFields.stream().filter(HussarUtils::isNotEmpty).filter(filterField -> showFieldNames.contains(filterField.getName())).collect(Collectors.toList());
                dataView.setFilterFields(filterFields);
            }
            if (HussarUtils.isNotEmpty((Object)topFilterFields) && !"fieldCleared".equals(((FilterField)topFilterFields.get(0)).getName())) {
                showFieldNames = dataView.getShowFields().stream().map(ShowField::getName).collect(Collectors.toList());
                topFilterFields = topFilterFields.stream().filter(topFilterField -> showFieldNames.contains(topFilterField.getName())).collect(Collectors.toList());
                dataView.setTopFilterFields(topFilterFields);
            }
            List toolsList = dataView.getTools();
            toolsList.sort((w1, w2) -> {
                String[] order = new String[]{"\u8fc7\u6ee4", "\u81ea\u5b9a\u4e49\u663e\u793a\u65b9\u6848", "\u5237\u65b0"};
                int index1 = -1;
                int index2 = -1;
                for (int i = 0; i < order.length; ++i) {
                    if (order[i].equals(w1.getName())) {
                        index1 = i;
                    }
                    if (!order[i].equals(w2.getName())) continue;
                    index2 = i;
                }
                return Integer.compare(index1, index2);
            });
            for (TableButton tableButton : toolsList) {
                switch (tableButton.getName()) {
                    case "\u8fc7\u6ee4": {
                        tableButton.setAlias("\u67e5\u8be2\u7ba1\u7406");
                        break;
                    }
                    case "\u81ea\u5b9a\u4e49\u663e\u793a\u65b9\u6848": {
                        tableButton.setAlias("\u8868\u683c\u663e\u793a\u8bbe\u7f6e");
                    }
                }
            }
        }
        List<String> list = view.getViewOrder();
        if (HussarUtils.isNotEmpty(list)) {
            for (String id : list) {
                Optional<DataView> first = allViews.stream().filter(v -> HussarUtils.equals((Object)v.getName(), (Object)id)).findFirst();
                if (!first.isPresent()) continue;
                result.add(first.get());
            }
        }
        result = HussarUtils.isEmpty(result) ? allViews : result;
        view.setViews(result);
        FormViewSchema formViewSchema = this.contrastTemplateView(view);
        return FormDesignResponse.success((Object)view);
    }

    private FormViewSchema contrastTemplateView(FormViewSchema view) {
        DataView baseView;
        FormViewSchema viewSchema = new FormViewSchema();
        if ("0".equals(view.getFormType())) {
            viewSchema = PageBuilderFactory.getDefaultViewSchema();
            baseView = viewSchema.getViews().stream().filter(v -> "joiopt0oou9plqj559byloyqdj0dk31i".equals(v.getId())).findFirst().orElseThrow(() -> new HussarException("\u666e\u901a\u8868\u5355\u6a21\u677f\u89c6\u56fe\u4e0d\u5b58\u5728"));
        } else if ("1".equals(view.getFormType())) {
            viewSchema = PageBuilderFactory.getDefaultFlowViewSchema();
            baseView = viewSchema.getViews().stream().filter(v -> "e33a41s5fcl06btfvdc0qnbvqt9wd1h4".equals(v.getId())).findFirst().orElseThrow(() -> new HussarException("\u6d41\u7a0b\u8868\u5355\u6a21\u677f\u89c6\u56fe\u4e0d\u5b58\u5728"));
        } else {
            baseView = null;
        }
        if (HussarUtils.isEmpty((Object)viewSchema)) {
            return view;
        }
        List<DataView> templateViews = viewSchema.getViews();
        List<DataView> dataViews = view.getViews();
        for (DataView dataView : dataViews) {
            Optional<DataView> first = templateViews.stream().filter(v -> HussarUtils.equals((Object)v.getId(), (Object)dataView.getId())).findFirst();
            DataView target = first.orElseGet(() -> {
                if ("public".equals(dataView.getCategory())) {
                    return baseView;
                }
                return null;
            });
            if (HussarUtils.isEmpty((Object)target)) continue;
            ArrayList<TableButton> newButtons = new ArrayList<TableButton>();
            for (TableButton button2 : target.getButtons()) {
                List buttons = dataView.getButtons();
                if (buttons.stream().anyMatch(b -> HussarUtils.equals((Object)b.getId(), (Object)button2.getId()))) continue;
                if (button2.getAction().equals("batchPrint")) {
                    button2.setChecked(false);
                }
                newButtons.add(button2);
            }
            dataView.getButtons().addAll(newButtons);
            Optional<TableButton> optional = dataView.getButtons().stream().filter(button -> "hjbs71mdgamipm1wqxaitdlb2rdig9na".equals(button.getId())).findFirst();
        }
        return view;
    }

    private void updateShowFields(FormCanvasSchema canvasSchema, FormViewSchema formViewSchema) {
        List<Widget> widgets = canvasSchema.widgets();
        widgets.addAll(canvasSchema.childTables());
        if (HussarUtils.isEmpty(widgets)) {
            return;
        }
        List<Widget> showWidgets = canvasSchema.widgetsWithSys();
        showWidgets.addAll(canvasSchema.childTables());
        if ("1".equals(canvasSchema.getFormType())) {
            ViewServiceImpl.addFlow(showWidgets);
        }
        List<Widget> finalShowWidgets = showWidgets = WidgetTool.settingWidgets(showWidgets, widget -> WidgetTool.anyMatch(widget.getName(), "post", "dataOrgan", "staff", "postName", "createUserName", "updateUserName", "PROCESS_INST_ID", "TASK_ID", "TASK_DEF_KEY", "PROCESS_NODE", "FINISH_TIME", "TASK_INFO_ID", "BUSINESS_ID", "ASSIGNEE", "TASK_DEF_NAME", "TASK_STATE", "FORM_KEY", "FORM_DETAIL_KEY", "END_TIME", "CREATE_TIME", "PROCESS_KEY"));
        List<ShowField> fields = ViewServiceImpl.convertShowFields(showWidgets, widgetName -> finalShowWidgets.stream().map(Widget::getName).anyMatch(newName -> newName.equals(widgetName)));
        List fieldNames = fields.stream().map(ShowField::getName).collect(Collectors.toList());
        for (DataView view : formViewSchema.getViews()) {
            ArrayList<ShowField> sameShowFields = new ArrayList<ShowField>();
            ArrayList<ShowField> diffShowFields = new ArrayList<ShowField>(fields);
            List viewShowFields = view.getShowFields();
            for (ShowField viewShowField : viewShowFields) {
                if (!fieldNames.contains(viewShowField.getName())) continue;
                sameShowFields.add(viewShowField);
                diffShowFields.removeIf(showField -> HussarUtils.equals((Object)showField.getName(), (Object)viewShowField.getName()));
            }
            sameShowFields.addAll(sameShowFields.size() - 5, diffShowFields);
            view.setShowFields(sameShowFields);
        }
    }

    private void updateShowFieldsNew(FormCanvasSchema canvasSchema, FormViewSchema formViewSchema) {
        List<Widget> allWidgets = canvasSchema.widgets();
        allWidgets.addAll(canvasSchema.childTables());
        List<Widget> widgets = allWidgets.stream().filter(widget -> widget.getIsRealField() && !widget.isVirtualField()).collect(Collectors.toList());
        ArrayList<Widget> processWidgets = new ArrayList<Widget>();
        if (HussarUtils.equals((Object)"1", (Object)canvasSchema.getFormType())) {
            List<Widget> processWidget = PageBuilderFactory.getProcessInfoWidgets();
            processWidgets.addAll(processWidget);
        }
        List<Widget> newProcessWidgets = processWidgets.stream().filter(r -> HussarUtils.equals((Object)r.getName(), (Object)"PROCESS_NODE")).collect(Collectors.toList());
        List<ShowField> processShowFields = ViewServiceImpl.convertShowFields(newProcessWidgets, widgetName -> newProcessWidgets.stream().map(Widget::getName).anyMatch(newName -> newName.equals(widgetName)));
        List<ShowField> nowShowFields = ViewServiceImpl.convertShowFields(widgets, widgetName -> widgets.stream().map(Widget::getName).anyMatch(newName -> newName.equals(widgetName)));
        List nowShowFieldsName = nowShowFields.stream().map(ShowField::getName).collect(Collectors.toList());
        List customViews = (List)this.customViewService.get(formViewSchema.getFormId()).getData();
        ArrayList<DataView> views = new ArrayList<DataView>();
        if (HussarUtils.isNotEmpty((Object)customViews)) {
            views.addAll(customViews.stream().filter(v -> HussarUtils.equals((Object)v.getCategory(), (Object)"public")).collect(Collectors.toList()));
        }
        views.addAll(formViewSchema.getViews());
        for (DataView view : views) {
            List oldShowFields = view.getShowFields();
            List oldShowFieldsName = view.getShowFields().stream().map(ShowField::getName).collect(Collectors.toList());
            oldShowFields = oldShowFields.stream().filter(showField -> {
                String showFieldName = showField.getName();
                if (!HussarUtils.contains((Object[])Arrays.stream(SYS_SHOW_FIELDS_NAME).toArray(), (Object)showFieldName)) {
                    return nowShowFieldsName.contains(showFieldName);
                }
                return true;
            }).collect(Collectors.toList());
            view.setShowFields(oldShowFields);
            List newShowFields = nowShowFields.stream().filter(showField -> !oldShowFieldsName.contains(showField.getName())).collect(Collectors.toList());
            boolean isNewForm = oldShowFields.stream().anyMatch(f -> HussarUtils.equals((Object)f.getName(), (Object)"PROCESS_NODE"));
            if (!isNewForm && !HussarUtils.equals((Object)view.getAlias(), (Object)"\u6211\u7684\u8349\u7a3f")) {
                newShowFields.addAll(processShowFields);
            }
            view.getShowFields().addAll(view.getShowFields().size() - 5, newShowFields);
            if (HussarUtils.equals((Object)view.getViewType(), (Object)4)) {
                this.handleGroupViewField(formViewSchema.getColumns(), view);
            }
            if (!HussarUtils.equals((Object)view.getCategory(), (Object)"public")) continue;
            this.customViewService.update(view);
        }
    }

    private static List<ShowField> convertShowFields(List<Widget> widgets, Predicate<String> predicate) {
        ArrayList<ShowField> newShowFields = new ArrayList<ShowField>();
        for (Widget widget : widgets) {
            ShowField showField = new ShowField();
            showField.setChecked(predicate.test(widget.getName()));
            showField.setName(widget.getName());
            showField.setTitle(widget.getTitle());
            showField.setAlign("center");
            showField.setWidth(68 + widget.getTitle().length() * 14);
            showField.setIsMinWidth(true);
            showField.setAlias(widget.getAlias());
            showField.setI18nKeys(widget.getI18nKeys());
            newShowFields.add(showField);
        }
        return newShowFields;
    }

    private void handleGroupViewField(List<Widget> columns, DataView view) {
        List newWidgetNames = columns.stream().map(Widget::getName).collect(Collectors.toList());
        Map configs = view.getConfigs();
        if (HussarUtils.isNotEmpty((Object)configs)) {
            JSONObject defaultGroup;
            Object defaultName;
            Object groupView = configs.get("groupView");
            Map groupViewMap = (Map)JSON.parseObject((String)JSONObject.toJSONString(groupView), Map.class);
            if (HussarUtils.isNotEmpty(groupViewMap.get("defaultGroup")) && HussarUtils.isNotEmpty((Object)(defaultName = (defaultGroup = (JSONObject)JSON.parseObject((String)JSONObject.toJSONString(groupViewMap.get("defaultGroup")), JSONObject.class)).get((Object)"name"))) && !HussarUtils.contains(newWidgetNames.iterator(), (Object)((String)defaultName))) {
                groupViewMap.put("defaultGroup", new Object());
            }
            if (HussarUtils.isNotEmpty(groupViewMap.get("groupFields"))) {
                List groupFields = JSON.parseArray((String)JSONObject.toJSONString(groupViewMap.get("groupFields")), Map.class);
                ArrayList<Map> newGroupFields = new ArrayList<Map>();
                for (Map groupField : groupFields) {
                    if (!HussarUtils.contains(newWidgetNames.iterator(), (Object)((String)groupField.get("name")))) continue;
                    String label = columns.stream().filter(x -> HussarUtils.equals((Object)x.getName(), (Object)((String)groupField.get("name")))).findAny().get().getTitle();
                    groupField.put("label", label);
                    newGroupFields.add(groupField);
                }
                groupViewMap.put("groupFields", newGroupFields);
            }
            if (HussarUtils.isNotEmpty(groupViewMap.get("order"))) {
                List orders = JSON.parseArray((String)JSONObject.toJSONString(groupViewMap.get("order")), Map.class);
                ArrayList<Map> newOrders = new ArrayList<Map>();
                for (Map order : orders) {
                    if (!HussarUtils.contains(newWidgetNames.iterator(), (Object)((String)order.get("column")))) {
                        order.put("column", "");
                    }
                    newOrders.add(order);
                }
                groupViewMap.put("order", newOrders);
            }
            configs.put("groupView", groupViewMap);
        }
        view.setConfigs(configs);
    }
}

