/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.CharacterConversService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.UpgradeService;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.builder.BuilderCtx;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.PageBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.ProjectStoreTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import javax.annotation.Resource;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.springframework.stereotype.Service;

@Service
public class UpgradeServiceImpl
implements UpgradeService {
    @Resource
    private ISysApplicationExternalService externalService;
    @Resource
    private FormOperateService formOperateService;

    @Override
    public ApiResponse<String> start(String type, List<String> appIds, String targetApp) throws Exception {
        for (String appId : appIds) {
            ApiResponse apiResponse = this.externalService.getFormListByAppId(Long.valueOf(appId));
            SysSiftGroupList siftGroupList = (SysSiftGroupList)apiResponse.getData();
            if (HussarUtils.isEmpty((Object)siftGroupList)) {
                ToolUtil.getLogger(UpgradeServiceImpl.class).info("\u5f53\u524d\u5e94\u7528\u4e0b\u8868\u5355\u83b7\u53d6\u4e3a\u7a7a\uff1aappId{}", (Object)appId);
                continue;
            }
            AppContextUtil.setAppId((String)appId);
            if (HussarUtils.isNotEmpty((Object)siftGroupList.getHaveGroupList())) {
                for (SysFormGroupVo group : siftGroupList.getHaveGroupList()) {
                    for (SysForm sysForm : group.getSysFormList()) {
                        this.upgrade(type, appId, String.valueOf(sysForm.getId()), targetApp);
                    }
                }
            }
            if (!HussarUtils.isNotEmpty((Object)siftGroupList.getNoGroupList())) continue;
            for (SysForm sysForm : siftGroupList.getNoGroupList()) {
                this.upgrade(type, appId, String.valueOf(sysForm.getId()), targetApp);
            }
        }
        return ApiResponse.success((String)ProjectStoreTool.tempPath(targetApp));
    }

    public void upgrade(String type, String appId, String formId, String targetApp) throws Exception {
        FormDesignResponse<FormSchema> form = this.formOperateService.get(formId);
        if (form.getErrorCode() != ResultCode.SUCCESS.getCode() || HussarUtils.isEmpty(form) || HussarUtils.isEmpty((Object)form.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u96f6\u8f6c\u4f4e ==> \u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        }
        BuilderCtx ctx = new BuilderCtx((FormSchema)form.getData());
        this.module(appId, ctx);
        DataModelBuilder modelBuilder = ModelBuilderAdapter.adaptBuilder((FormSchema)form.getData());
        modelBuilder.build(ctx);
        String formType = ctx.getForm().getFormCanvas().getFormType();
        PageBuilder builder = PageBuilderFactory.strategy(String.format("%s%s%s%s", type, ".form.page.", formType, ".builder"));
        builder.init(ctx);
        builder.direct();
        ProjectStoreTool.write(ctx, targetApp);
    }

    public SysFormGroupVo getGroup(String appId, String formId) {
        ApiResponse apiResponse = this.externalService.getFormListByAppId(Long.valueOf(appId));
        SysSiftGroupList siftGroupList = (SysSiftGroupList)apiResponse.getData();
        if (HussarUtils.isEmpty((Object)siftGroupList)) {
            ToolUtil.getLogger(UpgradeServiceImpl.class).info("\u5f53\u524d\u5e94\u7528\u4e0b\u8868\u5355\u83b7\u53d6\u4e3a\u7a7a\uff1aappId{}", (Object)appId);
            return null;
        }
        SysForm form = this.externalService.getFormDetailById(Long.valueOf(formId));
        if (HussarUtils.isEmpty((Object)form) || HussarUtils.isEmpty((Object)form.getFormGroupId())) {
            return null;
        }
        List groupList = siftGroupList.getHaveGroupList();
        return groupList.stream().filter(sysFormGroupVo -> sysFormGroupVo.getId().equals(form.getFormGroupId())).findFirst().orElse(null);
    }

    @Override
    public String module(String appId, BuilderCtx ctx) {
        FormCanvasSchema canvas = ctx.getForm().getFormCanvas();
        SysFormGroupVo group = this.getGroup(appId, canvas.getId());
        SysApplicationVo app = this.externalService.getAppDetailById(Long.valueOf(appId));
        CharacterConversService characterConversService = (CharacterConversService)SpringUtil.getBean(CharacterConversService.class);
        StringBuilder pathBuilder = new StringBuilder();
        ModuleInfo appModule = new ModuleInfo();
        appModule.setId(appId);
        String appName = characterConversService.changeToPinyinFirstLow(app.getAppName(), HanyuPinyinCaseType.LOWERCASE);
        pathBuilder.append(String.format("/%s", appName));
        appModule.setName(appName);
        appModule.setDesc(app.getAppName());
        appModule.setParentId("#");
        appModule.setType("Module");
        appModule.setModuleType("Module");
        ctx.putMeta(appId, (BaseFile)appModule);
        if (HussarUtils.isNotEmpty((Object)group)) {
            String groupId = String.valueOf(group.getId());
            ModuleInfo groupModule = new ModuleInfo();
            groupModule.setId(groupId);
            String groupName = characterConversService.changeToPinyinFirstLow(group.getGroupName(), HanyuPinyinCaseType.LOWERCASE);
            pathBuilder.append(String.format("/%s", groupName));
            groupModule.setName(groupName);
            groupModule.setDesc(group.getGroupName());
            groupModule.setParentId(appModule.getId());
            groupModule.setType("Module");
            groupModule.setModuleType("Module");
            ctx.putMeta(groupId, (BaseFile)groupModule);
        }
        String formModuleId = canvas.getId() + "module";
        ModuleInfo formModule = new ModuleInfo();
        formModule.setId(formModuleId);
        String formName = characterConversService.changeToPinyinFirstLow(canvas.getTitle(), HanyuPinyinCaseType.LOWERCASE);
        formModule.setName(formName);
        formModule.setDesc(canvas.getTitle());
        formModule.setParentId(HussarUtils.isNotEmpty((Object)group) ? String.valueOf(group.getId()) : appModule.getId());
        formModule.setType("Module");
        formModule.setModuleType("Module");
        ctx.putMeta(formModule.getId(), (BaseFile)formModule);
        ctx.setFormModuleId(formModuleId);
        pathBuilder.append(String.format("/%s", formName));
        pathBuilder.append(String.format("/%s", formName));
        return pathBuilder.toString();
    }
}

