/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseId;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FormDetailVO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.FieldControlUnitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.HideRuleSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.RuleField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.RuleSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineOperationType;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ReferenceService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.ResourceReference;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FieldControlCollection;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.ShowForms;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.SummarySchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSummarySchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.service.SysActFormAuthApiService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SettingServiceImpl
implements SettingService {
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ReferenceService referenceService;
    @Resource
    @Lazy
    private SysActFormAuthApiService formAuthApiService;
    @Resource
    private ISysApplicationExternalService externalService;
    @Resource
    private ModelRelateService modelRelateService;

    @Override
    @HussarTransactional
    public FormDesignResponse<Boolean> saveTitle(TitleSchema titleSchema, String formId) throws Exception {
        FormSchema formSchemaOld = (FormSchema)this.formOperateService.get(formId).getData();
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.title", SettingSchemaService.class);
        FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(titleSchema, formId);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6807\u9898\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6807\u9898\u5931\u8d25");
        }
        FormDesignResponse<FormSchema> form = this.formOperateService.get(formId);
        this.canvasService.updateTableAndSync(EngineOperationType.UPDATE.getOperationType(), (FormSchema)form.getData(), formSchemaOld);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveSummary(List<String> dataSummary, String formId) throws Exception {
        FormSchema formSchemaOld = (FormSchema)this.formOperateService.get(formId).getData();
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.summary", SettingSchemaService.class);
        SummarySchema summarySchema = new SummarySchema();
        summarySchema.setDataSummary(dataSummary);
        FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(summarySchema, formId);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6458\u8981\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6458\u8981\u5931\u8d25");
        }
        FormDesignResponse<FormSchema> form = this.formOperateService.get(formId);
        this.canvasService.updateTableAndSync(EngineOperationType.UPDATE.getOperationType(), (FormSchema)form.getData(), formSchemaOld);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveFieldControl(FieldControlSchema fieldControlSchema, String formId) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class);
        FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(fieldControlSchema, formId);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u5b57\u6bb5\u63a7\u5236\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u5b57\u6bb5\u63a7\u5236\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveSubmit(SubmitSchema submitSchema, String formId) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.submit", SettingSchemaService.class);
        FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(submitSchema, formId);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u8868\u5355\u63d0\u4ea4\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u8868\u5355\u63d0\u4ea4\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<TitleSchema> getTitle(String formId) {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.title", SettingSchemaService.class);
        TitleSchema title = (TitleSchema)((Object)settingSchemaService.get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)title))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u6570\u636e\u6807\u9898\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u6570\u636e\u6807\u9898\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)((Object)title));
    }

    @Override
    public FormDesignResponse<List<String>> getSummary(String formId) {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.summary", SettingSchemaService.class);
        SummarySchema summary = (SummarySchema)((Object)settingSchemaService.get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)summary))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u6570\u636e\u6458\u8981\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u6570\u636e\u6458\u8981\u5931\u8d25");
        }
        return FormDesignResponse.success(summary.getDataSummary());
    }

    @Override
    public FormDesignResponse<FieldControlUnitSchema> getFieldControl(String formId) throws IOException {
        FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        return this.getFieldControlWithCanvsa(formId, canvas);
    }

    public FormDesignResponse<FieldControlUnitSchema> getFieldControlWithCanvsa(String formId, FormCanvasSchema canvas) throws IOException {
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        FormDesignResponse fieldControlResponse = ((SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class)).get(formId);
        FieldControlSchema fieldControlSchema = (FieldControlSchema)fieldControlResponse.getData();
        fieldControlSchema = HussarUtils.isEmpty((Object)fieldControlSchema) ? new FieldControlSchema() : fieldControlSchema;
        List<Widget> allWidgets = canvas.widgets();
        List<Widget> widgets = allWidgets.stream().filter(x -> HussarUtils.equals((Object)x.getIsRealField(), (Object)true)).collect(Collectors.toList());
        List<Widget> childTables = canvas.childTables();
        List childControls = fieldControlSchema.getAdd().stream().filter(fieldControl -> HussarUtils.isNotEmpty((Object)fieldControl.getChildren()) && HussarUtils.equals((Object)fieldControl.getType(), (Object)WidgetType.CHILDREN_TABLE.getType())).collect(Collectors.toList());
        List<FieldControl> firstControls = fieldControlSchema.getAdd().stream().filter(fieldControl -> HussarUtils.isEmpty((Object)fieldControl.getChildren()) && !HussarUtils.equals((Object)fieldControl.getType(), (Object)WidgetType.CHILDREN_TABLE.getType())).collect(Collectors.toList());
        this.set(firstControls, widgets);
        for (FieldControl fieldControl2 : childControls) {
            String field = fieldControl2.getField();
            Optional<Widget> childWidget = childTables.stream().filter(widget -> widget.getName().equals(field)).findFirst();
            if (!childWidget.isPresent()) continue;
            this.set(fieldControl2.getChildren(), childWidget.get().getChildren());
        }
        List eChildControls = fieldControlSchema.getEdit().stream().filter(fieldControl -> HussarUtils.isNotEmpty((Object)fieldControl.getChildren()) && HussarUtils.equals((Object)fieldControl.getType(), (Object)WidgetType.CHILDREN_TABLE.getType())).collect(Collectors.toList());
        List<FieldControl> eFirstControls = fieldControlSchema.getEdit().stream().filter(fieldControl -> HussarUtils.isEmpty((Object)fieldControl.getChildren()) && !HussarUtils.equals((Object)fieldControl.getType(), (Object)WidgetType.CHILDREN_TABLE.getType())).collect(Collectors.toList());
        this.set(eFirstControls, widgets);
        for (FieldControl fieldControl3 : eChildControls) {
            String field = fieldControl3.getField();
            Optional<Widget> childWidget = childTables.stream().filter(widget -> widget.getName().equals(field)).findFirst();
            if (!childWidget.isPresent()) continue;
            this.set(fieldControl3.getChildren(), childWidget.get().getChildren());
        }
        if (HussarUtils.isEmpty((Object)fieldControlSchema.getDetail())) {
            fieldControlSchema.setDetail(fieldControlSchema.getEdit());
            try {
                this.saveFieldControl(fieldControlSchema, formId);
            }
            catch (Exception e) {
                System.out.println("\u65e7\u8868\u5355\u6ca1\u6709detail\u914d\u7f6e\u9879");
            }
        }
        List dChildControls = fieldControlSchema.getDetail().stream().filter(fieldControl -> HussarUtils.isNotEmpty((Object)fieldControl.getChildren()) && HussarUtils.equals((Object)fieldControl.getType(), (Object)WidgetType.CHILDREN_TABLE.getType())).collect(Collectors.toList());
        List<FieldControl> dFirstControls = fieldControlSchema.getDetail().stream().filter(fieldControl -> HussarUtils.isEmpty((Object)fieldControl.getChildren()) && !HussarUtils.equals((Object)fieldControl.getType(), (Object)WidgetType.CHILDREN_TABLE.getType())).collect(Collectors.toList());
        this.set(dFirstControls, widgets);
        for (FieldControl fieldControl4 : dChildControls) {
            String field = fieldControl4.getField();
            Optional<Widget> childWidget = childTables.stream().filter(widget -> widget.getName().equals(field)).findFirst();
            if (!childWidget.isPresent()) continue;
            this.set(fieldControl4.getChildren(), childWidget.get().getChildren());
        }
        ArrayList<FieldControl> add = HussarUtils.isEmpty((Object)fieldControlSchema.getAdd()) ? new ArrayList() : fieldControlSchema.getAdd();
        ArrayList<FieldControl> edit = HussarUtils.isEmpty((Object)fieldControlSchema.getEdit()) ? new ArrayList() : fieldControlSchema.getEdit();
        ArrayList<FieldControl> detail = HussarUtils.isEmpty((Object)fieldControlSchema.getDetail()) ? new ArrayList() : fieldControlSchema.getDetail();
        ArrayList<Widget> widgetListAll = new ArrayList<Widget>();
        List<Widget> widgetList = canvas.widgetsContainChildren();
        if (HussarUtils.isNotEmpty(widgetList)) {
            widgetListAll.addAll(widgetList);
            if (HussarUtils.isNotEmpty(widgetListAll)) {
                this.sortFieldControl(add, widgetListAll);
                this.sortFieldControl(edit, widgetListAll);
                this.sortFieldControl(detail, widgetListAll);
            }
        }
        FieldControlUnitSchema fieldControlUnitSchema = new FieldControlUnitSchema();
        fieldControlUnitSchema.setFieldControl(fieldControlSchema);
        fieldControlUnitSchema.setFormType(canvas.getFormType());
        return FormDesignResponse.success((Object)fieldControlUnitSchema);
    }

    private void sortFieldControl(List<FieldControl> fieldControls, List<Widget> widgetsOrdered) {
        List orders = widgetsOrdered.stream().sorted(Comparator.comparingInt(Widget::getSeq)).map(Widget::getName).collect(Collectors.toList());
        for (FieldControl fieldControl : fieldControls) {
            Widget widget1;
            if (!HussarUtils.isNotEmpty((Object)fieldControl.getChildren()) || !WidgetTool.anyMatch(fieldControl.getType(), WidgetType.CHILDREN_TABLE.getType(), WidgetType.JXDNChildrenTableAgg.getType()) || !HussarUtils.isNotEmpty((Object)(widget1 = widgetsOrdered.stream().filter(widget -> fieldControl.getField().equals(widget.getName())).findFirst().get()))) continue;
            this.sortFieldControl(fieldControl.getChildren(), widget1.getChildren());
        }
        fieldControls.sort((o1, o2) -> {
            int io1 = orders.indexOf(o1.getField());
            int io2 = orders.indexOf(o2.getField());
            if (io1 == -1 && io2 == -1) {
                return 0;
            }
            if (io1 == -1 || io2 == -1) {
                return io1 == -1 ? 1 : -1;
            }
            return Integer.compare(io1, io2);
        });
    }

    private void set(List<FieldControl> controls, List<Widget> widgets) {
        for (FieldControl fieldControl : controls) {
            String field = fieldControl.getField();
            Optional<Widget> find = widgets.stream().filter(widget -> widget.getName().equals(field)).findFirst();
            if (!find.isPresent()) continue;
            fieldControl.setReadOnly(find.get().isReadOnly());
            fieldControl.setInChild(find.get().getIsInChild());
        }
    }

    @Override
    public FormDesignResponse<FieldControlCollection> geFieldControlCollection(String formId) throws IOException {
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(formId);
        FormDesignResponse<FieldControlUnitSchema> fieldControl = this.getFieldControlWithCanvsa(formId, (FormCanvasSchema)((Object)response.getData()));
        if (fieldControl.getErrorCode() == ResultCode.FAILURE.getCode()) {
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e\u5b57\u6bb5\u63a7\u5236\u5931\u8d25");
        }
        FieldControlCollection result = new FieldControlCollection();
        result.setFieldControlSchema((FieldControlUnitSchema)fieldControl.getData());
        if (((FieldControlUnitSchema)fieldControl.getData()).getFormType().equals("1")) {
            BpmResponseResult bpmResponseResult = null;
            try {
                bpmResponseResult = this.formAuthApiService.queryFormAuthConfigs(formId, null, "2", ((FormCanvasSchema)((Object)response.getData())).getIdentity());
            }
            catch (Exception e) {
                return FormDesignResponse.success((Object)result);
            }
            JSONArray bpmAuthArr = bpmResponseResult.getResult();
            if (HussarUtils.isNotEmpty((Object)bpmResponseResult.getResult())) {
                List actFormAuthList = (List)JsonUtil.convertValue((Object)bpmResponseResult.getResult().getJSONObject(0).get((Object)"data"), (TypeReference)new TypeReference<List<SysActFormAuth>>(){});
                if (HussarUtils.isEmpty((Object)actFormAuthList)) {
                    return FormDesignResponse.success((Object)result);
                }
                SysActFormAuth actFormAuth = (SysActFormAuth)actFormAuthList.get(0);
                ArrayList<String> bpmInsHidden = new ArrayList<String>();
                ArrayList<String> bpmInsDisabled = new ArrayList<String>();
                ArrayList<String> bpmRequired = new ArrayList<String>();
                if (HussarUtils.isNotBlank((CharSequence)actFormAuth.getInsHidden())) {
                    bpmInsHidden.addAll(Arrays.asList(actFormAuth.getInsHidden().substring(1, actFormAuth.getInsHidden().length() - 1).replaceAll("\"", "").split(",")));
                }
                if (HussarUtils.isNotBlank((CharSequence)actFormAuth.getInsRequired())) {
                    bpmRequired.addAll(Arrays.asList(actFormAuth.getInsRequired().substring(1, actFormAuth.getInsRequired().length() - 1).replaceAll("\"", "").split(",")));
                }
                if (HussarUtils.isNotBlank((CharSequence)actFormAuth.getInsDisabled())) {
                    bpmInsDisabled.addAll(Arrays.asList(actFormAuth.getInsDisabled().substring(1, actFormAuth.getInsDisabled().length() - 1).replaceAll("\"", "").split(",")));
                }
                ArrayList<FieldControl> controlList = new ArrayList<FieldControl>();
                HashMap<String, FieldControl> fieldControlMap = new HashMap<String, FieldControl>();
                this.initFieldControl(((FieldControlUnitSchema)fieldControl.getData()).getFieldControl().getAdd(), controlList, fieldControlMap);
                boolean isFirst = Boolean.parseBoolean(bpmResponseResult.getResult().getJSONObject(0).get((Object)"isFirst").toString());
                if (!isFirst) {
                    ArrayList<String> bpmInsShow = new ArrayList<String>();
                    if (HussarUtils.isNotBlank((CharSequence)actFormAuth.getInsShow())) {
                        bpmInsShow.addAll(Arrays.asList(actFormAuth.getInsShow().substring(1, actFormAuth.getInsShow().length() - 1).replaceAll("\"", "").split(",")));
                    }
                    ArrayList<String> bpmAllFields = new ArrayList<String>();
                    bpmAllFields.addAll(bpmInsShow);
                    bpmAllFields.addAll(bpmInsHidden);
                    ArrayList newFields = new ArrayList(fieldControlMap.keySet());
                    newFields.removeAll(bpmAllFields);
                    bpmInsDisabled.addAll(newFields);
                }
                this.changeControlType(bpmInsHidden, bpmInsDisabled, bpmRequired, fieldControlMap);
                result.setBpmControl(controlList);
            }
        }
        return FormDesignResponse.success((Object)result);
    }

    private List<FieldControl> initFieldControl(List<FieldControl> fieldControlList, List<FieldControl> result, Map<String, FieldControl> relationship) {
        if (HussarUtils.isNotEmpty(fieldControlList)) {
            for (FieldControl fieldControl : fieldControlList) {
                FieldControl newFieldControl = new FieldControl();
                newFieldControl.setField(fieldControl.getField());
                newFieldControl.setTitle(fieldControl.getTitle());
                newFieldControl.setType(fieldControl.getType());
                newFieldControl.setVisible(true);
                newFieldControl.setWitable(true);
                newFieldControl.setReadOnly(true);
                newFieldControl.setRequired(false);
                if (HussarUtils.isNotEmpty((Object)fieldControl.getChildren())) {
                    List<FieldControl> children = this.initFieldControl(fieldControl.getChildren(), new ArrayList<FieldControl>(), relationship);
                    newFieldControl.setChildren(children);
                }
                relationship.put(newFieldControl.getField(), newFieldControl);
                result.add(newFieldControl);
            }
        }
        return result;
    }

    private void changeControlType(List<String> disReadable, List<String> disWriteable, List<String> disRequired, Map<String, FieldControl> fieldControlMap) {
        FieldControl fieldControl;
        for (String fileId : disReadable) {
            fieldControl = fieldControlMap.get(fileId);
            if (!HussarUtils.isNotEmpty((Object)fieldControl)) continue;
            fieldControl.setVisible(false);
            fieldControl.setWitable(false);
        }
        for (String fileId : disWriteable) {
            fieldControl = fieldControlMap.get(fileId);
            if (!HussarUtils.isNotEmpty((Object)fieldControl)) continue;
            fieldControl.setWitable(false);
        }
        for (String fieldId : disRequired) {
            fieldControl = fieldControlMap.get(fieldId);
            if (!HussarUtils.isNotEmpty((Object)fieldControl)) continue;
            fieldControl.setRequired(true);
        }
    }

    private FieldControlSchema fieldControlSort(FieldControlSchema fieldControlSchema, FormCanvasSchema canvas) {
        ArrayList newAdd = new ArrayList();
        ArrayList newEdit = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)fieldControlSchema.getAdd()) && HussarUtils.isNotEmpty((Object)fieldControlSchema.getEdit())) {
            int i;
            for (Widget widget : canvas.widgets()) {
                for (i = 0; i < fieldControlSchema.getAdd().size(); ++i) {
                    if (!widget.getName().equals(((FieldControl)fieldControlSchema.getAdd().get(i)).getField())) continue;
                    newAdd.add(fieldControlSchema.getAdd().get(i));
                    newEdit.add(fieldControlSchema.getEdit().get(i));
                }
            }
            fieldControlSchema.setAdd(newAdd);
            fieldControlSchema.setEdit(newEdit);
            for (Widget childTable : canvas.childTables()) {
                for (i = 0; i < fieldControlSchema.getAdd().size(); ++i) {
                    if (!childTable.getName().equals(((FieldControl)fieldControlSchema.getAdd().get(i)).getField())) continue;
                    ArrayList addChildren = new ArrayList();
                    ArrayList editChildren = new ArrayList();
                    for (Widget childWidget : childTable.getChildren()) {
                        for (int j = 0; j < ((FieldControl)fieldControlSchema.getAdd().get(i)).getChildren().size(); ++j) {
                            if (!childWidget.getName().equals(((FieldControl)((FieldControl)fieldControlSchema.getAdd().get(i)).getChildren().get(j)).getField())) continue;
                            addChildren.add(((FieldControl)fieldControlSchema.getAdd().get(i)).getChildren().get(j));
                            editChildren.add(((FieldControl)fieldControlSchema.getEdit().get(i)).getChildren().get(j));
                        }
                    }
                    ((FieldControl)fieldControlSchema.getAdd().get(i)).setChildren(addChildren);
                    ((FieldControl)fieldControlSchema.getEdit().get(i)).setChildren(editChildren);
                }
            }
        }
        return fieldControlSchema;
    }

    @Override
    public FormDesignResponse<List<FormDetailVO>> getReference(String formId) throws JsonProcessingException {
        FormDesignResponse<List<ResourceReference>> referRes = this.referenceService.get();
        List references = (List)referRes.getData();
        if (HussarUtils.isEmpty((Object)references)) {
            return FormDesignResponse.success(null);
        }
        String currentAppId = AppContextUtil.getAppId();
        ArrayList<FormDetailVO> referForms = new ArrayList<FormDetailVO>();
        for (ResourceReference reference : references) {
            SysForm form;
            List<String> referKey = reference.getReferKey();
            List<String> sourceKey = reference.getSourceKey();
            if (!HussarUtils.isNotEmpty(referKey) || !HussarUtils.isNotEmpty(sourceKey) || referKey.size() <= 2 || sourceKey.size() <= 2) continue;
            String referAppId = referKey.get(0);
            String referFormId = referKey.get(1);
            if (!referAppId.equals(currentAppId) || !referFormId.equals(formId)) continue;
            String sourceAppId = sourceKey.get(0);
            String sourceFormId = sourceKey.get(1);
            SysApplicationVo app = this.externalService.getAppDetailById(Long.valueOf(sourceAppId));
            if (HussarUtils.isEmpty((Object)app) || HussarUtils.equals((Object)"0", (Object)app.getReleaseStatus()) || HussarUtils.isEmpty((Object)(form = this.externalService.getFormDetailById(Long.valueOf(sourceFormId))))) continue;
            AppContextUtil.setAppId((String)sourceAppId);
            FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasService.get(sourceFormId);
            FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
            if (HussarUtils.isEmpty((Object)((Object)canvas))) {
                ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u5173\u8054\u5217\u8868\u8868\u5355 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)sourceAppId, (Object)sourceFormId);
                continue;
            }
            FormDetailVO res = new FormDetailVO();
            res.setFormId(sourceFormId);
            res.setAppId(sourceAppId);
            res.setFormTitle(canvas.getTitle());
            referForms.add(res);
        }
        ArrayList distinct = referForms.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FormDetailVO>(Comparator.comparing(o -> o.getAppId() + ";" + o.getFormId()))), ArrayList::new));
        return FormDesignResponse.success((Object)distinct);
    }

    @Override
    public FormDesignResponse<List<FormDetailVO>> getShowForms(String formId) {
        SettingSchemaService showFormsRes = (SettingSchemaService)SpringUtil.getBean((String)"no.code.showForms", SettingSchemaService.class);
        ShowForms showForms = (ShowForms)((Object)showFormsRes.get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)showForms))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u5c55\u793a\u8868\u5355\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u5c55\u793a\u8868\u5355\u5931\u8d25");
        }
        ArrayList<FormDetailVO> formDetailVOS = new ArrayList<FormDetailVO>();
        for (BaseId showForm : showForms.getShowForms()) {
            SysForm sysForm;
            AppContextUtil.setAppId((String)showForm.getAppId());
            FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(showForm.getFormId());
            FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
            if (HussarUtils.isEmpty((Object)((Object)canvas))) {
                ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u5173\u8054\u5217\u8868\u8868\u5355 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)showForm.getAppId(), (Object)showForm.getFormId());
                continue;
            }
            if (!((Boolean)WidgetTool.isSourceExist(showForm.getAppId(), showForm.getFormId()).getData()).booleanValue()) continue;
            FormDetailVO res = new FormDetailVO();
            res.setFormId(showForm.getFormId());
            res.setAppId(showForm.getAppId());
            res.setFormTitle(canvas.getTitle());
            try {
                sysForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(Long.parseLong(res.getFormId()))).getData();
                res.setI18nKeys(sysForm.getI18nKeys());
            }
            catch (Exception e) {
                ToolUtil.getLogger(this.getClass()).error("\u5728\u6570\u636e\u5e93\u67e5\u8be2\u8868\u5355\u5931\u8d25 formId: {}", (Object)res.getFormId());
            }
            if (HussarUtils.isEmpty((Object)res.getFormTitle())) {
                try {
                    sysForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(Long.parseLong(res.getFormId()))).getData();
                    res.setFormTitle(sysForm.getFormName());
                }
                catch (Exception e) {
                    ToolUtil.getLogger(this.getClass()).error("\u5728\u6570\u636e\u5e93\u67e5\u8be2\u8868\u5355\u540d\u79f0\u5931\u8d25 formId: {}", (Object)res.getFormId());
                }
            }
            formDetailVOS.add(res);
        }
        return FormDesignResponse.success(formDetailVOS);
    }

    @Override
    public FormDesignResponse<Boolean> saveShowForms(List<BaseId> showForms, String formId) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.showForms", SettingSchemaService.class);
        ShowForms forms = new ShowForms();
        forms.setShowForms(showForms);
        FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(forms, formId);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u5c55\u793a\u8868\u5355\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u5c55\u793a\u8868\u5355\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<HideRuleSchema> getHideRule(String formId) {
        SettingSchemaService hideRuleService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.hideRule", SettingSchemaService.class);
        HideRuleSchema hideRule = (HideRuleSchema)hideRuleService.get(formId).getData();
        if (HussarUtils.isEmpty((Object)hideRule)) {
            return FormDesignResponse.success(null);
        }
        return FormDesignResponse.success((Object)hideRule);
    }

    @Override
    public FormDesignResponse<Boolean> saveSpecialField(String formId, List<RuleField> specialFields, Integer hideValueType) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.hideRule", SettingSchemaService.class);
        FormDesignResponse response = settingSchemaService.get(formId);
        HideRuleSchema hideRule = new HideRuleSchema();
        if (HussarUtils.isNotEmpty(response)) {
            HussarUtils.copy((Object)response.getData(), (Object)hideRule);
        }
        hideRule.setHideValueType(hideValueType);
        hideRule.setSpecialFields(specialFields);
        FormDesignResponse<Boolean> updateHideRule = settingSchemaService.saveOrUpdate(hideRule, formId);
        if (!((Boolean)updateHideRule.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u663e\u9690\u89c4\u5219\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u663e\u9690\u89c4\u5219\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveRule(String formId, RuleSchema rule) throws Exception {
        List rules;
        List collect;
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.hideRule", SettingSchemaService.class);
        HideRuleSchema hideRule = (HideRuleSchema)settingSchemaService.get(formId).getData();
        if (HussarUtils.isEmpty((Object)hideRule)) {
            hideRule = new HideRuleSchema();
        }
        if (HussarUtils.isEmpty((Object)hideRule.getRules())) {
            ArrayList newRules = new ArrayList();
            hideRule.setRules(newRules);
        }
        if (HussarUtils.isNotEmpty(collect = (rules = hideRule.getRules()).stream().filter(ruleSchema -> HussarUtils.equals((Object)ruleSchema.getId(), (Object)rule.getId())).collect(Collectors.toList()))) {
            rules.removeAll(collect);
        }
        rules.add(rule);
        FormDesignResponse<Boolean> saved = settingSchemaService.saveOrUpdate(hideRule, formId);
        if (!((Boolean)saved.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u663e\u9690\u89c4\u5219\u8bbe\u7f6e ==> \u4fdd\u5b58\u89c4\u5219\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u663e\u9690\u89c4\u5219\u8bbe\u7f6e ==> \u4fdd\u5b58\u89c4\u5219\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> copyRule(String formId, String ruleId, String cloneRuleId) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.hideRule", SettingSchemaService.class);
        HideRuleSchema hideRule = (HideRuleSchema)settingSchemaService.get(formId).getData();
        RuleSchema cloneRule = new RuleSchema();
        for (RuleSchema rule : hideRule.getRules()) {
            if (!HussarUtils.equals((Object)rule.getId(), (Object)ruleId)) continue;
            HussarUtils.copy((Object)rule, (Object)cloneRule);
            cloneRule.setId(cloneRuleId);
        }
        hideRule.getRules().add(cloneRule);
        FormDesignResponse<Boolean> saved = settingSchemaService.saveOrUpdate(hideRule, formId);
        if (!((Boolean)saved.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u663e\u9690\u89c4\u5219\u8bbe\u7f6e ==> \u4fdd\u5b58\u89c4\u5219\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u663e\u9690\u89c4\u5219\u8bbe\u7f6e ==> \u4fdd\u5b58\u89c4\u5219\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> deleteRule(String formId, String ruleId) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.hideRule", SettingSchemaService.class);
        HideRuleSchema hideRule = (HideRuleSchema)settingSchemaService.get(formId).getData();
        List collect = hideRule.getRules().stream().filter(rule -> HussarUtils.equals((Object)rule.getId(), (Object)ruleId)).collect(Collectors.toList());
        hideRule.getRules().removeAll(collect);
        FormDesignResponse<Boolean> saved = settingSchemaService.saveOrUpdate(hideRule, formId);
        if (!((Boolean)saved.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u663e\u9690\u89c4\u5219\u8bbe\u7f6e ==> \u4fdd\u5b58\u89c4\u5219\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u663e\u9690\u89c4\u5219\u8bbe\u7f6e ==> \u4fdd\u5b58\u89c4\u5219\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<TitleSummarySchema> getTitleSummary(String formId) {
        TitleSummarySchema titleSummarySchema = new TitleSummarySchema();
        FormDesignResponse<TitleSchema> titleSchemaResponse = this.getTitle(formId);
        FormDesignResponse<List<String>> summarySchemaResponse = this.getSummary(formId);
        titleSummarySchema.setTitle((TitleSchema)((Object)titleSchemaResponse.getData()));
        titleSummarySchema.setSummary((List)summarySchemaResponse.getData());
        return FormDesignResponse.success((Object)titleSummarySchema);
    }

    @Override
    @HussarTransactional
    public FormDesignResponse<Boolean> saveTitleSummary(TitleSummarySchema titleSummarySchema, String formId) throws Exception {
        this.saveTitle(titleSummarySchema.getTitle(), formId);
        this.saveSummary(titleSummarySchema.getSummary(), formId);
        return FormDesignResponse.success((Object)true);
    }
}

