/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormConvertHistoryService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FormDetailVO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.no.code.business.dao.BusinessTableDdlMapper;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormSecurityLevelService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.WidgetsGetDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.flow.FlowFormVO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class FormOperateImpl
implements FormOperateService {
    private final Logger LOGGER = LoggerFactory.getLogger(FormOperateImpl.class);
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ViewService viewService;
    @Resource
    private ISysApplicationExternalService externalService;
    @Resource
    private BusinessTableDdlMapper businessTableDdlMapper;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private ISysFormConvertHistoryService sysFormConvertHistoryService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private FormSecurityLevelService formSecurityLevelService;

    @Override
    public void publishWithDataModel(String formId, DataModelBase dataModelBase) throws Exception {
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        noCodeModelHandler.sync(dataModelBase);
        noCodeModelHandler.generate(dataModelBase);
    }

    @Override
    public void publish(String formId) throws Exception {
        FormDesignResponse<FormSchema> form = this.get(formId);
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)form.getData());
        DataModelBase dataModelBase = builder.direct();
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        noCodeModelHandler.sync(dataModelBase);
        noCodeModelHandler.generate(dataModelBase);
    }

    @Override
    public void delete(String formId) throws Exception {
        FormDesignResponse<FormSchema> form = this.get(formId);
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)form.getData());
        DataModelBase dataModelBase = builder.direct();
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        noCodeModelHandler.delete(dataModelBase);
    }

    @Override
    public FormDesignResponse<FormSchema> get(String formId) throws JsonProcessingException {
        FormSchema.Builder builder = new FormSchema.Builder();
        builder.formPage((FormCanvasSchema)((Object)this.canvasService.get(formId).getData())).setting((FormSettingSchema)((Object)((SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class)).get(formId).getData())).view((FormViewSchema)this.viewService.get(formId).getData()).build();
        return FormDesignResponse.success((Object)builder.build());
    }

    @Override
    public FormDesignResponse<List<WidgetField>> widgetsForFlow(String formId, boolean isFlow) {
        ArrayList<Widget> widgetListAll;
        FormDesignResponse<FormCanvasSchema> formCanvasSchema = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)formCanvasSchema.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        }
        List<Widget> widgets = canvas.widgetsContainChildren();
        if (HussarUtils.isNotEmpty(widgets) && HussarUtils.isNotEmpty(widgetListAll = new ArrayList<Widget>(widgets))) {
            this.sortField(widgets, widgetListAll);
        }
        ArrayList<WidgetField> widgetFields = new ArrayList<WidgetField>();
        WidgetTool.ofWidgetFields(widgetFields, widgets, widget -> false);
        return FormDesignResponse.success(widgetFields);
    }

    private void sortField(List<Widget> fieldControls, List<Widget> widgetsOrdered) {
        for (Widget fieldControl : fieldControls) {
            if (!HussarUtils.isNotEmpty(fieldControl.getChildren()) || !WidgetTool.anyMatch(fieldControl.getType(), WidgetType.CHILDREN_TABLE.getType(), WidgetType.JXDNChildrenTableAgg.getType())) continue;
            List<Widget> widgetChild = widgetsOrdered.stream().filter(widget -> fieldControl.getName().equals(widget.getName())).findFirst().get().getChildren();
            this.sortField(fieldControl.getChildren(), widgetChild);
        }
        List orders = widgetsOrdered.stream().sorted(Comparator.comparingInt(Widget::getSeq)).map(Widget::getName).collect(Collectors.toList());
        fieldControls.sort((o1, o2) -> {
            int io1 = orders.indexOf(o1.getName());
            int io2 = orders.indexOf(o2.getName());
            if (io1 == -1 && io2 == -1) {
                return 0;
            }
            if (io1 == -1 || io2 == -1) {
                return io1 == -1 ? 1 : -1;
            }
            return Integer.compare(io1, io2);
        });
    }

    @Override
    public FormDesignResponse<List<WidgetField>> widgetsForAuth(String formId) {
        FormDesignResponse<FormCanvasSchema> formCanvasSchema = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)formCanvasSchema.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        }
        List<Widget> widgets = canvas.widgetsWithSys();
        widgets.addAll(canvas.childTables());
        ArrayList<WidgetField> widgetFields = new ArrayList<WidgetField>();
        WidgetTool.ofWidgetFields(widgetFields, widgets, widget -> WidgetTool.anyMatch(widget.getName(), "post", "dataOrgan", "postName", "staff"));
        return FormDesignResponse.success(widgetFields);
    }

    @Override
    public FormDesignResponse<List<WidgetField>> widgetsForSetting(String appId, String formId, boolean children) {
        if (HussarUtils.isEmpty((Object)appId)) {
            SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
            appId = Long.toString(form.getAppId());
        }
        AppContextUtil.setAppId((String)appId);
        if (!((Boolean)WidgetTool.isSourceExist(appId, formId).getData()).booleanValue()) {
            return FormDesignResponse.success(new ArrayList());
        }
        FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u7528\u6237\u53ef\u9009\u7684\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((int)LcdpExceptionEnum.FORM_NOT_FOUND.getCode(), null, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        }
        List<Widget> widgets = canvas.widgetsWithSys();
        if (children) {
            widgets.addAll(canvas.childTables());
        }
        ArrayList<WidgetField> widgetFields = new ArrayList<WidgetField>();
        WidgetTool.ofWidgetFields(widgetFields, widgets, widget -> WidgetTool.anyMatch(widget.getType(), WidgetType.JXDNRichText.getType(), WidgetType.IMAGE.getType(), WidgetType.FILE.getType()) || WidgetTool.anyMatch(widget.getName(), "post", "dataOrgan", "staff", "postName"));
        return FormDesignResponse.success(widgetFields);
    }

    @Override
    public FormDesignResponse<List<FormDetailVO>> widgetsBatch(List<WidgetsGetDTO> widgetsGetDTO) {
        if (HussarUtils.isEmpty(widgetsGetDTO)) {
            return FormDesignResponse.success(null);
        }
        ArrayList<FormDetailVO> getRes = new ArrayList<FormDetailVO>();
        for (WidgetsGetDTO getDTO : widgetsGetDTO) {
            SysApplicationVo app = this.externalService.getAppDetailById(Long.valueOf(getDTO.getAppId()));
            if (HussarUtils.isEmpty((Object)app) || HussarUtils.equals((Object)"0", (Object)app.getReleaseStatus())) continue;
            AppContextUtil.setAppId((String)getDTO.getAppId());
            for (String formId : getDTO.getChildren()) {
                SysForm form = this.externalService.getFormDetailById(Long.valueOf(formId));
                if (HussarUtils.isEmpty((Object)form)) continue;
                FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(formId);
                FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
                if (HussarUtils.isEmpty((Object)((Object)canvas))) {
                    ToolUtil.getLogger(this.getClass()).error("\u5173\u8054\u8868\u5355\u6821\u9a8c\uff0c\u6279\u91cf\u83b7\u53d6\u8868\u5355 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)getDTO.getAppId(), (Object)formId);
                    return FormDesignResponse.fail((int)LcdpExceptionEnum.FORM_NOT_FOUND.getCode(), null, (String)"\u5173\u8054\u8868\u5355\u6821\u9a8c\uff0c\u6279\u91cf\u83b7\u53d6\u8868\u5355 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
                }
                List<Widget> widgets = canvas.widgetsWithSys();
                widgets.addAll(canvas.childTables());
                ArrayList<WidgetField> widgetFields = new ArrayList<WidgetField>();
                WidgetTool.ofWidgetFields(widgetFields, widgets, widget -> WidgetTool.anyMatch(widget.getType(), WidgetType.IMAGE.getType(), WidgetType.FILE.getType()) || WidgetTool.anyMatch(widget.getName(), "createUser_user", "updateUser_user", "post", "dataOrgan", "staff", "postName") || !widget.getIsRealField());
                FormDetailVO formDetailVO = new FormDetailVO();
                formDetailVO.setAppId(getDTO.getAppId());
                formDetailVO.setFormId(formId);
                formDetailVO.setFormTitle(canvas.getTitle());
                formDetailVO.setFields(widgetFields);
                getRes.add(formDetailVO);
            }
        }
        return FormDesignResponse.success(getRes);
    }

    @Override
    public FormDesignResponse<FlowFormVO> info(String formId) throws Exception {
        SysForm form = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        if (HussarUtils.isEmpty((Object)form)) {
            return FormDesignResponse.fail(null, (String)"\u8868\u5355\u672a\u627e\u5230");
        }
        FormSchema.Builder builder = new FormSchema.Builder();
        FormSchema formSchema = builder.formPage((FormCanvasSchema)((Object)this.canvasService.get(formId, form).getData())).build();
        FormCanvasSchema canvas = formSchema.getFormCanvas();
        if (HussarUtils.isEmpty((Object)((Object)canvas)) || HussarUtils.isEmpty((Object)canvas.getId())) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((int)LcdpExceptionEnum.FORM_NOT_FOUND.getCode(), null, (String)LcdpExceptionEnum.FORM_NOT_FOUND.getMessage());
        }
        FlowFormVO formVO = new FlowFormVO();
        if ("1".equals(canvas.getFormType())) {
            DataModelBuilder dataModelBuilder = ModelBuilderAdapter.adaptBuilder(formSchema);
            dataModelBuilder.direct();
            FlowFormVO flowFormVO = dataModelBuilder.getFlowFormVO();
            BeanUtils.copyProperties((Object)((Object)flowFormVO), (Object)((Object)formVO));
        }
        BeanUtils.copyProperties((Object)((Object)canvas), (Object)((Object)formVO));
        int convertCount = this.sysFormConvertHistoryService.getConvertCount(Long.valueOf(canvas.getId()));
        formVO.setConvertVersion(convertCount);
        if (HussarUtils.isNotEmpty((Object)form)) {
            formVO.setTitle(form.getFormName());
        }
        return FormDesignResponse.success((Object)((Object)formVO));
    }

    @Override
    public FormDesignResponse<List<WidgetField>> moreWidgetsForSetting(String formId, boolean children) {
        Boolean isOpen;
        FormDesignResponse<FormCanvasSchema> canvasResponse;
        try {
            canvasResponse = this.canvasSchemaService.get(formId);
        }
        catch (Exception e) {
            return FormDesignResponse.fail((int)LcdpExceptionEnum.FORM_NOT_FOUND.getCode(), null, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        }
        FormViewSchema formView = (FormViewSchema)this.viewService.get(formId).getData();
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u7528\u6237\u53ef\u9009\u7684\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((int)LcdpExceptionEnum.FORM_NOT_FOUND.getCode(), null, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        }
        List<Widget> widgets = canvas.widgetsWithSys();
        if (HussarUtils.equals((Object)formView.getFormType(), (Object)"1")) {
            List<Widget> processState = PageBuilderFactory.getProcessInfoWidgets();
            widgets.addAll(processState);
        }
        if (children) {
            widgets.addAll(canvas.childTables());
        }
        if (!(isOpen = Boolean.valueOf(this.formSecurityLevelService.getSecurityLevelSwitch(formId))).booleanValue()) {
            widgets = widgets.stream().filter(item -> !WidgetType.JXDNSecurityLevel.getType().equals(item.getType())).collect(Collectors.toList());
        }
        ArrayList<WidgetField> widgetFields = new ArrayList<WidgetField>();
        WidgetTool.ofWidgetFieldsWithSecurity(widgetFields, widgets, widget -> WidgetTool.anyMatch(widget.getName(), "post", "staff", "postName", "PROCESS_INST_ID", "PROCESS_KEY"), isOpen);
        return FormDesignResponse.success(widgetFields);
    }

    @Override
    @HussarTransactional
    @HussarDs(value="#businessDB")
    public ApiResponse<String> modifyBusinessTablePrimaryKey(SysForm sysForm, String businessDB) {
        this.businessTableDdlMapper.setNewPrimaryColumnValue(sysForm.getTableName().toUpperCase(), "RECORD_ID");
        this.businessTableDdlMapper.updateTableNameColumnValue(sysForm.getTableName().toUpperCase(), "RECORD_ID");
        this.businessTableDdlMapper.dropOldPrimaryKeyAndAddNewPrimaryKeyIndex(sysForm.getTableName().toUpperCase(), "RECORD_ID");
        this.businessTableDdlMapper.setOldPrimaryColumnValueNullable(sysForm.getTableName().toUpperCase());
        return ApiResponse.success((String)"Ok.");
    }

    @Override
    @HussarTransactional
    @HussarDs(value="#businessDB")
    public ApiResponse<String> modifySubBusinessTablePrimaryKey(String subTableName, String mainTableName, String businessDB) {
        this.businessTableDdlMapper.setSubTableNewPrimaryColumnValue(subTableName, mainTableName);
        this.businessTableDdlMapper.updateSubTableNameColumnValue(subTableName, mainTableName);
        try {
            this.businessTableDdlMapper.setSubForginKeyColumnValue(subTableName, mainTableName);
            this.businessTableDdlMapper.updateSubTableMainTableNameColumnValue(subTableName, mainTableName);
        }
        catch (Exception e) {
            this.LOGGER.info("\u66f4\u65b0\u5b50\u8868\u5931\u8d25\uff0c{}", (Object)e.toString());
        }
        this.businessTableDdlMapper.dropSubOldPrimaryKeyAndAddNewPrimaryKeyIndex(subTableName);
        this.businessTableDdlMapper.setOldPrimaryColumnValueNullable(subTableName);
        return ApiResponse.success((String)"Ok.");
    }

    @Override
    @HussarDs(value="#businessDB")
    public int queryFlowDataCountInNormalForm(String tableName, List<String> processKeys, String businessDB) {
        return this.businessTableDdlMapper.queryFlowDataCountInNormalForm(tableName.toUpperCase(), processKeys);
    }

    @Override
    @HussarDs(value="#businessDB")
    public int queryFlowDataCount(String tableName, String processKey, String businessDB) {
        return this.businessTableDdlMapper.queryFlowDataCount(tableName.toUpperCase(), processKey);
    }
}

