/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSONPath;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleConfigDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeSaveDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeUpdateDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.no.code.constant.Path;
import com.jxdinfo.hussar.formdesign.no.code.constant.PostgreSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.mysql.cj.MysqlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNSerialNumber")
public class JXDNSerialNumber
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    @Resource
    private ISysCodeRuleService iSysCodeRuleService;
    @Resource
    private ISysFormService sysFormService;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleType.CLOB.name());
            this.put(DbType.POSTGRE_SQL.name(), PostgreSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), PostgreSqlTypeEnum.TEXT.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType) {
        String name = this.widget.getName();
        String title = WidgetTool.concatTitle(this.widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        this.widget.setUsage("serialNumber");
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType) {
        return this.withField(dbType).get(0);
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("inputMode", JsonParser.value(this.widget, Path.Widgets.INPUT_MODE.getPath(), String.class).orElse("text"));
    }

    public void saveCodeRule() {
        String ruleCode = this.form.getFormCanvas().getName();
        String title = this.form.getFormCanvas().getTitle();
        SysCodeRuleDto sysCodeRuleDto = new SysCodeRuleDto();
        sysCodeRuleDto.setRuleCode(ruleCode);
        sysCodeRuleDto.setPageNo(Integer.valueOf(1));
        sysCodeRuleDto.setPageSize(Integer.valueOf(10));
        ISysCodeRuleService iSysCodeRuleService = (ISysCodeRuleService)SpringUtil.getBean(ISysCodeRuleService.class);
        ApiResponse pageApiResponse = iSysCodeRuleService.listCodeRules(sysCodeRuleDto);
        List records = ((Page)pageApiResponse.getData()).getRecords();
        Optional<List<SerialNumRuleDTO>> codeRulesOpt = JsonParser.array(this.widget, "$.props.rules", SerialNumRuleDTO.class);
        ArrayList<SysCodeRuleConfigDto> sysCodeSaveDTOs = new ArrayList<SysCodeRuleConfigDto>();
        if (!codeRulesOpt.isPresent()) {
            return;
        }
        List<SerialNumRuleDTO> serialNumRuleDTOS = codeRulesOpt.get();
        for (SerialNumRuleDTO codeRule : serialNumRuleDTOS) {
            SysCodeRuleConfigDto sysCodeRuleInfo = new SysCodeRuleConfigDto();
            String type = codeRule.getType();
            sysCodeRuleInfo.setElementType(type);
            Long id = codeRule.getConfig().getId();
            if (HussarUtils.isEmpty((Object)id)) {
                id = IdWorker.getId((Object)sysCodeRuleInfo);
                codeRule.getConfig().setId(id);
            }
            sysCodeRuleInfo.setCodeRuleInfoId(id);
            if (HussarUtils.equals((Object)type, (Object)"serialNumber")) {
                sysCodeRuleInfo.setElementPattern("1");
                sysCodeRuleInfo.setSerialNumberLength(codeRule.getConfig().getCountLength());
                sysCodeRuleInfo.setSerialNumberStart(codeRule.getConfig().getInitialVal());
                sysCodeRuleInfo.setResetPeriod(codeRule.getConfig().getResetType());
            }
            if (HussarUtils.equals((Object)type, (Object)"constant") || HussarUtils.equals((Object)type, (Object)"codeDateTime")) {
                sysCodeRuleInfo.setElementPattern(codeRule.getConfig().getValue());
            }
            if (HussarUtils.equals((Object)type, (Object)"field")) {
                sysCodeRuleInfo.setElementType("variable");
                sysCodeRuleInfo.setElementPattern(codeRule.getName());
            }
            sysCodeSaveDTOs.add(sysCodeRuleInfo);
        }
        JSONPath.set((Object)this.widget, (String)"$.props.rules", serialNumRuleDTOS);
        Long appId = ((SysForm)this.sysFormService.getById((Serializable)((Object)this.form.getFormCanvas().getId()))).getAppId();
        if (HussarUtils.isNotEmpty((Object)records)) {
            SysCodeUpdateDto sysCodeUpdateDto = new SysCodeUpdateDto();
            SysCodeRuleVo sysCodeRuleVo = (SysCodeRuleVo)((Page)pageApiResponse.getData()).getRecords().get(0);
            Long codeRuleId = sysCodeRuleVo.getCodeRuleId();
            sysCodeUpdateDto.setCodeRuleId(codeRuleId);
            sysCodeUpdateDto.setCodeRuleCode(ruleCode);
            sysCodeUpdateDto.setCodeRuleName(title);
            sysCodeUpdateDto.setCodeRuleDesc(title);
            sysCodeUpdateDto.setSys("0");
            sysCodeUpdateDto.setLevel("0");
            sysCodeUpdateDto.setAppId(appId);
            sysCodeUpdateDto.setSysCodeRuleConfigList(sysCodeSaveDTOs);
            iSysCodeRuleService.updateCodeRule(sysCodeUpdateDto);
        } else {
            SysCodeSaveDto sysCodeSaveDto = new SysCodeSaveDto();
            sysCodeSaveDto.setCodeRuleName(title);
            sysCodeSaveDto.setCodeRuleCode(ruleCode);
            sysCodeSaveDto.setCodeRuleDesc(title);
            sysCodeSaveDto.setSys("0");
            sysCodeSaveDto.setLevel("0");
            sysCodeSaveDto.setSysCodeRuleConfigList(sysCodeSaveDTOs);
            sysCodeSaveDto.setAppId(appId);
            iSysCodeRuleService.saveCodeRule(sysCodeSaveDto);
        }
    }
}

