/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.PostgreSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNFile")
public class JXDNFile
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleType.CLOB.name());
            this.put(DbType.POSTGRE_SQL.name(), PostgreSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), PostgreSqlTypeEnum.TEXT.getTypeName());
        }
    };
    private Map<String, String> labelDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleType.CLOB.name());
            this.put(DbType.POSTGRE_SQL.name(), PostgreSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), PostgreSqlTypeEnum.TEXT.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType) {
        String name = this.widget.getName();
        String title = WidgetTool.concatTitle(this.widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.labelDbType.get(dbType)).build());
        fields.add(this.getLabelField(dbType));
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType) {
        String name = this.widget.getName();
        String title = this.widget.getTitle();
        return new DataModelFieldBase.Builder().withId(name + "_label").withName(name + "_label").withComment(title + "-\u663e\u793a\u503c").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.labelDbType.get(dbType)).build();
    }

    public String parseFileId(String fieldName, Object data) {
        if (HussarUtils.isEmpty((Object)data)) {
            return "";
        }
        ArrayList<String> matchStr = new ArrayList<String>();
        JSONArray formData = JSONObject.parseArray((String)JSONObject.toJSONString((Object)data));
        for (Object formDatum : formData) {
            JSONObject form = JSONObject.parseObject((String)JSONObject.toJSONString(formDatum));
            Object val = form.get((Object)fieldName);
            if (HussarUtils.isEmpty((Object)val)) continue;
            matchStr.add(String.valueOf(val));
        }
        return String.join((CharSequence)",", matchStr);
    }
}

