/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.PostgreSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNAddress")
public class JXDNAddress
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.VARCHAR.name());
            this.put("ORACLE", OracleType.VARCHAR2.name());
            this.put(DbType.POSTGRE_SQL.name(), PostgreSqlTypeEnum.VARCHAR.getTypeName());
            this.put(DbType.GAUSS.name(), PostgreSqlTypeEnum.VARCHAR.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType) {
        String name = this.widget.getName();
        String title = WidgetTool.concatTitle(this.widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name + "_code").withName(name + "_code").withComment(title + "-\u7701\u5e02\u533a\u7f16\u7801").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(20).build());
        fields.add(new DataModelFieldBase.Builder().withId(name + "_detailed").withName(name + "_detailed").withComment(title + "\u8be6\u7ec6").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(255).build());
        fields.add(this.getLabelField(dbType));
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType) {
        String name = this.widget.getName();
        String title = this.widget.getTitle();
        return new DataModelFieldBase.Builder().withId(name + "_name").withName(name + "_label").withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(255).build();
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("derived", String.format("%s%s,%s%s", this.widget.getName(), "_label", this.widget.getName(), "_detailed"));
    }
}

