/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.HideRuleSchema;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.storage.SettingStorageImpl;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="no.code.hideRule")
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class HideRuleStorageImpl
implements SettingSchemaService<HideRuleSchema> {
    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(HideRuleSchema hideRule, String formId) throws Exception {
        SettingSchemaService settingService = (SettingSchemaService)SpringUtil.getBean(SettingStorageImpl.class);
        FormDesignResponse response = settingService.get(formId);
        FormSettingSchema responseSetting = (FormSettingSchema)((Object)response.getData());
        if (HussarUtils.isEmpty((Object)((Object)responseSetting))) {
            FormSettingSchema newSetting = new FormSettingSchema();
            newSetting.setHideRuleSchema(hideRule);
            FormDesignResponse<Boolean> saved = settingService.saveOrUpdate(newSetting, formId);
            if (((Boolean)saved.getData()).booleanValue()) {
                return FormDesignResponse.success((Object)saved.getData());
            }
        }
        responseSetting.setHideRuleSchema(hideRule);
        FormDesignResponse<Boolean> saved = settingService.saveOrUpdate(responseSetting, formId);
        if (((Boolean)saved.getData()).booleanValue()) {
            return FormDesignResponse.success((Object)saved.getData());
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u4fdd\u5b58\u663e\u9690\u89c4\u5219\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)saved.getData(), (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u4fdd\u5b58\u663e\u9690\u89c4\u5219\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<HideRuleSchema> get(String formId) {
        FormSettingSchema setting = (FormSettingSchema)((Object)((SettingStorageImpl)SpringUtil.getBean(SettingStorageImpl.class)).get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)setting))) {
            return FormDesignResponse.success(null, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u8868\u5355id\u7684\u8868\u5355\u8bbe\u7f6e->\u663e\u9690\u89c4\u5219");
        }
        return FormDesignResponse.success((Object)setting.getHideRuleSchema());
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        return null;
    }
}

