/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.TableButton;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CanvasServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CustomViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarTokenDs
public class ViewServiceImpl
implements ViewService {
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private CustomViewServiceImpl customViewService;
    private static Logger logger = LoggerFactory.getLogger(ViewServiceImpl.class);

    @Override
    @Transactional
    public FormDesignResponse<Boolean> save(FormViewSchema formViewSchema) throws Exception {
        FormDesignResponse<Boolean> updateForm = this.viewSchemaService.saveOrUpdate(formViewSchema);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formViewSchema.getFormId());
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25");
        }
        this.formOperateService.publish(formViewSchema.getFormId());
        return FormDesignResponse.success((Object)true);
    }

    @Override
    @Transactional
    public FormDesignResponse<Boolean> saveWithPublic(FormViewSchema formViewSchema) throws Exception {
        List<DataView> views = formViewSchema.getViews();
        ArrayList<DataView> publicViews = new ArrayList<DataView>();
        ArrayList<DataView> sysViews = new ArrayList<DataView>();
        ArrayList<String> order = new ArrayList<String>();
        for (DataView view : views) {
            order.add(view.getName());
            if (HussarUtils.equals((Object)view.getCategory(), (Object)"sys")) {
                sysViews.add(view);
                continue;
            }
            publicViews.add(view);
        }
        formViewSchema.setViewOrder(order);
        List dataViews = (List)this.customViewService.get(formViewSchema.getFormId()).getData();
        if (HussarUtils.isNotEmpty((Object)dataViews)) {
            List oldPublicView = dataViews.stream().filter(v -> HussarUtils.equals((Object)v.getCategory(), (Object)"public")).collect(Collectors.toList());
            ArrayList<String> delIds = new ArrayList<String>();
            for (DataView oldView : oldPublicView) {
                if (!publicViews.stream().noneMatch(x -> HussarUtils.equals((Object)x.getId(), (Object)oldView.getId()))) continue;
                delIds.add(oldView.getId());
            }
            if (HussarUtils.isNotEmpty(delIds)) {
                this.customViewService.removeByIds(delIds);
            }
        }
        if (HussarUtils.isNotEmpty(publicViews)) {
            this.customViewService.updateBatch(formViewSchema.getFormId(), publicViews);
        }
        formViewSchema.setViews(sysViews);
        FormDesignResponse<Boolean> updateForm = this.viewSchemaService.saveOrUpdate(formViewSchema);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formViewSchema.getFormId());
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u4fdd\u5b58\u5931\u8d25");
        }
        this.formOperateService.publish(formViewSchema.getFormId());
        return FormDesignResponse.success((Object)true);
    }

    @Override
    @HussarDs(value="master")
    public FormDesignResponse<FormViewSchema> get(String formId) {
        FormViewSchema view = (FormViewSchema)this.viewSchemaService.get(formId).getData();
        if (HussarUtils.isEmpty((Object)view)) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25");
        }
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)formCanvasSchema))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        List<Widget> widgetsWithSys = formCanvasSchema.widgetsWithSys();
        if ("1".equals(formCanvasSchema.getFormType())) {
            ViewServiceImpl.addFlow(widgetsWithSys);
        }
        List<Widget> childedTables = formCanvasSchema.childTables();
        widgetsWithSys.addAll(childedTables);
        widgetsWithSys = WidgetTool.settingWidgets(widgetsWithSys, widget -> WidgetTool.anyMatch(widget.getName(), "post", "dataOrgan", "staff", "PROCESS_INST_ID", "TASK_ID", "TASK_DEF_KEY"));
        view.setColumns(widgetsWithSys);
        this.updateShowFieldsNew(formCanvasSchema, view);
        FormViewSchema newView = this.contrastTemplateView(view);
        return FormDesignResponse.success((Object)view);
    }

    public static void addFlow(List<Widget> widgets) {
        List processWidget = JSON.parseArray((String)ToolUtil.loadResource(CanvasServiceImpl.class, (String)"/process_info_widgets.json"), Widget.class);
        List processTaskWidget = JSON.parseArray((String)ToolUtil.loadResource(CanvasServiceImpl.class, (String)"/process_task_info_widgets.json"), Widget.class);
        widgets.addAll(processWidget);
        widgets.addAll(processTaskWidget);
    }

    @Override
    public FormDesignResponse<FormViewSchema> getWithPublic(String formId) {
        FormViewSchema view = (FormViewSchema)this.viewSchemaService.get(formId).getData();
        if (HussarUtils.isEmpty((Object)view)) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25");
        }
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)formCanvasSchema))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        List<Widget> widgetsWithSys = formCanvasSchema.widgetsWithSys();
        if ("1".equals(formCanvasSchema.getFormType())) {
            ViewServiceImpl.addFlow(widgetsWithSys);
        }
        List<Widget> childedTables = formCanvasSchema.childTables();
        widgetsWithSys.addAll(childedTables);
        widgetsWithSys = WidgetTool.settingWidgets(widgetsWithSys, widget -> WidgetTool.anyMatch(widget.getName(), "post", "dataOrgan", "staff", "PROCESS_INST_ID", "TASK_ID", "TASK_DEF_KEY"));
        view.setColumns(widgetsWithSys);
        this.updateShowFieldsNew(formCanvasSchema, view);
        List customViews = (List)this.customViewService.get(formId).getData();
        ArrayList<Object> allViews = new ArrayList<Object>();
        ArrayList<DataView> result = new ArrayList<DataView>();
        if (HussarUtils.isNotEmpty((Object)customViews)) {
            for (Object customView : customViews) {
                if (!HussarUtils.equals((Object)customView.getCategory(), (Object)"public")) continue;
                allViews.add(customView);
            }
        }
        allViews.addAll(view.getViews());
        List<String> viewOrder = view.getViewOrder();
        if (HussarUtils.isNotEmpty(viewOrder)) {
            for (String id : viewOrder) {
                Optional<DataView> first = allViews.stream().filter(v -> HussarUtils.equals((Object)v.getName(), (Object)id)).findFirst();
                if (!first.isPresent()) continue;
                result.add(first.get());
            }
        }
        result = HussarUtils.isEmpty(result) ? allViews : result;
        view.setViews(result);
        FormViewSchema newView = this.contrastTemplateView(view);
        return FormDesignResponse.success((Object)view);
    }

    private FormViewSchema contrastTemplateView(FormViewSchema view) {
        DataView baseView;
        FormViewSchema viewSchema = new FormViewSchema();
        if ("0".equals(view.getFormType())) {
            viewSchema = (FormViewSchema)JSON.parseObject((String)ToolUtil.loadResource(this.getClass(), (String)"/default_view_schema.json"), FormViewSchema.class);
            baseView = viewSchema.getViews().stream().filter(v -> "joiopt0oou9plqj559byloyqdj0dk31i".equals(v.getId())).findFirst().orElseThrow(() -> new HussarException("\u666e\u901a\u8868\u5355\u6a21\u677f\u89c6\u56fe\u4e0d\u5b58\u5728"));
        } else if ("1".equals(view.getFormType())) {
            viewSchema = (FormViewSchema)JSON.parseObject((String)ToolUtil.loadResource(this.getClass(), (String)"/default_flow_view_schema.json"), FormViewSchema.class);
            baseView = viewSchema.getViews().stream().filter(v -> "e33a41s5fcl06btfvdc0qnbvqt9wd1h4".equals(v.getId())).findFirst().orElseThrow(() -> new HussarException("\u6d41\u7a0b\u8868\u5355\u6a21\u677f\u89c6\u56fe\u4e0d\u5b58\u5728"));
        } else {
            baseView = null;
        }
        if (HussarUtils.isEmpty((Object)viewSchema)) {
            return view;
        }
        List<DataView> templateViews = viewSchema.getViews();
        List<DataView> dataViews = view.getViews();
        for (DataView dataView : dataViews) {
            Optional<DataView> first = templateViews.stream().filter(v -> HussarUtils.equals((Object)v.getId(), (Object)dataView.getId())).findFirst();
            DataView target = first.orElseGet(() -> {
                if ("public".equals(dataView.getCategory())) {
                    return baseView;
                }
                return null;
            });
            if (HussarUtils.isEmpty((Object)target)) continue;
            ArrayList<TableButton> newButtons = new ArrayList<TableButton>();
            for (TableButton button2 : target.getButtons()) {
                List buttons = dataView.getButtons();
                if (buttons.stream().anyMatch(b -> HussarUtils.equals((Object)b.getId(), (Object)button2.getId()))) continue;
                newButtons.add(button2);
            }
            dataView.getButtons().addAll(newButtons);
            Optional<TableButton> deleteButtonOpt = dataView.getButtons().stream().filter(button -> "hjbs71mdgamipm1wqxaitdlb2rdig9na".equals(button.getId())).findFirst();
            if (!deleteButtonOpt.isPresent() || dataView.getButtons().size() <= 2) continue;
            dataView.getButtons().remove(deleteButtonOpt.get());
            dataView.getButtons().add(1, deleteButtonOpt.get());
        }
        return view;
    }

    private void updateShowFields(FormCanvasSchema canvasSchema, FormViewSchema formViewSchema) {
        List<Widget> widgets = canvasSchema.widgets();
        widgets.addAll(canvasSchema.childTables());
        if (HussarUtils.isEmpty(widgets)) {
            return;
        }
        List<Widget> showWidgets = canvasSchema.widgetsWithSys();
        showWidgets.addAll(canvasSchema.childTables());
        if ("1".equals(canvasSchema.getFormType())) {
            ViewServiceImpl.addFlow(showWidgets);
        }
        List<Widget> finalShowWidgets = showWidgets = WidgetTool.settingWidgets(showWidgets, widget -> WidgetTool.anyMatch(widget.getName(), "post", "dataOrgan", "staff", "postName", "createUserName", "updateUserName", "PROCESS_INST_ID", "TASK_ID", "TASK_DEF_KEY", "PROCESS_NODE", "FINISH_TIME", "TASK_INFO_ID", "BUSINESS_ID", "ASSIGNEE", "TASK_DEF_NAME", "TASK_STATE", "FORM_KEY", "FORM_DETAIL_KEY", "END_TIME", "CREATE_TIME", "PROCESS_KEY"));
        List<ShowField> fields = ViewServiceImpl.convertShowFields(showWidgets, widgetName -> finalShowWidgets.stream().map(Widget::getName).anyMatch(newName -> newName.equals(widgetName)));
        List fieldNames = fields.stream().map(ShowField::getName).collect(Collectors.toList());
        for (DataView view : formViewSchema.getViews()) {
            ArrayList<ShowField> sameShowFields = new ArrayList<ShowField>();
            ArrayList<ShowField> diffShowFields = new ArrayList<ShowField>(fields);
            List viewShowFields = view.getShowFields();
            for (ShowField viewShowField : viewShowFields) {
                if (!fieldNames.contains(viewShowField.getName())) continue;
                sameShowFields.add(viewShowField);
                diffShowFields.removeIf(showField -> HussarUtils.equals((Object)showField.getName(), (Object)viewShowField.getName()));
            }
            sameShowFields.addAll(sameShowFields.size() - 5, diffShowFields);
            view.setShowFields(sameShowFields);
        }
    }

    private void updateShowFieldsNew(FormCanvasSchema canvasSchema, FormViewSchema formViewSchema) {
        List<Widget> allWidgets = canvasSchema.widgets();
        allWidgets.addAll(canvasSchema.childTables());
        List<Widget> widgets = allWidgets.stream().filter(widget -> widget.getIsRealField() && !widget.isVirtualField()).collect(Collectors.toList());
        ArrayList processWidgets = new ArrayList();
        if (HussarUtils.equals((Object)"1", (Object)canvasSchema.getFormType())) {
            List processWidget = JSON.parseArray((String)ToolUtil.loadResource(CanvasServiceImpl.class, (String)"/process_info_widgets.json"), Widget.class);
            processWidgets.addAll(processWidget);
        }
        List<Widget> newProcessWidgets = processWidgets.stream().filter(r -> HussarUtils.equals((Object)r.getName(), (Object)"PROCESS_NODE")).collect(Collectors.toList());
        List<ShowField> processShowFields = ViewServiceImpl.convertShowFields(newProcessWidgets, widgetName -> newProcessWidgets.stream().map(Widget::getName).anyMatch(newName -> newName.equals(widgetName)));
        List<ShowField> nowShowFields = ViewServiceImpl.convertShowFields(widgets, widgetName -> widgets.stream().map(Widget::getName).anyMatch(newName -> newName.equals(widgetName)));
        List nowShowFieldsName = nowShowFields.stream().map(ShowField::getName).collect(Collectors.toList());
        List customViews = (List)this.customViewService.get(formViewSchema.getFormId()).getData();
        ArrayList<DataView> views = new ArrayList<DataView>();
        if (HussarUtils.isNotEmpty((Object)customViews)) {
            views.addAll(customViews.stream().filter(v -> HussarUtils.equals((Object)v.getCategory(), (Object)"public")).collect(Collectors.toList()));
        }
        views.addAll(formViewSchema.getViews());
        for (DataView view : views) {
            List oldShowFields = view.getShowFields();
            List oldShowFieldsName = view.getShowFields().stream().map(ShowField::getName).collect(Collectors.toList());
            oldShowFields = oldShowFields.stream().filter(showField -> {
                String showFieldName = showField.getName();
                if (showFieldName.contains("jxd")) {
                    return nowShowFieldsName.contains(showFieldName);
                }
                return true;
            }).collect(Collectors.toList());
            view.setShowFields(oldShowFields);
            List newShowFields = nowShowFields.stream().filter(showField -> !oldShowFieldsName.contains(showField.getName())).collect(Collectors.toList());
            boolean isNewForm = oldShowFields.stream().anyMatch(f -> HussarUtils.equals((Object)f.getName(), (Object)"PROCESS_NODE"));
            if (!isNewForm && !HussarUtils.equals((Object)view.getAlias(), (Object)"\u6211\u7684\u8349\u7a3f")) {
                newShowFields.addAll(processShowFields);
            }
            view.getShowFields().addAll(view.getShowFields().size() - 5, newShowFields);
            if (!HussarUtils.equals((Object)view.getCategory(), (Object)"public")) continue;
            this.customViewService.update(view);
        }
    }

    private static List<ShowField> convertShowFields(List<Widget> widgets, Predicate<String> predicate) {
        ArrayList<ShowField> newShowFields = new ArrayList<ShowField>();
        for (Widget widget : widgets) {
            ShowField showField = new ShowField();
            showField.setChecked(predicate.test(widget.getName()));
            showField.setName(widget.getName());
            showField.setAlign("center");
            showField.setWidth(68 + widget.getTitle().length() * 14);
            showField.setIsMinWidth(true);
            newShowFields.add(showField);
        }
        return newShowFields;
    }
}

