/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.df.data.set.api.app.service.ISysDataSetApplicationService;
import com.jxdinfo.hussar.df.data.set.api.app.vo.SysDataSetAppVo;
import com.jxdinfo.hussar.df.data.set.api.app.vo.SysDataSetGroupVo;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.api.table.service.DfTableService;
import com.jxdinfo.hussar.eai.client.sdk.api.service.EaiSyncApiSdkService;
import com.jxdinfo.hussar.eai.client.sdk.properties.EaiClientSdkProperties;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiClassifySdkDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiDetailDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiInfoSdkDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppInfoSdkDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.AppSyncSdkDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParamsItem;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppTreeExtendVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.BestMatchField;
import com.jxdinfo.hussar.formdesign.application.form.vo.FieldBriefVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FieldDetailVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormFieldGroupVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormFieldVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormGroupExtendVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.GroupShowFormField;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormDataVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FieldDataSourceService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.config.EaiCrossServiceProperties;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataTypeConvert;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="FieldDataSourceServiceImplNoCode")
public class FieldDataSourceServiceImpl
implements FieldDataSourceService {
    @Resource
    private ISysApplicationExternalService externalService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private ISysDataSetApplicationService dataSetService;
    @Resource
    private DfTableService dfTableService;
    @Resource
    private EaiSyncApiSdkService eaiSyncApiSdkService;
    @Resource
    private EaiClientSdkProperties eaiClientSdkProperties;
    @Resource
    private EaiCrossServiceProperties eaiCrossServiceProperties;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    private static Logger logger = LoggerFactory.getLogger(FieldDataSourceServiceImpl.class);
    public static final String FORM_DATA = "1";
    public static final String DATA_SET = "2";
    public static final String OUT_API = "3";

    @Override
    public FormDesignResponse<List<AppTreeExtendVo>> dataList(String type, String key) {
        switch (type) {
            case "1": {
                List sysApplicationVos = (List)this.externalService.getAppContainFormInfoList().getData();
                List<AppTreeExtendVo> appTreeExtendVos = this.convertVoOne(sysApplicationVos);
                this.filterDataList(appTreeExtendVos, key);
                return FormDesignResponse.success(appTreeExtendVos);
            }
            case "2": {
                List sysDataSetAppVos = (List)this.dataSetService.list().getData();
                List<AppTreeExtendVo> dataSetTreeVos = this.convertVoTwo(sysDataSetAppVos);
                this.filterDataList(dataSetTreeVos, key);
                return FormDesignResponse.success(dataSetTreeVos);
            }
            case "3": {
                boolean open = this.eaiCrossServiceProperties.isOpen();
                List<AppTreeExtendVo> externalApiTreeVos = null;
                if (open) {
                    List<AppTreeExtendVo> externalApiTreeVosTransfer;
                    AppSyncSdkDto appSyncSdkDto = new AppSyncSdkDto();
                    appSyncSdkDto.setClientId(this.eaiClientSdkProperties.getClientId());
                    appSyncSdkDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
                    String eaiUrl = this.eaiClientSdkProperties.getEaiUrl();
                    appSyncSdkDto.setUrl(eaiUrl);
                    List appInfoSdkDtoList = (List)this.eaiSyncApiSdkService.getAppDetailClassifyListNoParams(appSyncSdkDto).getData();
                    externalApiTreeVos = externalApiTreeVosTransfer = this.convertVoExternalApi(appInfoSdkDtoList);
                }
                this.filterDataList(externalApiTreeVos, key);
                return FormDesignResponse.success(externalApiTreeVos);
            }
        }
        return FormDesignResponse.fail(null, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7c7b\u578b\u7684\u6570\u636e\u6e90");
    }

    @Override
    public FormDesignResponse<FieldDetailVO> sourceDetail(String type, String appId, String formId, String appCode, String apiCode) throws IOException, LcdpException {
        try {
            switch (type) {
                case "1": {
                    List list = (List)this.formOperateService.moreWidgetsForSetting(formId, true).getData();
                    FieldDetailVO fieldDetailVO = new FieldDetailVO(list, "");
                    return FormDesignResponse.success((Object)fieldDetailVO);
                }
                case "2": {
                    List dataList = this.dfTableService.dataSetColumn(Long.valueOf(Long.parseLong(formId)));
                    ArrayList<WidgetField> resultList = new ArrayList<WidgetField>();
                    if (HussarUtils.isEmpty((Object)dataList)) {
                        return FormDesignResponse.success(null);
                    }
                    for (ProjectionField item : dataList) {
                        String name = item.getField();
                        String title = item.getRename();
                        String dataType = DataTypeConvert.convertJavaDataType(item.getDataType());
                        String componentType = DataTypeConvert.dataTypeConvertWidget(dataType);
                        String primary = item.getPrimarys();
                        WidgetField widgetField = new WidgetField(name, componentType, title, dataType, "false", "false", primary);
                        widgetField.setIsRealField(true);
                        widgetField.setFieldId(item.getFieldId());
                        widgetField.setTable(item.getTable());
                        widgetField.setField(item.getField());
                        widgetField.setRename(item.getRename());
                        widgetField.setFieldAlias(item.getFieldAlias());
                        resultList.add(widgetField);
                    }
                    FieldDetailVO dataSet = new FieldDetailVO(resultList, "");
                    return FormDesignResponse.success((Object)dataSet);
                }
                case "3": {
                    boolean open = this.eaiCrossServiceProperties.isOpen();
                    FieldDetailVO apiInfoVO = new FieldDetailVO();
                    if (open) {
                        ApiDetailDto apiDetailDto = new ApiDetailDto();
                        apiDetailDto.setUrl(this.eaiClientSdkProperties.getEaiUrl());
                        apiDetailDto.setClientId(this.eaiClientSdkProperties.getClientId());
                        apiDetailDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
                        apiDetailDto.setAppCode(appCode);
                        apiDetailDto.setApiCode(apiCode);
                        ApiInfoSdkDto apiInfoSdkDetail = (ApiInfoSdkDto)this.eaiSyncApiSdkService.getApiDetailByCode(apiDetailDto).getData();
                        ArrayList<WidgetField> paramsList = new ArrayList<WidgetField>();
                        List outParamsArray = apiInfoSdkDetail.getOutParams().getBody();
                        List<Object> fieldsArray = new ArrayList<EaiApiParamsItem>();
                        if (HussarUtils.isNotEmpty((Object)outParamsArray)) {
                            Optional<EaiApiParamsItem> data = outParamsArray.stream().filter(m -> HussarUtils.equals((Object)"data", (Object)m.getName())).findFirst();
                            Optional<EaiApiParamsItem> items = data.get().getItems().stream().filter(i -> HussarUtils.equals((Object)"data", (Object)i.getName())).findFirst();
                            Optional<EaiApiParamsItem> first = items.get().getItems().stream().filter(i -> HussarUtils.equals((Object)"item", (Object)i.getName()) || HussarUtils.equals((Object)"items", (Object)i.getName())).findFirst();
                            fieldsArray = first.get().getItems();
                        } else {
                            fieldsArray.add(new EaiApiParamsItem());
                        }
                        for (EaiApiParamsItem paramsItem : fieldsArray) {
                            String name = paramsItem.getName();
                            Integer itemType = paramsItem.getType();
                            String dateType = DataTypeConvert.convertApiDataType(itemType);
                            String componentType = DataTypeConvert.dataTypeConvertWidget(dateType);
                            String title = paramsItem.getMark();
                            WidgetField widgetField = new WidgetField(name, componentType, title, dateType, "false", "true", "false");
                            widgetField.setIsRealField(true);
                            paramsList.add(widgetField);
                        }
                        apiInfoVO.setList(paramsList);
                        apiInfoVO.setUri(apiInfoSdkDetail.getApiPath());
                        apiInfoVO.setAppCode(apiInfoSdkDetail.getAppCode());
                        apiInfoVO.setApiCode(apiInfoSdkDetail.getApiCode());
                    }
                    return FormDesignResponse.success((Object)apiInfoVO);
                }
            }
            logger.error("\u7c7b\u578b\u683c\u5f0f\u9519\u8bef");
        }
        catch (Exception e) {
            logger.error("sourceDetail\u83b7\u53d6\u6570\u636e\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            return FormDesignResponse.success((Object)new FieldDetailVO());
        }
        return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u6570\u636e\u8be6\u60c5\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<List<SysAppGroupVo>> appList(String type) {
        switch (type) {
            case "1": {
                List appList = this.sysApplicationService.getManageAppList(null, "", FORM_DATA);
                return FormDesignResponse.success((Object)appList);
            }
            case "3": {
                ArrayList<SysAppGroupVo> result = new ArrayList<SysAppGroupVo>();
                SysAppGroupVo sysAppGroupVo = new SysAppGroupVo();
                boolean open = this.eaiCrossServiceProperties.isOpen();
                if (open) {
                    AppSyncSdkDto appSyncSdkDto = new AppSyncSdkDto();
                    appSyncSdkDto.setClientId(this.eaiClientSdkProperties.getClientId());
                    appSyncSdkDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
                    String eaiUrl = this.eaiClientSdkProperties.getEaiUrl();
                    appSyncSdkDto.setUrl(eaiUrl);
                    List appInfoSdkDtoList = (List)this.eaiSyncApiSdkService.getAppDetailClassifyListNoParams(appSyncSdkDto).getData();
                    List<SysApplicationVo> applicationList = this.toApplicationListOfSdk(appInfoSdkDtoList);
                    sysAppGroupVo.setGroupName("\u5916\u90e8api\u5e94\u7528");
                    sysAppGroupVo.setGroupType(FORM_DATA);
                    sysAppGroupVo.setSysApplicationList(applicationList);
                }
                result.add(sysAppGroupVo);
                return FormDesignResponse.success(result);
            }
        }
        return FormDesignResponse.fail(null, (String)"\u7c7b\u578b\u6307\u5b9a\u9519\u8bef");
    }

    @Override
    public FormDesignResponse<List<FormFieldVO>> getFormField(String appId) {
        SysSiftGroupList formList = this.sysFormService.getFormList("", "", "", Long.valueOf(appId));
        ArrayList forms = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)formList.getHaveGroupList())) {
            for (SysFormGroupVo sysFormGroupVo : formList.getHaveGroupList()) {
                forms.addAll(HussarUtils.isNotEmpty((Object)sysFormGroupVo.getSysFormList()) ? sysFormGroupVo.getSysFormList() : new ArrayList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)formList.getNoGroupList())) {
            forms.addAll(formList.getNoGroupList());
        }
        ArrayList<FormFieldVO> result = new ArrayList<FormFieldVO>();
        if (HussarUtils.isNotEmpty(forms)) {
            for (SysForm sysForm : forms) {
                FormFieldVO formFieldVO = new FormFieldVO();
                List fields = (List)this.formOperateService.widgetsForSetting(sysForm.getId().toString(), true).getData();
                HussarUtils.copy((Object)sysForm, (Object)formFieldVO);
                formFieldVO.setFields(fields);
                result.add(formFieldVO);
            }
        }
        return FormDesignResponse.success(result);
    }

    @Override
    public FormDesignResponse<GroupShowFormField> getFormFieldWithGroup(String appId) {
        SysSiftGroupList formList = this.sysFormService.getFormList("", "", "", Long.valueOf(appId));
        GroupShowFormField result = new GroupShowFormField();
        if (HussarUtils.isNotEmpty((Object)formList.getHaveGroupList())) {
            ArrayList<FormFieldGroupVO> formFieldGroupVOS = new ArrayList<FormFieldGroupVO>();
            for (SysFormGroupVo sysFormGroupVo : formList.getHaveGroupList()) {
                FormFieldGroupVO formFieldGroupVO = new FormFieldGroupVO();
                HussarUtils.copy((Object)sysFormGroupVo, (Object)formFieldGroupVO);
                if (HussarUtils.isNotEmpty((Object)sysFormGroupVo.getSysFormList())) {
                    ArrayList<FormFieldVO> formFieldVOS = new ArrayList<FormFieldVO>();
                    for (SysForm sysForm : sysFormGroupVo.getSysFormList()) {
                        if (!HussarUtils.equals((Object)sysForm.getFormType(), (Object)"0") && !HussarUtils.equals((Object)sysForm.getFormType(), (Object)FORM_DATA)) continue;
                        FormFieldVO formFieldVO = new FormFieldVO();
                        List fields = (List)this.formOperateService.widgetsForSetting(sysForm.getId().toString(), true).getData();
                        HussarUtils.copy((Object)sysForm, (Object)formFieldVO);
                        formFieldVO.setFields(fields);
                        formFieldVO.setType(Integer.valueOf(1));
                        formFieldVOS.add(formFieldVO);
                    }
                    formFieldGroupVO.setSysFormFieldList(formFieldVOS);
                }
                formFieldGroupVOS.add(formFieldGroupVO);
            }
            result.setHaveGroupList(formFieldGroupVOS);
        }
        if (HussarUtils.isNotEmpty((Object)formList.getNoGroupList())) {
            ArrayList<FormFieldVO> noGroupForms = new ArrayList<FormFieldVO>();
            for (SysForm sysForm : formList.getNoGroupList()) {
                if (!HussarUtils.equals((Object)sysForm.getFormType(), (Object)"0") && !HussarUtils.equals((Object)sysForm.getFormType(), (Object)FORM_DATA)) continue;
                FormFieldVO formFieldVO = new FormFieldVO();
                List fields = (List)this.formOperateService.widgetsForSetting(sysForm.getId().toString(), true).getData();
                HussarUtils.copy((Object)sysForm, (Object)formFieldVO);
                formFieldVO.setFields(fields);
                formFieldVO.setType(Integer.valueOf(1));
                noGroupForms.add(formFieldVO);
            }
            result.setNoGroupList(noGroupForms);
        }
        return FormDesignResponse.success((Object)result);
    }

    @Override
    public FormDesignResponse<List<FormFieldVO>> getApiField(String appId) {
        boolean open = this.eaiCrossServiceProperties.isOpen();
        ArrayList<FormFieldVO> result = new ArrayList<FormFieldVO>();
        if (open) {
            AppSyncSdkDto appSyncSdkDto = new AppSyncSdkDto();
            appSyncSdkDto.setClientId(this.eaiClientSdkProperties.getClientId());
            appSyncSdkDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
            String eaiUrl = this.eaiClientSdkProperties.getEaiUrl();
            appSyncSdkDto.setUrl(eaiUrl);
            List appInfoSdkDtoList = (List)this.eaiSyncApiSdkService.getAppDetailClassifyListNoParams(appSyncSdkDto).getData();
            AppInfoSdkDto appInfoSdkDto = appInfoSdkDtoList.stream().filter(app -> HussarUtils.equals((Object)app.getId(), (Object)appId)).findFirst().get();
            List apiClassificList = appInfoSdkDto.getApiClassificList();
            if (HussarUtils.isNotEmpty((Object)apiClassificList)) {
                for (ApiClassifySdkDto apiClassifySdkDto : apiClassificList) {
                    for (ApiInfoSdkDto apiInfoSdkDto : apiClassifySdkDto.getApiList()) {
                        FormFieldVO formFieldVO = new FormFieldVO();
                        formFieldVO.setAppId(Long.valueOf(appInfoSdkDto.getId()));
                        formFieldVO.setId(Long.valueOf(apiInfoSdkDto.getApiId()));
                        formFieldVO.setFormName(apiInfoSdkDto.getApiName());
                        formFieldVO.setAppCode(apiInfoSdkDto.getAppCode());
                        formFieldVO.setApiCode(apiInfoSdkDto.getApiCode());
                        formFieldVO.setUri(apiInfoSdkDto.getApiPath());
                        formFieldVO.setType(Integer.valueOf(3));
                        ApiDetailDto apiDetailDto = new ApiDetailDto();
                        apiDetailDto.setUrl(this.eaiClientSdkProperties.getEaiUrl());
                        apiDetailDto.setClientId(this.eaiClientSdkProperties.getClientId());
                        apiDetailDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
                        apiDetailDto.setAppCode(apiInfoSdkDto.getAppCode());
                        apiDetailDto.setApiCode(apiInfoSdkDto.getApiCode());
                        ApiInfoSdkDto apiInfoSdkDetail = (ApiInfoSdkDto)this.eaiSyncApiSdkService.getApiDetailByCode(apiDetailDto).getData();
                        ArrayList<WidgetField> paramsList = new ArrayList<WidgetField>();
                        List outParamsArray = apiInfoSdkDetail.getOutParams().getBody();
                        List<Object> fieldsArray = new ArrayList<EaiApiParamsItem>();
                        if (HussarUtils.isNotEmpty((Object)outParamsArray)) {
                            Optional<EaiApiParamsItem> data = outParamsArray.stream().filter(m -> HussarUtils.equals((Object)"data", (Object)m.getName())).findFirst();
                            Optional<EaiApiParamsItem> items = data.get().getItems().stream().filter(i -> HussarUtils.equals((Object)"data", (Object)i.getName())).findFirst();
                            Optional<EaiApiParamsItem> first = items.get().getItems().stream().filter(i -> HussarUtils.equals((Object)"item", (Object)i.getName()) || HussarUtils.equals((Object)"items", (Object)i.getName())).findFirst();
                            fieldsArray = first.get().getItems();
                        } else {
                            fieldsArray.add(new EaiApiParamsItem());
                        }
                        for (EaiApiParamsItem paramsItem : fieldsArray) {
                            String name = paramsItem.getName();
                            Integer itemType = paramsItem.getType();
                            String dateType = DataTypeConvert.convertApiDataType(itemType);
                            String componentType = DataTypeConvert.dataTypeConvertWidget(dateType);
                            String title = paramsItem.getMark();
                            WidgetField widgetField = new WidgetField(name, componentType, title, dateType, "false", "true", "false");
                            widgetField.setIsRealField(true);
                            paramsList.add(widgetField);
                        }
                        formFieldVO.setFields(paramsList);
                        result.add(formFieldVO);
                    }
                }
            }
        }
        return FormDesignResponse.success(result);
    }

    @Override
    public FormDesignResponse<FieldBriefVO> getFieldBrief(String type, String appId, String formId, String fieldName) {
        switch (type) {
            case "1": {
                SysApplicationVo applicationVo = (SysApplicationVo)this.sysApplicationService.getAppDetail(Long.valueOf(appId)).getData();
                FieldBriefVO result = new FieldBriefVO();
                if (HussarUtils.isEmpty((Object)applicationVo)) {
                    logger.error("\u67e5\u8be2\u96f6\u4ee3\u7801\u5e94\u7528\u4e0d\u5b58\u5728\uff0cappId:{}", (Object)appId);
                    return FormDesignResponse.fail((Object)result, (String)"\u67e5\u8be2\u5e94\u7528\u4e0d\u5b58\u5728");
                }
                result.setAppTitle(applicationVo.getAppName());
                ArrayList sysForms = new ArrayList();
                SysSiftGroupList formList = this.sysFormService.getFormList("", "", "", Long.valueOf(appId));
                if (HussarUtils.isNotEmpty((Object)formList.getHaveGroupList())) {
                    List haveGroupList = formList.getHaveGroupList();
                    for (SysFormGroupVo sysFormGroupVo : haveGroupList) {
                        sysForms.addAll(HussarUtils.isNotEmpty((Object)sysFormGroupVo.getSysFormList()) ? sysFormGroupVo.getSysFormList() : new ArrayList());
                    }
                }
                if (HussarUtils.isNotEmpty((Object)formList.getNoGroupList())) {
                    sysForms.addAll(formList.getNoGroupList());
                }
                if (HussarUtils.isNotEmpty(sysForms)) {
                    Optional<SysForm> first = sysForms.stream().filter(f -> HussarUtils.equals((Object)f.getId(), (Object)Long.valueOf(formId))).findFirst();
                    if (!first.isPresent()) {
                        logger.error("\u67e5\u8be2\u96f6\u4ee3\u7801\u8868\u5355\u4e0d\u5b58\u5728\uff0cformId:{}", (Object)formId);
                        return FormDesignResponse.fail((Object)result, (String)"\u67e5\u8be2\u8868\u5355\u4e0d\u5b58\u5728");
                    }
                    SysForm sysForm = first.get();
                    result.setFormTitle(sysForm.getFormName());
                    String[] newFieldName = fieldName.split("\\.");
                    if (HussarUtils.equals((Object)newFieldName.length, (Object)2)) {
                        List fieldWithChildren = (List)this.formOperateService.widgetsForSetting(formId, true).getData();
                        Optional<WidgetField> child = fieldWithChildren.stream().filter(x -> HussarUtils.equals((Object)x.getName(), (Object)newFieldName[0])).findAny();
                        if (!child.isPresent()) {
                            logger.error("\u67e5\u8be2\u8868\u5355\u5b50\u8868\u4e0d\u5b58\u5728\uff0cfieldName:{}", (Object)newFieldName[0]);
                            return FormDesignResponse.fail((Object)result, (String)"\u67e5\u8be2\u5b57\u6bb5\u6240\u5728\u5b50\u8868\u4e0d\u5b58\u5728");
                        }
                        List children = child.get().getChildren();
                        Optional<WidgetField> field = children.stream().filter(x -> HussarUtils.equals((Object)x.getName(), (Object)newFieldName[1])).findAny();
                        if (!field.isPresent()) {
                            logger.error("\u67e5\u8be2\u8868\u5355\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0cfieldName:{}", (Object)newFieldName[1]);
                            return FormDesignResponse.fail((Object)result, (String)"\u67e5\u8be2\u5b57\u6bb5\u4e0d\u5b58\u5728");
                        }
                        result.setFieldTitle(child.get().getTitle() + "." + field.get().getTitle());
                        return FormDesignResponse.success((Object)result);
                    }
                    List fields = (List)this.formOperateService.widgetsForSetting(formId, false).getData();
                    Optional<WidgetField> optionalWidgetField = fields.stream().filter(i -> HussarUtils.equals((Object)i.getName(), (Object)fieldName)).findFirst();
                    if (!optionalWidgetField.isPresent()) {
                        logger.error("\u67e5\u8be2\u8868\u5355\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0cfieldName:{}", (Object)fieldName);
                        return FormDesignResponse.fail((Object)result, (String)"\u67e5\u8be2\u5b57\u6bb5\u4e0d\u5b58\u5728");
                    }
                    result.setFieldTitle(optionalWidgetField.get().getTitle());
                    return FormDesignResponse.success((Object)result);
                }
                logger.error("\u8be5\u5e94\u7528\u65e0\u8868\u5355\u6570\u636e\uff0cappID:{},\u67e5\u8be2\u96f6\u4ee3\u7801\u8868\u5355\u4e0d\u5b58\u5728\uff0cformId:{}", (Object)appId, (Object)formId);
                return FormDesignResponse.fail((Object)result, (String)"\u67e5\u8be2\u8868\u5355\u4e0d\u5b58\u5728");
            }
            case "3": {
                boolean open = this.eaiCrossServiceProperties.isOpen();
                FieldBriefVO fieldBriefVO = new FieldBriefVO();
                if (!open) break;
                AppSyncSdkDto appSyncSdkDto = new AppSyncSdkDto();
                appSyncSdkDto.setClientId(this.eaiClientSdkProperties.getClientId());
                appSyncSdkDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
                String eaiUrl = this.eaiClientSdkProperties.getEaiUrl();
                appSyncSdkDto.setUrl(eaiUrl);
                List appInfoSdkDtoList = (List)this.eaiSyncApiSdkService.getAppDetailClassifyListNoParams(appSyncSdkDto).getData();
                Optional<AppInfoSdkDto> app = appInfoSdkDtoList.stream().filter(ap -> HussarUtils.equals((Object)ap.getId(), (Object)appId)).findFirst();
                if (!app.isPresent()) {
                    logger.error("\u67e5\u8be2\u5916\u90e8api\u5e94\u7528\u4e0d\u5b58\u5728\uff0cappId:{}", (Object)appId);
                    return FormDesignResponse.fail((Object)fieldBriefVO, (String)"\u67e5\u8be2\u5e94\u7528\u4e0d\u5b58\u5728");
                }
                AppInfoSdkDto appInfoSdkDto = app.get();
                fieldBriefVO.setAppTitle(appInfoSdkDto.getAppName());
                ArrayList apiInfoSdkDtos = new ArrayList();
                for (ApiClassifySdkDto apiClassifySdkDto : appInfoSdkDto.getApiClassificList()) {
                    apiInfoSdkDtos.addAll(apiClassifySdkDto.getApiList());
                }
                if (HussarUtils.isNotEmpty(apiInfoSdkDtos)) {
                    Optional<ApiInfoSdkDto> first = apiInfoSdkDtos.stream().filter(api -> HussarUtils.equals((Object)api.getApiId(), (Object)Long.valueOf(formId))).findFirst();
                    if (!first.isPresent()) {
                        logger.error("\u67e5\u8be2\u5916\u90e8api\u63a5\u53e3\u4e0d\u5b58\u5728\uff0capiId:{}", (Object)formId);
                        return FormDesignResponse.fail((Object)fieldBriefVO, (String)"\u67e5\u8be2\u63a5\u53e3\u4e0d\u5b58\u5728");
                    }
                    ApiInfoSdkDto apiInfoSdkDto = first.get();
                    fieldBriefVO.setFormTitle(apiInfoSdkDto.getApiName());
                    ApiDetailDto apiDetailDto = new ApiDetailDto();
                    apiDetailDto.setUrl(this.eaiClientSdkProperties.getEaiUrl());
                    apiDetailDto.setClientId(this.eaiClientSdkProperties.getClientId());
                    apiDetailDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
                    apiDetailDto.setAppCode(apiInfoSdkDto.getAppCode());
                    apiDetailDto.setApiCode(apiInfoSdkDto.getApiCode());
                    ApiInfoSdkDto apiInfoSdkDetail = (ApiInfoSdkDto)this.eaiSyncApiSdkService.getApiDetailByCode(apiDetailDto).getData();
                    List outParamsArray = apiInfoSdkDetail.getOutParams().getBody();
                    List<Object> fieldsArray = new ArrayList<EaiApiParamsItem>();
                    if (HussarUtils.isNotEmpty((Object)outParamsArray)) {
                        Optional<EaiApiParamsItem> data = outParamsArray.stream().filter(m -> HussarUtils.equals((Object)"data", (Object)m.getName())).findFirst();
                        Optional<EaiApiParamsItem> items = data.get().getItems().stream().filter(i -> HussarUtils.equals((Object)"data", (Object)i.getName())).findFirst();
                        Optional<EaiApiParamsItem> paramsItem = items.get().getItems().stream().filter(i -> HussarUtils.equals((Object)"item", (Object)i.getName()) || HussarUtils.equals((Object)"items", (Object)i.getName())).findFirst();
                        fieldsArray = paramsItem.get().getItems();
                    } else {
                        fieldsArray.add(new EaiApiParamsItem());
                    }
                    if (!HussarUtils.isNotEmpty(fieldsArray)) break;
                    Optional<EaiApiParamsItem> item = fieldsArray.stream().filter(d -> HussarUtils.equals((Object)d.getName(), (Object)fieldName)).findFirst();
                    if (!item.isPresent()) {
                        logger.error("\u67e5\u8be2\u5916\u90e8api\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0cfieldName:{}", (Object)fieldName);
                        return FormDesignResponse.fail((Object)fieldBriefVO, (String)"\u67e5\u8be2\u5b57\u6bb5\u4e0d\u5b58\u5728");
                    }
                    if (HussarUtils.isEmpty((Object)item.get().getMark()) || HussarUtils.equals((Object)item.get().getMark(), (Object)"")) {
                        fieldBriefVO.setFieldTitle(item.get().getName());
                    } else {
                        fieldBriefVO.setFieldTitle(item.get().getMark());
                    }
                    return FormDesignResponse.success((Object)fieldBriefVO);
                }
                logger.error("\u67e5\u8be2\u5916\u90e8api\u63a5\u53e3\u4e0d\u5b58\u5728\uff0capiId:{}", (Object)formId);
                return FormDesignResponse.fail((Object)fieldBriefVO, (String)"\u67e5\u8be2\u63a5\u53e3\u4e0d\u5b58\u5728");
            }
        }
        return FormDesignResponse.fail(null, (String)"\u7c7b\u578b\u6307\u5b9a\u9519\u8bef");
    }

    @Override
    public FormDesignResponse<SysApplication> appDetails(String type, String appId) {
        switch (type) {
            case "1": {
                SysApplication sysApplication = new SysApplication();
                try {
                    SysApplicationVo appDetail = this.sysApplicationService.getAuthorityAppDetail(Long.valueOf(appId));
                    HussarUtils.copy((Object)appDetail, (Object)sysApplication);
                    return FormDesignResponse.success((Object)sysApplication);
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5e94\u7528\u8be6\u60c5\u9519\u8bef", (Throwable)e);
                    return FormDesignResponse.fail(null, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u5e94\u7528");
                }
            }
            case "3": {
                boolean open = this.eaiCrossServiceProperties.isOpen();
                SysApplication result = new SysApplication();
                if (open) {
                    AppSyncSdkDto appSyncSdkDto = new AppSyncSdkDto();
                    appSyncSdkDto.setClientId(this.eaiClientSdkProperties.getClientId());
                    appSyncSdkDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
                    String eaiUrl = this.eaiClientSdkProperties.getEaiUrl();
                    appSyncSdkDto.setUrl(eaiUrl);
                    List appInfoSdkDtoList = (List)this.eaiSyncApiSdkService.getAppDetailClassifyListNoParams(appSyncSdkDto).getData();
                    Optional<AppInfoSdkDto> any = appInfoSdkDtoList.stream().filter(x -> HussarUtils.equals((Object)x.getId(), (Object)appId)).findAny();
                    if (!any.isPresent()) {
                        logger.error("\u67e5\u8be2\u5e94\u7528\u4e0d\u5b58\u5728,appId\uff1a{}", (Object)appId);
                        return FormDesignResponse.fail(null, (String)"\u67e5\u8be2\u5e94\u7528\u4e0d\u5b58\u5728");
                    }
                    AppInfoSdkDto appInfoSdkDto = any.get();
                    result.setId(Long.valueOf(appInfoSdkDto.getId()));
                    result.setAppName(appInfoSdkDto.getAppName());
                    result.setAppCode(appInfoSdkDto.getAppCode());
                    result.setAppIconType(appInfoSdkDto.getAppIconType());
                    result.setAppIcon(appInfoSdkDto.getAppIcon());
                    result.setAppIconColor(appInfoSdkDto.getAppIconColor());
                }
                return FormDesignResponse.success((Object)result);
            }
        }
        return FormDesignResponse.fail(null, (String)"\u4f20\u8f93\u5e94\u7528\u7c7b\u578b\u4e0d\u5b58\u5728");
    }

    @Override
    public FormDesignResponse<BestMatchField> fieldRecommend(Long appId, Long formId, String fieldName, String fieldTitle, String fieldType) {
        BestMatchField bestMatchField = new BestMatchField();
        SysApplicationVo thisApplication = (SysApplicationVo)this.sysApplicationService.getAppDetail(appId).getData();
        bestMatchField.setApplicationVo(thisApplication);
        SysSiftGroupList formList = this.sysFormService.getFormList("", "", "", appId);
        ArrayList forms = new ArrayList(HussarUtils.isNotEmpty((Object)formList.getNoGroupList()) ? formList.getNoGroupList() : new ArrayList());
        if (HussarUtils.isNotEmpty((Object)formList.getHaveGroupList())) {
            for (SysFormGroupVo sysFormGroupVo : formList.getHaveGroupList()) {
                if (!HussarUtils.isNotEmpty((Object)sysFormGroupVo.getSysFormList())) continue;
                forms.addAll(sysFormGroupVo.getSysFormList());
            }
        }
        if (HussarUtils.isNotEmpty(forms)) {
            AppContextUtil.setAppId((String)String.valueOf(appId));
            for (SysForm form : forms) {
                List<Object> fields = new ArrayList();
                fields = HussarUtils.equals((Object)form.getId(), (Object)formId) ? this.getFields(String.valueOf(form.getId()), fieldType).stream().filter(x -> !HussarUtils.equals((Object)x.getName(), (Object)fieldName)).collect(Collectors.toList()) : this.getFields(String.valueOf(form.getId()), fieldType);
                if (!HussarUtils.isNotEmpty(fields)) continue;
                for (WidgetField field : fields) {
                    if (HussarUtils.isNotEmpty((Object)field.getChildren())) {
                        List<WidgetField> fieldList = this.filterChildField(field.getChildren(), fieldType);
                        if (!HussarUtils.isNotEmpty(fieldList)) continue;
                        for (WidgetField childField : fieldList) {
                            double rate = this.stringSimilarity(fieldTitle, childField.getTitle());
                            if (!HussarUtils.isEmpty((Object)bestMatchField.getMatchRate()) && !HussarUtils.equals((Object)bestMatchField.getMatchRate(), (Object)0.0) && !(rate > bestMatchField.getMatchRate())) continue;
                            bestMatchField.setFieldData(rate, form, childField, field.getTitle());
                        }
                        continue;
                    }
                    double rate = this.stringSimilarity(fieldTitle, field.getTitle());
                    if (!HussarUtils.isEmpty((Object)bestMatchField.getMatchRate()) && !HussarUtils.equals((Object)bestMatchField.getMatchRate(), (Object)0.0) && !(rate > bestMatchField.getMatchRate())) continue;
                    bestMatchField.setFieldData(rate, form, field, "");
                }
            }
        }
        return FormDesignResponse.success((Object)bestMatchField);
    }

    private List<WidgetField> getFields(String formId, String fieldType) {
        FormDesignResponse<FormCanvasSchema> canvasResponse;
        ArrayList<WidgetField> widgetFields = new ArrayList<WidgetField>();
        try {
            canvasResponse = this.canvasSchemaService.get(formId);
        }
        catch (Exception e) {
            return widgetFields;
        }
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u7528\u6237\u53ef\u9009\u7684\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return widgetFields;
        }
        List<Widget> widgets = new ArrayList<Widget>();
        if (HussarUtils.isNotEmpty(canvas.getWidgets())) {
            widgets = HussarUtils.equals((Object)fieldType, (Object)WidgetType.JXDNLinkForm.getType()) ? WidgetTool.flatSelect(canvas.getWidgets(), WidgetType.INPUT.getType(), WidgetType.TEXTAREA.getType(), WidgetType.SELECT_MUL.getType(), WidgetType.SELECT.getType(), WidgetType.RADIO_GROUP.getType(), WidgetType.CHECK_BOX_GROUP.getType(), WidgetType.ADDRESS.getType(), WidgetType.JXDNUser.getType(), WidgetType.JXDNUserMulti.getType(), WidgetType.JXDNOrg.getType(), WidgetType.JXDNOrgMulti.getType(), WidgetType.JXDNLinkForm.getType(), WidgetType.JXDNSerialNumber.getType(), WidgetType.JXDNAmountCapital.getType(), WidgetType.CHILDREN_TABLE.getType(), WidgetType.JXDNExtWidget.getType()) : WidgetTool.flatSelect(canvas.getWidgets(), WidgetType.INPUT.getType(), WidgetType.TEXTAREA.getType(), WidgetType.JXDNSerialNumber.getType(), WidgetType.JXDNLinkForm.getType(), WidgetType.JXDNExtWidget.getType());
            widgets.removeIf(x -> HussarUtils.equals((Object)x.getType(), (Object)WidgetType.JXDNExtWidget.getType()) && HussarUtils.equals((Object)x.isVirtualField(), (Object)false));
        }
        if (HussarUtils.isNotEmpty(widgets)) {
            WidgetTool.ofWidgetFields(widgetFields, widgets, widget -> false);
        }
        return widgetFields;
    }

    private FormDesignResponse<BestMatchField> matchElseApp(Long appId, String fieldTitle, String fieldType, BestMatchField bestMatchField) {
        BestMatchField bestMatchField2 = new BestMatchField();
        List manageAppList = this.sysApplicationService.getManageAppList(null, "", FORM_DATA);
        ArrayList applicationList = new ArrayList();
        for (SysAppGroupVo sysAppGroupVo : manageAppList) {
            if (!HussarUtils.isNotEmpty((Object)sysAppGroupVo.getSysApplicationList())) continue;
            applicationList.addAll(sysAppGroupVo.getSysApplicationList());
        }
        List allApplicationList = applicationList.stream().filter(x -> !HussarUtils.equals((Object)x.getId(), (Object)appId)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(allApplicationList)) {
            for (SysApplicationVo sysApplicationVo : allApplicationList) {
                AppContextUtil.setAppId((String)String.valueOf(sysApplicationVo.getId()));
                SysApplicationVo applicationVo = (SysApplicationVo)this.sysApplicationService.getAppDetail(sysApplicationVo.getId()).getData();
                SysSiftGroupList serviceFormList = this.sysFormService.getFormList("", "", "", sysApplicationVo.getId());
                ArrayList allForms = new ArrayList(HussarUtils.isNotEmpty((Object)serviceFormList.getNoGroupList()) ? serviceFormList.getNoGroupList() : new ArrayList());
                if (HussarUtils.isNotEmpty((Object)serviceFormList.getHaveGroupList())) {
                    for (SysFormGroupVo sysFormGroupVo : serviceFormList.getHaveGroupList()) {
                        if (!HussarUtils.isNotEmpty((Object)sysFormGroupVo.getSysFormList())) continue;
                        allForms.addAll(sysFormGroupVo.getSysFormList());
                    }
                }
                if (!HussarUtils.isNotEmpty(allForms)) continue;
                for (SysForm allForm : allForms) {
                    List<WidgetField> fields = this.getFields(String.valueOf(allForm.getId()), fieldType);
                    if (!HussarUtils.isNotEmpty(fields)) continue;
                    for (WidgetField field : fields) {
                        if (HussarUtils.isNotEmpty((Object)field.getChildren())) {
                            List<WidgetField> childrenFields = this.filterChildField(field.getChildren(), fieldType);
                            if (!HussarUtils.isNotEmpty(childrenFields)) continue;
                            for (WidgetField childField : childrenFields) {
                                double rate = this.stringSimilarity(fieldTitle, childField.getTitle());
                                if (!HussarUtils.isEmpty((Object)bestMatchField2.getMatchRate()) && !HussarUtils.equals((Object)bestMatchField2.getMatchRate(), (Object)0.0) && !(rate > bestMatchField2.getMatchRate())) continue;
                                bestMatchField2.setApplicationVo(applicationVo);
                                bestMatchField2.setFieldData(rate, allForm, childField, field.getTitle());
                            }
                            continue;
                        }
                        double rate = this.stringSimilarity(fieldTitle, field.getTitle());
                        if (!HussarUtils.isEmpty((Object)bestMatchField2.getMatchRate()) && !HussarUtils.equals((Object)bestMatchField2.getMatchRate(), (Object)0.0) && !(rate > bestMatchField2.getMatchRate())) continue;
                        bestMatchField2.setApplicationVo(applicationVo);
                        bestMatchField2.setFieldData(rate, allForm, field, "");
                    }
                }
            }
        }
        if (bestMatchField2.getMatchRate() > bestMatchField.getMatchRate()) {
            return FormDesignResponse.success((Object)bestMatchField2);
        }
        return FormDesignResponse.success((Object)bestMatchField);
    }

    private List<WidgetField> filterChildField(List<WidgetField> fields, String fieldType) {
        String[] fieldsType = HussarUtils.equals((Object)fieldType, (Object)WidgetType.JXDNLinkForm.getType()) ? new String[]{WidgetType.INPUT.getType(), WidgetType.TEXTAREA.getType(), WidgetType.SELECT_MUL.getType(), WidgetType.SELECT.getType(), WidgetType.RADIO_GROUP.getType(), WidgetType.CHECK_BOX_GROUP.getType(), WidgetType.ADDRESS.getType(), WidgetType.JXDNUser.getType(), WidgetType.JXDNUserMulti.getType(), WidgetType.JXDNOrg.getType(), WidgetType.JXDNOrgMulti.getType(), WidgetType.JXDNLinkForm.getType(), WidgetType.JXDNSerialNumber.getType(), WidgetType.JXDNAmountCapital.getType(), WidgetType.JXDNExtWidget.getType()} : new String[]{WidgetType.INPUT.getType(), WidgetType.TEXTAREA.getType(), WidgetType.JXDNSerialNumber.getType(), WidgetType.JXDNLinkForm.getType(), WidgetType.JXDNExtWidget.getType()};
        fields.removeIf(x -> !HussarUtils.contains((Object[])fieldsType, (Object)x.getType()));
        return fields;
    }

    private double stringSimilarity(String source, String target) {
        int len1 = source.length();
        int len2 = target.length();
        int common = 0;
        block0: for (int i = 0; i < len1; ++i) {
            for (int j = 0; j < len2; ++j) {
                if (source.charAt(i) != target.charAt(j)) continue;
                ++common;
                continue block0;
            }
        }
        return (double)common / (double)Math.max(len1, len2);
    }

    private List<AppTreeExtendVo> convertVoOne(List<SysApplicationVo> sysApplicationVos) {
        ArrayList<AppTreeExtendVo> appTreeExtendVoList = new ArrayList<AppTreeExtendVo>();
        if (HussarUtils.isNotEmpty(sysApplicationVos)) {
            for (SysApplicationVo sysApplicationVo : sysApplicationVos) {
                AppTreeExtendVo appTreeExtendVo = new AppTreeExtendVo();
                appTreeExtendVo.setId(sysApplicationVo.getId());
                appTreeExtendVo.setAppName(sysApplicationVo.getAppName());
                List noGroupList = sysApplicationVo.getNoGroupList();
                if (HussarUtils.isNotEmpty((Object)noGroupList)) {
                    List noGroupFormVos = noGroupList.stream().map(sysForm -> {
                        SysFormDataVo sysFormVo = new SysFormDataVo();
                        BeanUtils.copyProperties((Object)sysForm, (Object)sysFormVo);
                        sysFormVo.setType(Integer.valueOf(1));
                        return sysFormVo;
                    }).collect(Collectors.toList());
                    appTreeExtendVo.setNoGroupList(noGroupFormVos);
                }
                ArrayList<FormGroupExtendVo> formGroupExtendVos = new ArrayList<FormGroupExtendVo>();
                List sysFormGroupVos = sysApplicationVo.getSysFormGroupVos();
                if (HussarUtils.isNotEmpty((Object)sysFormGroupVos)) {
                    for (SysFormGroupVo sysFormGroupVo : sysFormGroupVos) {
                        FormGroupExtendVo formGroupExtendVo = new FormGroupExtendVo();
                        formGroupExtendVo.setAppId(sysFormGroupVo.getAppId());
                        formGroupExtendVo.setId(sysFormGroupVo.getId());
                        formGroupExtendVo.setGroupName(sysFormGroupVo.getGroupName());
                        List sysFormList = sysFormGroupVo.getSysFormList();
                        if (HussarUtils.isNotEmpty((Object)sysFormList)) {
                            List sysFormVos = sysFormList.stream().map(sysForm -> {
                                SysFormDataVo sysFormVo = new SysFormDataVo();
                                BeanUtils.copyProperties((Object)sysForm, (Object)sysFormVo);
                                sysFormVo.setType(Integer.valueOf(1));
                                return sysFormVo;
                            }).collect(Collectors.toList());
                            formGroupExtendVo.setSysFormList(sysFormVos);
                        }
                        formGroupExtendVos.add(formGroupExtendVo);
                    }
                }
                appTreeExtendVo.setAppIcon(sysApplicationVo.getAppIcon());
                appTreeExtendVo.setSysFormGroupVos(formGroupExtendVos);
                appTreeExtendVoList.add(appTreeExtendVo);
            }
        }
        return appTreeExtendVoList;
    }

    private List<AppTreeExtendVo> convertVoTwo(List<SysDataSetAppVo> sysDataSetAppVos) {
        ArrayList<AppTreeExtendVo> appTreeExtendVoList = new ArrayList<AppTreeExtendVo>();
        if (HussarUtils.isNotEmpty(sysDataSetAppVos)) {
            for (SysDataSetAppVo sysDataSetAppVo : sysDataSetAppVos) {
                AppTreeExtendVo appTreeExtendVo = new AppTreeExtendVo();
                appTreeExtendVo.setId(sysDataSetAppVo.getId());
                appTreeExtendVo.setAppName(sysDataSetAppVo.getAppName());
                if (HussarUtils.isNotEmpty((Object)sysDataSetAppVo.getSysSiftDataSetGroupList())) {
                    List haveGroupList;
                    List noGroupList = sysDataSetAppVo.getSysSiftDataSetGroupList().getNoGroupList();
                    if (HussarUtils.isNotEmpty((Object)noGroupList)) {
                        List noGroupFormVos = noGroupList.stream().map(element -> {
                            SysFormDataVo sysFormVo = new SysFormDataVo();
                            sysFormVo.setAppId(element.getAppId());
                            sysFormVo.setId(element.getDataSetId());
                            sysFormVo.setFormName(element.getDataSetName());
                            sysFormVo.setFormIconType(element.getDataSetIconType());
                            sysFormVo.setFormIcon(element.getDataSetIcon());
                            sysFormVo.setFormIconColor(element.getDataSetIconColor());
                            sysFormVo.setType(Integer.valueOf(2));
                            return sysFormVo;
                        }).collect(Collectors.toList());
                        appTreeExtendVo.setNoGroupList(noGroupFormVos);
                    }
                    if (HussarUtils.isNotEmpty((Object)(haveGroupList = sysDataSetAppVo.getSysSiftDataSetGroupList().getHaveGroupList()))) {
                        ArrayList<FormGroupExtendVo> formGroupExtendVos = new ArrayList<FormGroupExtendVo>();
                        for (SysDataSetGroupVo dataSetGroup : haveGroupList) {
                            FormGroupExtendVo formGroupExtendVo = new FormGroupExtendVo();
                            formGroupExtendVo.setAppId(dataSetGroup.getAppId());
                            formGroupExtendVo.setId(dataSetGroup.getGroupId());
                            formGroupExtendVo.setGroupName(dataSetGroup.getGroupName());
                            List dataSetItems = dataSetGroup.getSysDataSetList();
                            if (HussarUtils.isNotEmpty((Object)dataSetItems)) {
                                List sysFormVos = dataSetItems.stream().map(element -> {
                                    SysFormDataVo sysFormVo = new SysFormDataVo();
                                    sysFormVo.setAppId(element.getAppId());
                                    sysFormVo.setId(element.getDataSetId());
                                    sysFormVo.setFormName(element.getDataSetName());
                                    sysFormVo.setFormIconType(element.getDataSetIconType());
                                    sysFormVo.setFormIcon(element.getDataSetIcon());
                                    sysFormVo.setFormIconColor(element.getDataSetIconColor());
                                    sysFormVo.setType(Integer.valueOf(2));
                                    return sysFormVo;
                                }).collect(Collectors.toList());
                                formGroupExtendVo.setSysFormList(sysFormVos);
                            }
                            formGroupExtendVos.add(formGroupExtendVo);
                        }
                        appTreeExtendVo.setSysFormGroupVos(formGroupExtendVos);
                    }
                }
                appTreeExtendVoList.add(appTreeExtendVo);
            }
        }
        return appTreeExtendVoList;
    }

    private List<AppTreeExtendVo> convertVoExternalApi(List<AppInfoSdkDto> appInfoSdkDtoList) {
        ArrayList<AppTreeExtendVo> appTreeExtendVoList = new ArrayList<AppTreeExtendVo>();
        if (HussarUtils.isNotEmpty(appInfoSdkDtoList)) {
            for (AppInfoSdkDto appInfoSdkDto : appInfoSdkDtoList) {
                AppTreeExtendVo appTreeExtendVo = new AppTreeExtendVo();
                appTreeExtendVo.setId(Long.valueOf(appInfoSdkDto.getId()));
                appTreeExtendVo.setAppName(appInfoSdkDto.getAppName());
                List apiClassificList = appInfoSdkDto.getApiClassificList();
                if (HussarUtils.isNotEmpty((Object)apiClassificList)) {
                    ArrayList<FormGroupExtendVo> formGroupExtendVos = new ArrayList<FormGroupExtendVo>();
                    for (ApiClassifySdkDto apiClassifySdkDto : apiClassificList) {
                        FormGroupExtendVo formGroupExtendVo = new FormGroupExtendVo();
                        formGroupExtendVo.setId(apiClassifySdkDto.getClassificId());
                        formGroupExtendVo.setGroupName(apiClassifySdkDto.getClassificName());
                        List apiList = apiClassifySdkDto.getApiList();
                        if (HussarUtils.isNotEmpty((Object)apiList)) {
                            List sysFormVos = apiList.stream().map(element -> {
                                SysFormDataVo sysFormVo = new SysFormDataVo();
                                sysFormVo.setAppId(Long.valueOf(appInfoSdkDto.getId()));
                                sysFormVo.setId(Long.valueOf(element.getApiId()));
                                sysFormVo.setFormName(element.getApiName());
                                sysFormVo.setAppCode(element.getAppCode());
                                sysFormVo.setApiCode(element.getApiCode());
                                sysFormVo.setType(Integer.valueOf(3));
                                return sysFormVo;
                            }).collect(Collectors.toList());
                            formGroupExtendVo.setSysFormList(sysFormVos);
                        }
                        formGroupExtendVos.add(formGroupExtendVo);
                    }
                    appTreeExtendVo.setSysFormGroupVos(formGroupExtendVos);
                }
                appTreeExtendVoList.add(appTreeExtendVo);
            }
        }
        return appTreeExtendVoList;
    }

    private void filterDataList(List<AppTreeExtendVo> appTreeExtendVos, String key) {
        if (HussarUtils.isNotEmpty(appTreeExtendVos) && HussarUtils.isNotEmpty((Object)key)) {
            Iterator<AppTreeExtendVo> iterator = appTreeExtendVos.iterator();
            while (iterator.hasNext()) {
                AppTreeExtendVo appTreeExtendVo = iterator.next();
                List noGroupList = appTreeExtendVo.getNoGroupList();
                List<Object> noGroupMatchList = new ArrayList();
                if (HussarUtils.isNotEmpty((Object)noGroupList) && HussarUtils.isNotEmpty(noGroupMatchList = noGroupList.stream().filter(sysFormVo -> sysFormVo.getFormName().contains(key)).collect(Collectors.toList()))) {
                    appTreeExtendVo.setNoGroupList(noGroupMatchList);
                }
                List sysFormGroupVos = appTreeExtendVo.getSysFormGroupVos();
                ArrayList<FormGroupExtendVo> sysFromGroupMatchVos = new ArrayList<FormGroupExtendVo>();
                if (HussarUtils.isNotEmpty((Object)sysFormGroupVos)) {
                    for (FormGroupExtendVo formGroupExtendVo : sysFormGroupVos) {
                        List sysFormMatchList;
                        List sysFormList;
                        if (formGroupExtendVo.getGroupName().contains(key)) {
                            sysFromGroupMatchVos.add(formGroupExtendVo);
                        }
                        if (!HussarUtils.isNotEmpty((Object)(sysFormList = formGroupExtendVo.getSysFormList())) || !HussarUtils.isNotEmpty(sysFormMatchList = sysFormList.stream().filter(sysFormVo -> sysFormVo.getFormName().contains(key)).collect(Collectors.toList()))) continue;
                        sysFromGroupMatchVos.remove(formGroupExtendVo);
                        formGroupExtendVo.setSysFormList(sysFormMatchList);
                        sysFromGroupMatchVos.add(formGroupExtendVo);
                    }
                    if (HussarUtils.isNotEmpty(sysFromGroupMatchVos)) {
                        appTreeExtendVo.setSysFormGroupVos(sysFromGroupMatchVos);
                    }
                }
                if (HussarUtils.isNotEmpty(noGroupMatchList) && HussarUtils.isEmpty(sysFromGroupMatchVos)) {
                    appTreeExtendVo.setSysFormGroupVos(null);
                }
                if (HussarUtils.isEmpty(noGroupMatchList) && HussarUtils.isNotEmpty(sysFromGroupMatchVos)) {
                    appTreeExtendVo.setNoGroupList(null);
                }
                if (!HussarUtils.isEmpty(noGroupMatchList) || !HussarUtils.isEmpty(sysFromGroupMatchVos) || appTreeExtendVo.getAppName().contains(key)) continue;
                iterator.remove();
            }
        }
    }

    private List<SysApplicationVo> toApplicationListOfSdk(List<AppInfoSdkDto> appInfoSdkDtoList) {
        ArrayList<SysApplicationVo> sysApplicationVos = new ArrayList<SysApplicationVo>();
        if (HussarUtils.isNotEmpty(appInfoSdkDtoList)) {
            for (AppInfoSdkDto appInfoSdkDto : appInfoSdkDtoList) {
                SysApplicationVo sysApplicationVo = new SysApplicationVo();
                sysApplicationVo.setId(Long.valueOf(appInfoSdkDto.getId()));
                sysApplicationVo.setAppName(appInfoSdkDto.getAppName());
                sysApplicationVo.setAppCode(appInfoSdkDto.getAppCode());
                sysApplicationVo.setAppIconType(appInfoSdkDto.getAppIconType());
                sysApplicationVo.setAppIcon(appInfoSdkDto.getAppIcon());
                sysApplicationVo.setAppIconColor(appInfoSdkDto.getAppIconColor());
                sysApplicationVos.add(sysApplicationVo);
            }
        }
        return sysApplicationVos;
    }
}

