/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.controller;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppTreeExtendVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.BestMatchField;
import com.jxdinfo.hussar.formdesign.application.form.vo.FieldBriefVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FieldDetailVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormFieldVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.GroupShowFormField;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FieldDataSourceService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="FieldDataSourceControllerNoCode")
@RequestMapping(value={"/formdesign/dataSource"})
public class FieldDataSourceController {
    @Resource
    private FieldDataSourceService fieldDataSourceService;

    @GetMapping(value={"/list"})
    public FormDesignResponse<List<AppTreeExtendVo>> dataList(@RequestParam String type, @RequestParam(required=false) String key) {
        return this.fieldDataSourceService.dataList(type, key);
    }

    @GetMapping(value={"/detail"})
    public FormDesignResponse<FieldDetailVO> sourceDetail(@RequestParam String type, @RequestParam String appId, @RequestParam String formId, @RequestParam(required=false) String appCode, @RequestParam(required=false) String apiCode) throws IOException, LcdpException {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        return this.fieldDataSourceService.sourceDetail(type, appId, formId, appCode, apiCode);
    }

    @GetMapping(value={"/app_list"})
    public FormDesignResponse<List<SysAppGroupVo>> appList(@RequestParam String type) {
        return this.fieldDataSourceService.appList(type);
    }

    @GetMapping(value={"/form_field_group"})
    public FormDesignResponse<GroupShowFormField> getFormFieldWithGroup(@RequestParam String appId) {
        return this.fieldDataSourceService.getFormFieldWithGroup(appId);
    }

    @GetMapping(value={"/form_field"})
    public FormDesignResponse<List<FormFieldVO>> getFormField(@RequestParam String appId) {
        return this.fieldDataSourceService.getFormField(appId);
    }

    @GetMapping(value={"/api_field"})
    public FormDesignResponse<List<FormFieldVO>> getApiField(@RequestParam String appId) {
        return this.fieldDataSourceService.getApiField(appId);
    }

    @GetMapping(value={"/field_brief"})
    public FormDesignResponse<FieldBriefVO> getFieldBrief(@RequestParam String type, @RequestParam String appId, @RequestParam String formId, @RequestParam String fieldName) {
        return this.fieldDataSourceService.getFieldBrief(type, appId, formId, fieldName);
    }

    @GetMapping(value={"/app_details"})
    public FormDesignResponse<SysApplication> appDetails(@RequestParam String type, @RequestParam String appId) {
        return this.fieldDataSourceService.appDetails(type, appId);
    }

    @GetMapping(value={"/field_recommend"})
    public FormDesignResponse<BestMatchField> fieldRecommend(@RequestParam Long appId, @RequestParam Long formId, @RequestParam String fieldName, @RequestParam String fieldTitle, @RequestParam String fieldType) {
        return this.fieldDataSourceService.fieldRecommend(appId, formId, fieldName, fieldTitle, fieldType);
    }
}

