/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.mongo;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.mongo.MongoTemplateCache;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnMongo;
import com.mongodb.BasicDBObject;
import javax.annotation.Resource;
import org.bson.Document;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnMongo.class})
public class ViewSchemaMongoImpl
implements ViewSchemaService {
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormViewSchema formViewSchema) {
        MongoTemplate template = MongoTemplateCache.get();
        template.getConverter().write((Object)formViewSchema, (Object)new BasicDBObject());
        Update update = Update.fromDocument((Document)Document.parse((String)JSON.toJSONString((Object)formViewSchema)), (String[])new String[0]);
        template.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)formViewSchema.getFormId())), update, FormViewSchema.class);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<FormViewSchema> get(String formId) {
        MongoTemplate template = MongoTemplateCache.get();
        return FormDesignResponse.success((Object)template.findById((Object)formId, FormViewSchema.class));
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        MongoTemplate template = MongoTemplateCache.get();
        template.remove((Object)Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)formId)));
        return FormDesignResponse.success((Object)true);
    }
}

