/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FormDetailVO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.FieldControlUnitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.HideRuleSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.RuleField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.RuleSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FieldControlCollection;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.ShowForms;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/form/setting"})
public class SettingController {
    @Resource
    private SettingService settingService;

    @PostMapping(value={"/title"})
    public FormDesignResponse<Boolean> saveTitle(@RequestBody TitleSchema titleSchema, @RequestParam(value="formId") String formId) throws Exception {
        return this.settingService.saveTitle(titleSchema, formId);
    }

    @GetMapping(value={"/title"})
    public FormDesignResponse<TitleSchema> getTitle(@RequestParam String formId) {
        return this.settingService.getTitle(formId);
    }

    @PostMapping(value={"/summary"})
    public FormDesignResponse<Boolean> saveSummary(@RequestBody List<String> dataSummary, @RequestParam(value="formId") String formId) throws Exception {
        return this.settingService.saveSummary(dataSummary, formId);
    }

    @GetMapping(value={"/summary"})
    public FormDesignResponse<List<String>> getSummary(@RequestParam String formId) {
        return this.settingService.getSummary(formId);
    }

    @PostMapping(value={"/fieldControl"})
    public FormDesignResponse<Boolean> saveFieldControl(@RequestBody FieldControlSchema fieldControlSchema, @RequestParam(value="formId") String formId) throws Exception {
        return this.settingService.saveFieldControl(fieldControlSchema, formId);
    }

    @GetMapping(value={"/fieldControl"})
    public FormDesignResponse<FieldControlUnitSchema> getFieldControl(@RequestParam String formId) throws IOException {
        return this.settingService.getFieldControl(formId);
    }

    @GetMapping(value={"/fieldControlCollection"})
    public FormDesignResponse<FieldControlCollection> geFieldControlCollection(@RequestParam String formId) throws IOException {
        return this.settingService.geFieldControlCollection(formId);
    }

    @PostMapping(value={"/submit"})
    public FormDesignResponse<Boolean> saveSubmit(@RequestBody SubmitSchema submitSchema, @RequestParam(value="formId") String formId) throws Exception {
        return this.settingService.saveSubmit(submitSchema, formId);
    }

    @GetMapping(value={"/submit"})
    public FormDesignResponse<SubmitSchema> getSubmit(@RequestParam String formId) {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.submit", SettingSchemaService.class);
        return settingSchemaService.get(formId);
    }

    @GetMapping(value={"/reference"})
    public FormDesignResponse<List<FormDetailVO>> getReference(@RequestParam String formId) throws JsonProcessingException {
        return this.settingService.getReference(formId);
    }

    @GetMapping(value={"/showForms"})
    public FormDesignResponse<List<FormDetailVO>> getShowForms(@RequestParam String formId) {
        return this.settingService.getShowForms(formId);
    }

    @PostMapping(value={"/showForms"})
    public FormDesignResponse<Boolean> saveShowForms(@RequestBody ShowForms showForms) throws Exception {
        return this.settingService.saveShowForms(showForms.getShowForms(), showForms.getFormId());
    }

    @GetMapping(value={"/hide_rule"})
    public FormDesignResponse<HideRuleSchema> getHideSchema(@RequestParam String formId) {
        return this.settingService.getHideRule(formId);
    }

    @PostMapping(value={"/hide_rule/invisible"})
    public FormDesignResponse<Boolean> saveSpecialField(@RequestParam(value="formId") String formId, @RequestBody(required=false) List<RuleField> specialFields, @RequestParam Integer hideValueType) throws Exception {
        return this.settingService.saveSpecialField(formId, specialFields, hideValueType);
    }

    @PostMapping(value={"/hide_rule/save"})
    public FormDesignResponse<Boolean> saveRule(@RequestParam(value="formId") String formId, @RequestBody RuleSchema rule) throws Exception {
        return this.settingService.saveRule(formId, rule);
    }

    @PostMapping(value={"/hide_rule/copy"})
    public FormDesignResponse<Boolean> copyRule(@RequestParam(value="formId") String formId, @RequestParam String ruleId, @RequestParam String cloneRuleId) throws Exception {
        return this.settingService.copyRule(formId, ruleId, cloneRuleId);
    }

    @PostMapping(value={"/hide_rule/delete"})
    public FormDesignResponse<Boolean> deleteRule(@RequestParam(value="formId") String formId, @RequestParam String ruleId) throws Exception {
        return this.settingService.deleteRule(formId, ruleId);
    }
}

