/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNUser")
public class JXDNUser
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.VARCHAR.name());
            this.put("ORACLE", OracleType.VARCHAR2.name());
        }
    };
    private Map<String, String> sysFieldType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.BIGINT.name());
            this.put("ORACLE", OracleType.LONG.name());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType) {
        String name = this.widget.getName();
        String title = WidgetTool.concatTitle(this.widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        Optional<String> userType = JsonParser.value(this.widget, "$.props.userType", String.class);
        if (userType.isPresent() && userType.get().equals("sys")) {
            fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(this.widget.getDataType()).withSourceDataType(this.sysFieldType.get(dbType)).withDataLength(20).build());
        } else {
            fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(125).build());
            fields.add(new DataModelFieldBase.Builder().withId(String.format("%s%s", name, "_id")).withName(String.format("%s%s", name, "_id")).withComment(String.format("%s%s", title, "_id")).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(20).build());
            fields.add(new DataModelFieldBase.Builder().withId(String.format("%s%s", name, "_label")).withName(String.format("%s%s", name, "_label")).withComment(String.format("%s%s", title, "_label")).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(125).build());
        }
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType) {
        return this.withField(dbType).get(0);
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("derived", String.format("%s%s", this.widget.getName(), "_label"));
    }
}

