/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.tool;

import com.jxdinfo.hussar.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class WidgetTool {
    public static final String CREATE_USER = "createUser_user";
    public static final String CREATE_NAME = "createUserName";
    public static final String UPDATE_USER = "updateUser_user";
    public static final String UPDATE_NAME = "updateUserName";
    public static final String POST = "post";
    public static final String DATA_ORGAN = "dataOrgan";
    public static final String STAFF = "staff";
    public static final String POST_NAME = "postName";
    public static final String PROCESS_INST_ID = "PROCESS_INST_ID";
    public static final String TASK_ID = "TASK_ID";
    public static final String TASK_DEF_KEY = "TASK_DEF_KEY";
    public static final String PROCESS_KEY = "PROCESS_KEY";

    public static void ofWidgetFields(List<WidgetField> widgetFields, List<Widget> widgets, Predicate<Widget> filter) {
        for (Widget widget : widgets) {
            if (filter.test(widget)) continue;
            WidgetField widgetField = new WidgetField();
            widgetField.setName(widget.getName());
            widgetField.setType(widget.getType());
            widgetField.setTitle(widget.getTitle());
            widgetField.setUsage(widget.getUsage());
            widgetField.setDataType(widget.getDataType());
            widgetField.setIsRealField(widget.getIsRealField());
            widgetField.setReadOnly(widget.isReadOnly());
            widgetField.setProps(widget.getProps());
            widgetField.setParentKey(widget.getParentKey());
            widgetFields.add(widgetField);
            if (!WidgetTool.isChildrenTable(widget)) continue;
            if (HussarUtils.isEmpty((Object)widgetField.getChildren())) {
                widgetField.setChildren(new ArrayList());
            }
            WidgetTool.ofWidgetFields(widgetField.getChildren(), widget.getChildren(), filter);
        }
    }

    public static void ofWidgetDTO(List<WidgetDTO> widgetFields, List<Widget> widgets, Predicate<Widget> filter) {
        for (Widget widget : widgets) {
            if (filter.test(widget)) continue;
            WidgetDTO widgetField = new WidgetDTO();
            widgetField.setName(widget.getName());
            widgetField.setType(widget.getType());
            widgetField.setTitle(widget.getTitle());
            widgetField.setUsage(widget.getUsage());
            widgetField.setDataType(widget.getDataType());
            widgetField.setIsRealField(widget.getIsRealField());
            widgetField.setReadOnly(widget.isReadOnly());
            widgetField.setProps(widget.getProps());
            widgetField.setParentKey(widget.getParentKey());
            widgetFields.add(widgetField);
            if (!WidgetTool.isChildrenTable(widget)) continue;
            if (HussarUtils.isEmpty((Object)widgetField.getChildren())) {
                widgetField.setChildren(new ArrayList());
            }
            WidgetTool.ofWidgetDTO(widgetField.getChildren(), widget.getChildren(), filter);
        }
    }

    public static List<Widget> settingWidgets(List<Widget> widgets, Predicate<Widget> filter) {
        ArrayList<Widget> widgetsCopy = new ArrayList<Widget>();
        CollectionUtils.addAll(widgetsCopy, (Object[])new Object[widgets.size()]);
        Collections.copy(widgetsCopy, widgets);
        widgetsCopy.removeIf(filter);
        return widgetsCopy;
    }

    public static String[] excludeFields() {
        return new String[]{CREATE_USER, UPDATE_USER, POST, DATA_ORGAN, STAFF, POST_NAME};
    }

    public static String[] showFieldsExcludeFields() {
        return new String[]{CREATE_NAME, UPDATE_NAME, POST, DATA_ORGAN, STAFF, POST_NAME, PROCESS_INST_ID, TASK_ID, TASK_DEF_KEY};
    }

    public static Optional<List<Widget>> filterWidgets(List<Widget> widgets, Predicate<Widget> filter) {
        ArrayList widgetsCopy = new ArrayList();
        CollectionUtils.addAll(widgetsCopy, (Object[])new Object[widgets.size()]);
        Collections.copy(widgetsCopy, widgets);
        List collect = widgetsCopy.stream().filter(filter).collect(Collectors.toList());
        if (HussarUtils.isEmpty(collect) && collect.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(collect);
    }

    public static boolean anyMatch(String target, String ... conditions) {
        boolean or = false;
        for (String condition : conditions) {
            or = or || target.equals(condition);
        }
        return or;
    }

    public static boolean noneMatch(String target, String ... conditions) {
        boolean or = false;
        for (String condition : conditions) {
            or = or || target.equals(condition);
        }
        return !or;
    }

    public static boolean allMatch(String target, String ... conditions) {
        boolean and = true;
        for (String condition : conditions) {
            and = and && target.equals(condition);
        }
        return and;
    }

    public static boolean isChildrenTable(Widget widget) {
        return HussarUtils.isNotEmpty(widget.getChildren()) && WidgetType.CHILDREN_TABLE.getType().equals(widget.getType());
    }

    public static String concatTitle(String title) {
        if (HussarUtils.isEmpty((Object)title) || title.length() <= 120) {
            return title;
        }
        return title.substring(0, 120);
    }

    public static ApiResponse<Boolean> isSourceExist(String appId, String formId) {
        ISysApplicationExternalService externalService = (ISysApplicationExternalService)SpringContextUtil.getBean(ISysApplicationExternalService.class);
        SysApplicationVo app = externalService.getAppDetailById(Long.valueOf(appId));
        if (HussarUtils.isEmpty((Object)app) || HussarUtils.equals((Object)"0", (Object)app.getReleaseStatus())) {
            return ApiResponse.fail((int)12021, (Object)false, (String)"\u5e94\u7528\u88ab\u5220\u9664\u6216\u5df2\u4e0b\u67b6");
        }
        SysForm form = externalService.getFormDetailById(Long.valueOf(formId));
        if (HussarUtils.isEmpty((Object)form)) {
            return ApiResponse.fail((int)12022, (Object)false, (String)"\u8868\u5355\u88ab\u5220\u9664");
        }
        ApiResponse booleanApiResponse = externalService.checkRolePermissions(Long.valueOf(formId));
        if (!((Boolean)booleanApiResponse.getData()).booleanValue()) {
            return ApiResponse.fail((int)12011, (Object)false, (String)"\u65e0\u6743\u9650\u67e5\u770b\u8868\u5355");
        }
        return ApiResponse.success((Object)true);
    }
}

