/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.mongo;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.mongo.MongoTemplateCache;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnMongo;
import com.mongodb.BasicDBObject;
import org.bson.Document;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service(value="no.code.setting")
@Conditional(value={NoCodeConditionOnMongo.class})
public class SettingMongoImpl
implements SettingSchemaService<FormSettingSchema> {
    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormSettingSchema schema, String formId) throws JsonProcessingException {
        MongoTemplate template = MongoTemplateCache.get();
        template.getConverter().write((Object)schema, (Object)new BasicDBObject());
        Update update = Update.fromDocument((Document)Document.parse((String)JSON.toJSONString((Object)((Object)schema))), (String[])new String[0]);
        template.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)formId)), update, FormSettingSchema.class);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<FormSettingSchema> get(String formId) {
        MongoTemplate template = MongoTemplateCache.get();
        return FormDesignResponse.success((Object)template.findById((Object)formId, FormSettingSchema.class));
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        MongoTemplate template = MongoTemplateCache.get();
        template.remove((Object)Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)formId)));
        return FormDesignResponse.success((Object)true);
    }
}

