/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.mongo;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.mongo.MongoTemplateCache;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnMongo;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.DeleteResult;
import org.bson.Document;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnMongo.class})
public class CanvasSchemaMongoImpl
implements CanvasSchemaService {
    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormCanvasSchema schema) {
        MongoTemplate template = MongoTemplateCache.get();
        BasicDBObject dbObject = new BasicDBObject();
        template.getConverter().write((Object)schema, (Object)dbObject);
        Update update = Update.fromDocument((Document)Document.parse((String)JSON.toJSONString((Object)((Object)schema))), (String[])new String[0]);
        template.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)schema.getId())), update, FormCanvasSchema.class);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId) {
        MongoTemplate template = MongoTemplateCache.get();
        return FormDesignResponse.success((Object)template.findById((Object)formId, FormCanvasSchema.class), (String)"");
    }

    @Override
    public FormIndexMeta getMeta(String formId) {
        MongoTemplate template = MongoTemplateCache.get();
        return (FormIndexMeta)template.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)formId)), FormIndexMeta.class);
    }

    @Override
    public FormDesignResponse<Boolean> updateMeta(FormIndexMeta meta) {
        return null;
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        MongoTemplate template = MongoTemplateCache.get();
        DeleteResult id = template.remove((Object)Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)formId)));
        return FormDesignResponse.success((Object)true);
    }
}

