/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.mysql.cj.MysqlType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNLinkForm")
public class JXDNLinkForm
extends JXDNWidgetDefault {
    @Resource
    private FormOperateService formOperateService;
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.VARCHAR.name());
            this.put("ORACLE", OracleType.VARCHAR2.name());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField() {
        String name = this.widget.getName();
        String title = this.widget.getTitle();
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        DataModelFieldBase linkWidgetField = this.getLinkWidget().getLabelField();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(linkWidgetField.getDataType()).withSourceDataType(linkWidgetField.getSourceDataType()).build());
        String dbType = DataModelUtil.getDataSourceTypeByName((String)DataModelUtil.currentDsName());
        fields.add(new DataModelFieldBase.Builder().withId(String.format("%s%s", name, "_ref_id")).withName(String.format("%s%s", name, "_ref_id")).withComment("\u5f15\u7528\u6570\u636e\u4e3b\u952e").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        return fields;
    }

    @Override
    public int getLength() throws IOException {
        return this.getLinkWidget().getLength();
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        this.getLinkWidget().wrapTitle(title, currentParam);
    }

    private Widget getLinkWidget() {
        FormSchema formSchema;
        String nowAppId = AppContextUtil.getAppId();
        String appId = JsonParser.value(this.widget, "$.props.linkTableInfo.appId", String.class, nowAppId);
        String formId = JsonParser.value(this.widget, "$.props.linkTableInfo.formId", String.class, "");
        String name = JsonParser.value(this.widget, "$.props.linkTableInfo.linkFieldInfo.name", String.class, "");
        if (HussarUtils.isEmpty((Object)appId) || HussarUtils.isEmpty((Object)formId) || HussarUtils.isEmpty((Object)name)) {
            throw new RuntimeException("\u5173\u8054\u8868\u5355\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
        }
        AppContextUtil.setAppId((String)appId);
        try {
            formSchema = (FormSchema)this.formOperateService.get(formId).getData();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (HussarUtils.isEmpty((Object)formSchema) || HussarUtils.isEmpty((Object)((Object)formSchema.getFormCanvas()))) {
            throw new RuntimeException("\u5173\u8054\u8868\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        FormCanvasSchema linkForm = formSchema.getFormCanvas();
        AppContextUtil.setAppId((String)nowAppId);
        List<Widget> widgets = linkForm.widgetsWithSys();
        Optional<Widget> first = widgets.stream().filter(v -> v.getName().equals(name)).findFirst();
        if (!first.isPresent()) {
            throw new RuntimeException("\u5173\u8054\u8868\u5355\u7ec4\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        return first.get().newInstance(formSchema);
    }
}

