/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.tool;

import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class WidgetTool {
    private static final String CREATE_USER = "createUser_user";
    private static final String CREATE_NAME = "createUserName";
    private static final String UPDATE_USER = "updateUser_user";
    private static final String UPDATE_NAME = "updateUserName";
    private static final String POST = "post";
    private static final String DATA_ORGAN = "dataOrgan";
    private static final String STAFF = "staff";
    private static final String POST_NAME = "postName";
    private static final String PROCESS_INST_ID = "PROCESS_INST_ID";
    private static final String TASK_ID = "TASK_ID";
    private static final String TASK_DEF_KEY = "TASK_DEF_KEY";

    public static void ofWidgetFields(List<WidgetField> widgetFields, List<Widget> widgets, Predicate<Widget> filter) {
        for (Widget widget : widgets) {
            if (filter.test(widget)) continue;
            WidgetField widgetField = new WidgetField();
            widgetField.setName(widget.getName());
            widgetField.setType(widget.getType());
            widgetField.setTitle(widget.getTitle());
            widgetField.setUsage(widget.getUsage());
            widgetField.setDataType(widget.getDataType());
            widgetField.setIsRealField(widget.getIsRealField());
            widgetField.setProps(widget.getProps());
            widgetFields.add(widgetField);
            if (!WidgetTool.isChildrenTable(widget)) continue;
            if (HussarUtils.isEmpty((Object)widgetField.getChildren())) {
                widgetField.setChildren(new ArrayList());
            }
            WidgetTool.ofWidgetFields(widgetField.getChildren(), widget.getChildren(), filter);
        }
    }

    public static List<Widget> settingWidgets(List<Widget> widgets) {
        ArrayList<Widget> widgetsCopy = new ArrayList<Widget>();
        CollectionUtils.addAll(widgetsCopy, (Object[])new Object[widgets.size()]);
        Collections.copy(widgetsCopy, widgets);
        widgetsCopy.removeIf(widget -> widget.getIsRealField() && WidgetTool.anyMatch(widget.getType(), WidgetType.IMAGE.getType(), WidgetType.FILE.getType()) || !widget.getIsRealField() && WidgetTool.anyMatch(widget.getName(), WidgetTool.excludeFields()));
        return widgetsCopy;
    }

    public static String[] excludeFields() {
        return new String[]{CREATE_USER, UPDATE_USER, POST, DATA_ORGAN, STAFF, POST_NAME};
    }

    public static String[] columnsExcludeFields() {
        return new String[]{CREATE_USER, UPDATE_USER, POST, DATA_ORGAN, STAFF, PROCESS_INST_ID, TASK_ID, TASK_DEF_KEY};
    }

    public static String[] showFieldsExcludeFields() {
        return new String[]{CREATE_USER, CREATE_NAME, UPDATE_USER, UPDATE_NAME, POST, DATA_ORGAN, STAFF, POST_NAME, PROCESS_INST_ID, TASK_ID, TASK_DEF_KEY};
    }

    public static Optional<List<Widget>> filterWidgets(List<Widget> widgets, Predicate<Widget> filter) {
        ArrayList widgetsCopy = new ArrayList();
        CollectionUtils.addAll(widgetsCopy, (Object[])new Object[widgets.size()]);
        Collections.copy(widgetsCopy, widgets);
        List collect = widgetsCopy.stream().filter(filter).collect(Collectors.toList());
        if (HussarUtils.isEmpty(collect) && collect.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(collect);
    }

    public static boolean anyMatch(String target, String ... conditions) {
        boolean or = false;
        for (String condition : conditions) {
            or = or || target.equals(condition);
        }
        return or;
    }

    public static boolean noneMatch(String target, String ... conditions) {
        boolean or = false;
        for (String condition : conditions) {
            or = or || target.equals(condition);
        }
        return !or;
    }

    public static boolean allMatch(String target, String ... conditions) {
        boolean and = true;
        for (String condition : conditions) {
            and = and && target.equals(condition);
        }
        return and;
    }

    public static boolean isChildrenTable(Widget widget) {
        return HussarUtils.isNotEmpty(widget.getChildren()) && WidgetType.CHILDREN_TABLE.getType().equals(widget.getType());
    }
}

