/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.factory;

import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ModelBuilderFactory
implements InitializingBean,
ApplicationContextAware {
    private static final ConcurrentHashMap<String, DataModelBuilder> STRATEGY = new ConcurrentHashMap();
    private ApplicationContext context;

    public static DataModelBuilder strategy(String strategy) {
        if (!STRATEGY.containsKey(strategy)) {
            throw new IllegalArgumentException("\u6a21\u578b\u7b56\u7565\u4e0d\u5b58\u5728\uff1a" + strategy);
        }
        return STRATEGY.get(strategy);
    }

    public void afterPropertiesSet() {
        this.context.getBeansOfType(DataModelBuilder.class).values().forEach(strategy -> STRATEGY.put(strategy.strategy(), (DataModelBuilder)strategy));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

