/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="no.code.setting")
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class SettingStorageImpl
implements SettingSchemaService<FormSettingSchema> {
    public static final String SETTING_PATH = "setting";
    public static final String SETTING_SUFFIX = ".setting";
    @Resource
    private StorageService storage;
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormSettingSchema schema, String formId) throws JsonProcessingException {
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)response.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        String path = FileUtil.posixPath((String[])new String[]{canvasSchema.getName(), SETTING_PATH, canvasSchema.getName() + SETTING_SUFFIX});
        String metaPath = path + ".meta";
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String settingId = formIndexMeta.getSettingId();
        StorageResult setJsonRes = this.storage.uploadByUuid(CategoryEnum.JSON, settingId, path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)schema).getBytes(StandardCharsets.UTF_8), false);
        FormIndexMeta setMeta = new FormIndexMeta();
        setMeta.setId(settingId);
        setMeta.setPath(metaPath);
        StorageResult setMetaRes = this.storage.uploadByUuid(CategoryEnum.META, settingId, metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)setMeta).getBytes(StandardCharsets.UTF_8), false);
        if (setJsonRes.isSuccess() && setMetaRes.isSuccess()) {
            return FormDesignResponse.success((Object)true);
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> Storage\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<FormSettingSchema> get(String formId) {
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String settingId = formIndexMeta.getSettingId();
        if (HussarUtils.isEmpty((Object)settingId)) {
            return FormDesignResponse.success(null);
        }
        StorageResult storageResult = this.storage.downloadByUuid(CategoryEnum.JSON, settingId);
        if (storageResult.isSuccess()) {
            return FormDesignResponse.success((Object)JSON.parseObject((byte[])((byte[])storageResult.getData()), FormSettingSchema.class, (Feature[])new Feature[0]));
        }
        return FormDesignResponse.success(null);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String settingId = formIndexMeta.getSettingId();
        if (HussarUtils.isEmpty((Object)settingId)) {
            return FormDesignResponse.success((Object)true);
        }
        StorageResult json = this.storage.deleteByUuid(CategoryEnum.JSON, settingId, false);
        StorageResult meta = this.storage.deleteByUuid(CategoryEnum.META, settingId, false);
        if (json.isSuccess() && meta.isSuccess()) {
            return FormDesignResponse.success((Object)true);
        }
        ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u8868\u5355\u8bbe\u7f6e ==> Storage\u5220\u9664\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u5220\u9664\u8868\u5355\u8bbe\u7f6e ==> Storage\u5220\u9664\u5931\u8d25");
    }
}

