/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class CanvasSchemaStorageImpl
implements CanvasSchemaService {
    public static final String CANVAS_PATH = "canvas";
    public static final String CANVAS_SUFFIX = ".fd";
    @Resource
    private StorageService storage;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormCanvasSchema schema) throws JsonProcessingException {
        String path = FileUtil.posixPath((String[])new String[]{schema.getName(), CANVAS_PATH, schema.getName() + CANVAS_SUFFIX});
        StorageResult jsonRes = this.storage.uploadByUuid(CategoryEnum.JSON, schema.getId(), path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)schema).getBytes(StandardCharsets.UTF_8), true);
        FormIndexMeta indexMeta = this.getMeta(schema.getId());
        if (HussarUtils.isEmpty((Object)indexMeta)) {
            indexMeta = new FormIndexMeta();
        }
        indexMeta.setId(schema.getId());
        if (HussarUtils.isEmpty((Object)indexMeta.getViewId())) {
            indexMeta.setViewId(RandomUtil.randomString((int)schema.getId().length()));
        }
        if (HussarUtils.isEmpty((Object)indexMeta.getSettingId())) {
            indexMeta.setSettingId(RandomUtil.randomString((int)schema.getId().length()));
        }
        indexMeta.setPath(path + ".meta");
        FormDesignResponse<Boolean> metaRes = this.updateMeta(indexMeta);
        if (jsonRes.isSuccess() && ((Boolean)metaRes.getData()).booleanValue()) {
            return FormDesignResponse.success((Object)true, (String)"");
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> Storage\u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)schema.getId());
        return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> Storage\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId) {
        StorageResult storageResult = this.storage.downloadByUuid(CategoryEnum.JSON, formId);
        if (storageResult.isSuccess()) {
            return FormDesignResponse.success((Object)JSON.parseObject((byte[])((byte[])storageResult.getData()), FormCanvasSchema.class, (Feature[])new Feature[0]), (String)"");
        }
        ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u753b\u5e03 ==> Storage\u83b7\u53d6\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u753b\u5e03 ==> Storage\u83b7\u53d6\u5931\u8d25");
    }

    @Override
    public FormIndexMeta getMeta(String formId) {
        StorageResult metaRes = this.storage.downloadByUuid(CategoryEnum.META, formId);
        if (!metaRes.isSuccess()) {
            return new FormIndexMeta();
        }
        if (HussarUtils.isEmpty((Object)metaRes.getData())) {
            return new FormIndexMeta();
        }
        return (FormIndexMeta)JSON.parseObject((byte[])((byte[])metaRes.getData()), FormIndexMeta.class, (Feature[])new Feature[0]);
    }

    @Override
    public FormDesignResponse<Boolean> updateMeta(FormIndexMeta meta) throws JsonProcessingException {
        StorageResult metaRes = this.storage.uploadByUuid(CategoryEnum.META, meta.getId(), meta.getPath(), new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)meta).getBytes(StandardCharsets.UTF_8), true);
        if (!((Boolean)metaRes.getData()).booleanValue()) {
            return FormDesignResponse.fail((Object)false, (String)"\u66f4\u65b0\u8868\u5355meta\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        StorageResult jsonRes = this.storage.deleteByUuid(CategoryEnum.JSON, formId, false);
        StorageResult metaRes = this.storage.deleteByUuid(CategoryEnum.META, formId, false);
        if (jsonRes.isSuccess() && metaRes.isSuccess()) {
            return FormDesignResponse.success((Object)true, (String)"");
        }
        ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u8868\u5355\u753b\u5e03 ==> Storage\u5220\u9664\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u5220\u9664\u8868\u5355\u753b\u5e03 ==> Storage\u5220\u9664\u5931\u8d25");
    }
}

