/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.SummarySchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class CanvasServiceImpl
implements CanvasService {
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private ISysApplicationExternalService appExternalService;

    @Override
    @HussarTransactional
    public FormDesignResponse<Boolean> saveCanvas(FormCanvasSchema newCanvas) throws Exception {
        FormCanvasSchema oldCanvas = (FormCanvasSchema)((Object)this.canvasSchemaService.get(newCanvas.getId()).getData());
        if (HussarUtils.isEmpty((Object)((Object)oldCanvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u4fe1\u606f\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)newCanvas.getId());
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u4fe1\u606f\u5931\u8d25");
        }
        if (HussarUtils.isNotEmpty((Object)oldCanvas.getId()) && newCanvas.getVersion() <= oldCanvas.getVersion()) {
            ToolUtil.getLogger(this.getClass()).error("\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u52ff\u591a\u7a97\u53e3\u7f16\u8f91\u6216\u8005\u591a\u4eba\u540c\u65f6\u7f16\u8f91\uff0c\u8bf7\u5237\u65b0\u6d4f\u89c8\u5668\u91cd\u8bd5\uff01 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)newCanvas.getId());
            return FormDesignResponse.fail((Object)false, (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u52ff\u591a\u7a97\u53e3\u7f16\u8f91\u6216\u8005\u591a\u4eba\u540c\u65f6\u7f16\u8f91\uff0c\u8bf7\u5237\u65b0\u6d4f\u89c8\u5668\u91cd\u8bd5\uff01");
        }
        FormSchema newFormSchema = new FormSchema.Builder().formPage(newCanvas).build();
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder(newFormSchema);
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        DataModelBase dataModelBase = builder.direct();
        noCodeModelHandler.updateTable(dataModelBase, builder.updateContrast());
        this.saveOrUpdate(newCanvas, oldCanvas);
        this.formOperateService.publish(newCanvas.getId());
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId) throws JsonProcessingException {
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvasSchema))) {
            return FormDesignResponse.success((Object)((Object)new FormCanvasSchema()));
        }
        canvasSchema.setTitle(this.appExternalService.getFormDetailById(Long.valueOf(formId)).getFormName());
        this.canvasSchemaService.saveOrUpdate(canvasSchema);
        return FormDesignResponse.success((Object)((Object)canvasSchema));
    }

    private void saveOrUpdate(FormCanvasSchema newCanvas, FormCanvasSchema oldCanvas) throws Exception {
        FormDesignResponse<Boolean> summaryRes;
        FormDesignResponse<Boolean> fieldControlRes;
        FormDesignResponse<Boolean> viewRes;
        FormDesignResponse<Boolean> updateForm = this.canvasSchemaService.saveOrUpdate(newCanvas);
        String formId = newCanvas.getId();
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u66f4\u65b0\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        }
        if (!((Boolean)(viewRes = this.updateView(newCanvas, oldCanvas)).getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u66f4\u65b0\u89c6\u56fe\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        }
        if (!((Boolean)(fieldControlRes = this.updateFieldControl(newCanvas)).getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u66f4\u65b0\u5b57\u6bb5\u63a7\u5236\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        }
        if (!((Boolean)(summaryRes = this.updateDataSummary(newCanvas)).getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u66f4\u65b0\u6570\u636e\u6458\u8981\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        }
    }

    private FormDesignResponse<Boolean> updateView(FormCanvasSchema newCanvas, FormCanvasSchema oldCanvas) throws Exception {
        FormViewSchema viewSchema = (FormViewSchema)this.viewSchemaService.get(newCanvas.getId()).getData();
        if (HussarUtils.isEmpty((Object)viewSchema)) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> \u89c6\u56fe\u4e3a\u7a7a\u5bfc\u81f4\u7ea7\u8054\u66f4\u65b0\u89c6\u56fe\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)newCanvas.getId());
        }
        List<Widget> newWidgets = newCanvas.widgetsWithSys();
        List<Widget> oldWidgets = oldCanvas.widgetsWithSys();
        oldWidgets.removeIf(widget -> WidgetTool.anyMatch(widget.getName(), WidgetTool.showFieldsExcludeFields()));
        newWidgets.removeIf(widget -> WidgetTool.anyMatch(widget.getName(), WidgetTool.showFieldsExcludeFields()));
        Changes changes = this.getChanges(oldWidgets, newWidgets);
        changes.setOrders(newCanvas.widgets().stream().map(Widget::getName).collect(Collectors.toList()));
        changes.setOldWidgets(oldCanvas.widgets());
        this.updateShowFields(viewSchema.getViews(), changes, newCanvas.getFormType());
        return this.viewSchemaService.saveOrUpdate(viewSchema);
    }

    private FormDesignResponse<Boolean> updateFieldControl(FormCanvasSchema canvas) throws Exception {
        List<Widget> widgets = canvas.widgets();
        widgets.addAll(canvas.childTables());
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class);
        FormDesignResponse fieldControlResponse = settingSchemaService.get(canvas.getId());
        FieldControlSchema fieldControlSchema = (FieldControlSchema)fieldControlResponse.getData();
        fieldControlSchema = HussarUtils.isEmpty((Object)fieldControlSchema) ? new FieldControlSchema() : fieldControlSchema;
        ArrayList<FieldControl> add = HussarUtils.isEmpty((Object)fieldControlSchema.getAdd()) ? new ArrayList() : fieldControlSchema.getAdd();
        ArrayList<FieldControl> edit = HussarUtils.isEmpty((Object)fieldControlSchema.getEdit()) ? new ArrayList() : fieldControlSchema.getEdit();
        this.getFieldControl(widgets, add);
        this.getFieldControl(widgets, edit);
        List<String> orders = canvas.widgetsWithChildren().stream().map(Widget::getName).collect(Collectors.toList());
        this.sortFieldControl(add, orders);
        this.sortFieldControl(edit, orders);
        fieldControlSchema.setAdd(add);
        fieldControlSchema.setEdit(edit);
        return settingSchemaService.saveOrUpdate(fieldControlSchema, canvas.getId());
    }

    private void sortFieldControl(List<FieldControl> fieldControls, List<String> orders) {
        fieldControls.sort((o1, o2) -> {
            int io1 = orders.indexOf(o1.getField());
            int io2 = orders.indexOf(o2.getField());
            return io1 == -1 || io2 == -1 ? 0 : io1 - io2;
        });
    }

    private FormDesignResponse<Boolean> updateDataSummary(FormCanvasSchema canvas) throws Exception {
        List<Widget> newWidgets = canvas.widgetsWithSys();
        newWidgets.removeIf(widget -> WidgetTool.anyMatch(widget.getName(), WidgetTool.excludeFields()));
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.summary", SettingSchemaService.class);
        SummarySchema summarySchema = (SummarySchema)((Object)settingSchemaService.get(canvas.getId()).getData());
        summarySchema = HussarUtils.isEmpty((Object)((Object)summarySchema)) ? new SummarySchema() : summarySchema;
        List<String> dataSummary = summarySchema.getDataSummary();
        this.getDataSummary(newWidgets, dataSummary);
        return settingSchemaService.saveOrUpdate(summarySchema, canvas.getId());
    }

    private Changes getChanges(List<Widget> old, List<Widget> news) {
        ArrayList<Widget> newWidgets = new ArrayList<Widget>();
        ArrayList<Widget> delWidgets = new ArrayList<Widget>();
        CollectionUtils.addAll(delWidgets, (Object[])new Object[old.size()]);
        Collections.copy(delWidgets, old);
        news.forEach(widget -> {
            boolean noRepeat = true;
            for (Widget column : old) {
                if (!column.getName().equals(widget.getName())) continue;
                noRepeat = false;
                delWidgets.remove(column);
                break;
            }
            if (noRepeat) {
                newWidgets.add((Widget)widget);
            }
        });
        old.replaceAll(column -> news.stream().filter(override -> override.getName().equals(column.getName())).findFirst().orElse((Widget)column));
        return new Changes(newWidgets, delWidgets);
    }

    private void updateShowFields(List<DataView> views, Changes changes, String formType) {
        List<Widget> delWidgets = changes.getDelWidgets();
        List<Widget> newWidgets = changes.getNewWidgets();
        if (HussarUtils.isNotEmpty(newWidgets)) {
            List<ShowField> showFields = CanvasServiceImpl.showFields(newWidgets, widgetName -> newWidgets.stream().map(Widget::getName).anyMatch(newName -> newName.equals(widgetName)));
            views.forEach(dataView -> {
                if ("1".equals(formType)) {
                    if (dataView.getTabType().equals("0")) {
                        dataView.getShowFields().addAll(changes.getOldWidgets().size() + 3, showFields);
                    }
                    if (dataView.getTabType().equals("2")) {
                        dataView.getShowFields().addAll(changes.getOldWidgets().size() + 4, showFields);
                    }
                    if (dataView.getTabType().equals("1")) {
                        dataView.getShowFields().addAll(changes.getOldWidgets().size() + 6, showFields);
                    }
                    if (dataView.getTabType().equals("3")) {
                        dataView.getShowFields().addAll(changes.getOldWidgets().size() + 1, showFields);
                    }
                } else if ("0".equals(formType)) {
                    dataView.getShowFields().addAll(changes.getOldWidgets().size() + 1, showFields);
                }
            });
        }
        if (HussarUtils.isNotEmpty(delWidgets)) {
            for (DataView view : views) {
                for (Widget delWidget : delWidgets) {
                    view.getShowFields().removeIf(showField -> delWidget.getName().equals(showField.getName()));
                }
            }
        }
        this.showFieldDeduplicate(views);
        this.sortViews(views, changes.getOrders());
    }

    private void showFieldDeduplicate(List<DataView> views) {
        for (DataView view : views) {
            ArrayList<ShowField> newShowFields = new ArrayList<ShowField>();
            for (ShowField outterShowField : view.getShowFields()) {
                boolean repeat = false;
                for (ShowField innerShowField : newShowFields) {
                    if (!innerShowField.getName().equals(outterShowField.getName())) continue;
                    repeat = true;
                    break;
                }
                if (repeat) continue;
                newShowFields.add(outterShowField);
            }
            view.setShowFields(newShowFields);
        }
    }

    private void sortViews(List<DataView> views, List<String> orders) {
        for (DataView view : views) {
            view.getShowFields().sort((o1, o2) -> {
                int io1 = orders.indexOf(o1.getName());
                int io2 = orders.indexOf(o2.getName());
                return io1 == -1 || io2 == -1 ? 0 : io1 - io2;
            });
        }
    }

    private static List<ShowField> showFields(List<Widget> widgets, Predicate<String> predicate) {
        ArrayList<ShowField> newShowFields = new ArrayList<ShowField>();
        for (Widget widget : widgets) {
            ShowField showField = new ShowField();
            showField.setChecked(predicate.test(widget.getName()));
            showField.setName(widget.getName());
            showField.setAlign("center");
            showField.setWidth(68 + widget.getTitle().length() * 14);
            showField.setIsMinWidth(true);
            newShowFields.add(showField);
        }
        return newShowFields;
    }

    private void getDataSummary(List<Widget> newWidgets, List<String> dataSummary) {
        if (HussarUtils.isEmpty(dataSummary)) {
            return;
        }
        ArrayList delSummary = new ArrayList();
        CollectionUtils.addAll(delSummary, (Object[])new Object[dataSummary.size()]);
        Collections.copy(delSummary, dataSummary);
        block0: for (Widget newWidget : newWidgets) {
            for (String summary : dataSummary) {
                if (!summary.equals(newWidget.getName())) continue;
                delSummary.remove(summary);
                continue block0;
            }
        }
        if (HussarUtils.isNotEmpty(delSummary)) {
            dataSummary.removeAll(delSummary);
        }
    }

    private void getFieldControl(List<Widget> widgets, List<FieldControl> addOrEdit) {
        ArrayList delControls = new ArrayList();
        CollectionUtils.addAll(delControls, (Object[])new Object[addOrEdit.size()]);
        Collections.copy(delControls, addOrEdit);
        for (Widget widget : widgets) {
            boolean isRepeat = false;
            for (FieldControl control : addOrEdit) {
                if (!control.getField().equals(widget.getName())) continue;
                control.setTitle(widget.getTitle());
                isRepeat = true;
                delControls.remove(control);
                if (!WidgetTool.isChildrenTable(widget)) break;
                if (HussarUtils.isEmpty((Object)control.getChildren())) {
                    control.setChildren(new ArrayList());
                }
                this.getFieldControl(widget.getChildren(), control.getChildren());
                break;
            }
            if (isRepeat) continue;
            FieldControl control = new FieldControl();
            control.setField(widget.getName());
            control.setType(widget.getType());
            control.setTitle(widget.getTitle());
            control.setVisible(true);
            control.setWitable(true);
            control.setRequired(false);
            if (WidgetTool.isChildrenTable(widget)) {
                control.setChildren(new ArrayList());
                this.getFieldControl(widget.getChildren(), control.getChildren());
            }
            addOrEdit.add(control);
        }
        if (HussarUtils.isNotEmpty(delControls)) {
            addOrEdit.removeAll(delControls);
        }
    }

    public static class Changes {
        List<Widget> newWidgets;
        List<Widget> oldWidgets;
        List<Widget> delWidgets;
        List<String> orders;

        public Changes(List<Widget> newWidgets, List<Widget> delWidgets) {
            this.newWidgets = newWidgets;
            this.delWidgets = delWidgets;
        }

        public List<Widget> getOldWidgets() {
            return this.oldWidgets;
        }

        public void setOldWidgets(List<Widget> oldWidgets) {
            this.oldWidgets = oldWidgets;
        }

        public List<Widget> getNewWidgets() {
            return this.newWidgets;
        }

        public List<Widget> getDelWidgets() {
            return this.delWidgets;
        }

        public List<String> getOrders() {
            return this.orders;
        }

        public void setOrders(List<String> orders) {
            this.orders = orders;
        }
    }
}

