/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.controller;

import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.DataFilterType;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.UpgradeService;
import com.jxdinfo.hussar.formdesign.no.code.model.flow.FlowFormVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/form"})
public class FormController {
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private UpgradeService upgradeService;

    @GetMapping(value={"widgets"})
    public FormDesignResponse<List<WidgetField>> widgets(@RequestParam String formId, @RequestParam(required=false, defaultValue="true") boolean isFlow) {
        return this.formOperateService.widgetsForFlow(formId, isFlow);
    }

    @GetMapping(value={"widgetsForUser"})
    public FormDesignResponse<List<WidgetField>> widgetsForUser(@RequestParam String formId, @RequestParam(required=false) String appId) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        return this.formOperateService.widgetsForSetting(formId);
    }

    @PostMapping
    public ApiResponse<Boolean> create(@RequestBody BaseForm baseForm, @RequestParam String appId) throws Exception {
        return this.formOperateExposedService.create(baseForm, appId);
    }

    @PostMapping(value={"delete"})
    public ApiResponse<Boolean> delete(@RequestParam String formId, @RequestParam String appId) throws Exception {
        return this.formOperateExposedService.delete(formId, appId);
    }

    @PostMapping(value={"deleteApp"})
    public ApiResponse<Boolean> deleteApp(@RequestParam String appId) {
        return this.formOperateExposedService.appClean(appId, new ArrayList());
    }

    @GetMapping(value={"filters"})
    public ApiResponse<List<DataFilterType>> filters(@RequestParam String widget) {
        return this.formOperateExposedService.filters(widget);
    }

    @GetMapping(value={"info"})
    public FormDesignResponse<FlowFormVO> info(@RequestParam String formId) throws Exception {
        return this.formOperateService.info(formId);
    }

    @PostMapping(value={"upgrade"})
    public ApiResponse<String> upgrade(@RequestParam String type, @RequestParam String appId, @RequestParam String targetApp) throws Exception {
        List<String> appIds = Arrays.asList(appId.split(","));
        return this.upgradeService.execute(type, appIds, targetApp);
    }
}

