/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.DataFilterType;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FormDetailVO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FormVerifyVO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.FormCanvasSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.FieldControlUnitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.HideRuleSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.FormViewSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.StaffScopeService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.constant.FilterType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.FormCleaner;
import com.jxdinfo.hussar.formdesign.no.code.cured.ReferenceService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.ResourceReference;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FormOperateExposedImpl
implements FormOperateExposedService {
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private ViewService viewService;
    @Resource
    private SettingService settingService;
    @Resource
    private FormOperateService formOperate;
    @Resource
    private FormCleaner formCleaner;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private ISysApplicationExternalService externalService;
    @Resource
    private StaffScopeService staffScopeService;
    @Resource
    private ReferenceService referenceService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormOperateExposedImpl.class);
    private static final String BASE_FORM = "0";
    private static final String FLOW_FORM = "1";

    @HussarTransactional
    public ApiResponse<Boolean> create(BaseForm baseForm, String appId) throws Exception {
        String formId = baseForm.getId();
        AppContextUtil.setAppId((String)appId);
        FormCanvasSchema canvas = this.initCanvas(baseForm);
        FormSchema formSchema = new FormSchema.Builder().formPage(canvas).build();
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder(formSchema);
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        DataModelBase dataModelBase = builder.direct();
        noCodeModelHandler.updateTable(dataModelBase, builder.createContrast());
        FormViewSchema view = this.initView(canvas);
        FormSettingSchema setting = this.initSetting(formId);
        this.canvasSchemaService.saveOrUpdate(canvas);
        this.viewSchemaService.saveOrUpdate(view);
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
        settingSchemaService.saveOrUpdate(setting, formId);
        this.formOperate.publish(formId);
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional
    public ApiResponse<Boolean> delete(String formId, String appId) throws Exception {
        AppContextUtil.setAppId((String)appId);
        this.formOperate.delete(formId);
        FormDesignResponse<Boolean> response = this.formCleaner.formClean(formId);
        if (((Boolean)response.getData()).booleanValue()) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.fail((String)response.getErrorMsg());
    }

    @HussarTransactional
    public ApiResponse<Boolean> appClean(String appId, List<String> formIds) {
        FormDesignResponse<Boolean> response;
        AppContextUtil.setAppId((String)appId);
        ApiResponse formRes = this.externalService.getFormListByAppId(Long.valueOf(appId));
        if (HussarUtils.isEmpty((Object)formRes.getData())) {
            return ApiResponse.success((Object)true);
        }
        List haveGroupList = ((SysSiftGroupList)formRes.getData()).getHaveGroupList();
        List noGroupList = ((SysSiftGroupList)formRes.getData()).getNoGroupList();
        ArrayList forms = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)haveGroupList)) {
            for (SysFormGroupVo sysFormGroupVo : haveGroupList) {
                List sysFormList = sysFormGroupVo.getSysFormList();
                if (!HussarUtils.isNotEmpty((Object)sysFormList)) continue;
                sysFormList.forEach(sysForm -> forms.add(String.valueOf(sysForm.getId())));
            }
        }
        if (HussarUtils.isNotEmpty((Object)noGroupList)) {
            noGroupList.forEach(sysForm -> forms.add(String.valueOf(sysForm.getId())));
        }
        if (HussarUtils.isNotEmpty(forms)) {
            forms.forEach(id -> {
                try {
                    this.formOperate.delete((String)id);
                }
                catch (Exception e) {
                    LOGGER.error("\u5220\u9664\u89e3\u6790\u5f15\u64ce\u6570\u636e\u5f02\u5e38\uff1a{}", id);
                }
            });
        }
        if (((Boolean)(response = this.formCleaner.appClean()).getData()).booleanValue()) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5e94\u7528\u8d44\u6e90\u5931\u8d25");
    }

    public ApiResponse<List<DataFilterType>> filters(String widget) {
        ArrayList<DataFilterType> types = new ArrayList<DataFilterType>();
        if (HussarUtils.isEmpty((Object)widget)) {
            for (FilterType value : FilterType.values()) {
                DataFilterType type = new DataFilterType();
                type.setWidget(value.getWidgetType());
                type.setFilterTypes(value.getFilterTypes());
                types.add(type);
            }
            return ApiResponse.success(types);
        }
        DataFilterType type = new DataFilterType();
        type.setWidget(widget);
        type.setFilterTypes(FilterType.getFilters(widget));
        return ApiResponse.success(Collections.singletonList(type));
    }

    public ApiResponse<FieldControlSchema> fieldControllers(String formId, String appId) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        FormDesignResponse fieldControlResponse = ((SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class)).get(formId);
        return ApiResponse.success((Object)fieldControlResponse.getData());
    }

    public ApiResponse<List<WidgetField>> widgets(String formId, String appId) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        FormDesignResponse<List<WidgetField>> formDesignResponse = this.formOperate.widgetsForAuth(formId);
        ApiResponse response = new ApiResponse();
        response.setCode(formDesignResponse.getErrorCode());
        response.setMsg(formDesignResponse.getErrorMsg());
        response.setData(formDesignResponse.getData());
        return response;
    }

    public FormCanvasSchema initCanvas(BaseForm baseForm) {
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)JSON.parseObject((String)JSON.toJSONString((Object)baseForm), FormCanvasSchema.class));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("formLayout", "fixed");
        props.put("formWidth", 1000);
        props.put("fieldLayout", 0);
        props.put("labelAlign", "left");
        props.put("labelWidth", 84);
        canvas.setProps(props);
        canvas.setIsDetails(BASE_FORM);
        return canvas;
    }

    public FormViewSchema initView(FormCanvasSchema canvas) {
        FormViewSchema view = new FormViewSchema();
        if (BASE_FORM.equals(canvas.getFormType())) {
            view = (FormViewSchema)JSON.parseObject((String)ToolUtil.loadResource(this.getClass(), (String)"/default_view_schema.json"), FormViewSchema.class);
        }
        if (FLOW_FORM.equals(canvas.getFormType())) {
            view = (FormViewSchema)JSON.parseObject((String)ToolUtil.loadResource(this.getClass(), (String)"/default_flow_view_schema.json"), FormViewSchema.class);
        }
        this.common(canvas, view);
        return view;
    }

    public FormSettingSchema initSetting(String formId) {
        FormSettingSchema setting = (FormSettingSchema)((Object)JSON.parseObject((String)ToolUtil.loadResource(this.getClass(), (String)"/default_setting_schema.json"), FormSettingSchema.class));
        setting.setFormId(formId);
        return setting;
    }

    private void common(FormCanvasSchema canvas, FormViewSchema view) {
        view.setAppId(AppContextUtil.getAppId());
        view.setFormId(canvas.getId());
        view.setFormName(canvas.getName());
        view.setFormTitle(canvas.getTitle());
        view.setFormType(canvas.getFormType());
        view.setFormIcon(canvas.getIcon());
    }

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String formName = ((FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData())).getName();
        String url = FileUtil.posixPath((String[])new String[]{appId, formName, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }

    public ResponseEntity<ApiResponse<Object>> queryBusinessData(String formId, String appId, Map<String, Object> params) {
        if (!((Boolean)WidgetTool.isSourceExist(appId, formId).getData()).booleanValue()) {
            ApiResponse objectApiResponse = new ApiResponse();
            objectApiResponse.setData(null);
            return ResponseEntity.of(Optional.of(objectApiResponse));
        }
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TableQuery");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> queryReferTable(String formId, String appId, Map<String, Object> params) {
        if (!((Boolean)WidgetTool.isSourceExist(appId, formId).getData()).booleanValue()) {
            ApiResponse objectApiResponse = new ApiResponse();
            objectApiResponse.setData(new ArrayList());
            objectApiResponse.setCode(10000);
            return ResponseEntity.of(Optional.of(objectApiResponse));
        }
        FormDesignResponse<List<ResourceReference>> referRes = this.referenceService.get();
        List references = (List)referRes.getData();
        if (HussarUtils.isNotEmpty((Object)references)) {
            HashMap<String, String> referMap = new HashMap<String, String>();
            String refer = String.valueOf(params.get("refer"));
            List<String> refers = Arrays.asList(refer.split(","));
            for (ResourceReference reference : references) {
                List<String> referKey = reference.getReferKey();
                List<String> sourceKey = reference.getSourceKey();
                if (!HussarUtils.isNotEmpty(referKey) || !HussarUtils.isNotEmpty(sourceKey) || referKey.size() <= 2 || sourceKey.size() < 2) continue;
                String sourceAppId = sourceKey.get(0);
                String sourceFormId = sourceKey.get(1);
                if (!sourceAppId.equals(appId) || !sourceFormId.equals(formId)) continue;
                String referAppId = referKey.get(0);
                String referFormId = referKey.get(1);
                if (!referAppId.equals(refers.get(0)) || !referFormId.equals(refers.get(1))) continue;
                referMap.put(sourceKey.get(2), referKey.get(2));
            }
            String referId = String.valueOf(params.get("referId"));
            ResponseEntity<ApiResponse<Object>> referFormData = this.formQueryFormRefer(refers.get(0), refers.get(1), referId);
            ApiResponse body = (ApiResponse)referFormData.getBody();
            if (HussarUtils.isNotEmpty((Object)body)) {
                JSONObject data = JSON.parseObject((String)JSON.toJSONString((Object)body.getData()));
                ArrayList<Filter> filters = new ArrayList<Filter>();
                Filter filter = new Filter();
                filter.setMatch("AND");
                filters.add(filter);
                ArrayList<Filter> children = new ArrayList<Filter>();
                int last = 0;
                for (String sourceKey : referMap.keySet()) {
                    String match = "OR";
                    if (HussarUtils.equals((Object)(++last), (Object)referMap.keySet().size())) {
                        match = "AND";
                    }
                    Filter child = new Filter();
                    child.setField(sourceKey);
                    child.setRule(OperatorType.EQ.getValue());
                    child.setMatch(match);
                    child.setVal(data.getString((String)referMap.get(sourceKey)));
                    children.add(child);
                }
                filter.setChildren(children);
                Object superQueryConditionObj = params.get("superQueryConditionDto");
                if (HussarUtils.isEmpty((Object)superQueryConditionObj)) {
                    params.put("superQueryConditionDto", new ArrayList());
                }
                List superQueryConditionDto = JSON.parseArray((String)JSON.toJSONString((Object)params.get("superQueryConditionDto")), Filter.class);
                filters.addAll(superQueryConditionDto);
                params.replace("superQueryConditionDto", filters);
            }
        }
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TableQuery");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> tableQuery(String formId, String viewId, Map<String, Object> params, String newAppId) {
        String appId;
        if (HussarUtils.isNotEmpty((Object)newAppId)) {
            AppContextUtil.setAppId((String)newAppId);
        }
        if (!((Boolean)WidgetTool.isSourceExist(appId = AppContextUtil.getAppId(), formId).getData()).booleanValue()) {
            ApiResponse objectApiResponse = new ApiResponse();
            objectApiResponse.setData(new ArrayList());
            objectApiResponse.setCode(10000);
            return ResponseEntity.of(Optional.of(objectApiResponse));
        }
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, String.format("%s%s", "TableQuery", viewId));
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> tableQueryAll(String appId, String formId) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TableQueryAll");
        return this.engineApiService.invokeByReturnEntity(businessId, null, new HashMap());
    }

    public void tableSave(String appId, String formId, Map<String, Object> params) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TableSave");
        this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> formQuery(String formId, String id, String tabType, String appId) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String businessId = this.getBusinessId(HttpMethod.GET.name(), AppContextUtil.getAppId(), formId, "FormQuery");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        if (!HussarUtils.equals((Object)tabType, (Object)BASE_FORM)) {
            params.put("BC8D215A-26F1-9B83-4DE2-7867003DA241", "BC8D215A-26F1-9B83-4DE2-7867003DA241");
        }
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> formQueryFormRefer(String appId, String formId, String id) {
        String headApp = AppContextUtil.getAppId();
        if (HussarUtils.isEmpty((Object)headApp)) {
            AppContextUtil.setAppId((String)appId);
        }
        String businessId = this.getBusinessId(HttpMethod.GET.name(), appId, formId, "FormQuery");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ApiResponse<FormVerifyVO> formVerify(String appId, String formId, String id) {
        String businessId = this.getBusinessId(HttpMethod.GET.name(), appId, formId, "FormVerify");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        ResponseEntity response = this.engineApiService.invokeByReturnEntity(businessId, null, params);
        FormVerifyVO formVerifyVO = new FormVerifyVO();
        ApiResponse<Boolean> sourceExist = WidgetTool.isSourceExist(appId, formId);
        if (!((Boolean)sourceExist.getData()).booleanValue()) {
            ApiResponse voApiResponse = new ApiResponse();
            voApiResponse.setCode(sourceExist.getCode());
            voApiResponse.setMsg(sourceExist.getMsg());
            return voApiResponse;
        }
        formVerifyVO.setForm(this.getCanvas(formId, appId));
        if (HussarUtils.isEmpty((Object)((ApiResponse)response.getBody()).getData())) {
            ApiResponse voApiResponse = new ApiResponse();
            voApiResponse.setCode(12023);
            voApiResponse.setMsg("\u6570\u636e\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u67e5\u770b");
            return voApiResponse;
        }
        formVerifyVO.setFormData(((ApiResponse)response.getBody()).getData());
        return ApiResponse.success((Object)formVerifyVO);
    }

    public ResponseEntity<ApiResponse<Object>> deleteBatch(String formId, String ids, String newAppId) {
        if (HussarUtils.isNotEmpty((Object)newAppId)) {
            AppContextUtil.setAppId((String)newAppId);
        }
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "DeleteBatch");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ids", ids);
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> formSave(String formId, Map<String, Object> params, String newAppId) {
        if (HussarUtils.isNotEmpty((Object)newAppId)) {
            AppContextUtil.setAppId((String)newAppId);
        }
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FormSave");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowFormSubmit");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> flowFormRecall(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "FlowFormRecall");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> initialNodeReject(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "InitialNodeReject");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> prevNodeReject(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "PrevNodeReject");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> taskEntrust(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "TaskEntrust");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public ResponseEntity<ApiResponse<Object>> endProcess(String formId, Map<String, Object> params) {
        String appId = AppContextUtil.getAppId();
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, "EndProcess");
        return this.engineApiService.invokeByReturnEntity(businessId, null, params);
    }

    public FormCanvasSchemaDTO getCanvas(String formId, String appId) {
        AppContextUtil.setAppId((String)appId);
        FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isNotEmpty((Object)((Object)canvas))) {
            FormCanvasSchemaDTO canvasDto = new FormCanvasSchemaDTO();
            BeanUtils.copyProperties((Object)((Object)canvas), (Object)canvasDto);
            return canvasDto;
        }
        return new FormCanvasSchemaDTO();
    }

    public FormCanvasSchemaDTO businessDataCanvas(String formId, String appId) {
        AppContextUtil.setAppId((String)appId);
        FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isNotEmpty((Object)((Object)canvas))) {
            FormCanvasSchemaDTO canvasDto = new FormCanvasSchemaDTO();
            BeanUtils.copyProperties((Object)((Object)canvas), (Object)canvasDto);
            List<Widget> widgets = canvas.widgetsWithSys();
            widgets.addAll(canvas.childTables());
            ArrayList<WidgetDTO> widgetDTOS = new ArrayList<WidgetDTO>();
            WidgetTool.ofWidgetDTO(widgetDTOS, widgets, widget -> false);
            canvasDto.setWidgets(widgetDTOS);
            return canvasDto;
        }
        return new FormCanvasSchemaDTO();
    }

    public FormViewSchemaDTO getView(String formId, String appId) throws Exception {
        FormDesignResponse<FormViewSchema> viewResponse;
        FormViewSchema view;
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (HussarUtils.isNotEmpty((Object)(view = (FormViewSchema)(viewResponse = this.viewService.get(formId)).getData()))) {
            FormViewSchemaDTO viewDto = new FormViewSchemaDTO();
            BeanUtils.copyProperties((Object)view, (Object)viewDto);
            ISysApplicationExternalService iSysApplicationExternalService = (ISysApplicationExternalService)SpringUtil.getBean(ISysApplicationExternalService.class);
            SysForm formDetailById = iSysApplicationExternalService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
            if (HussarUtils.isEmpty((Object)formDetailById) || HussarUtils.isEmpty((Object)formDetailById.getFormStatus())) {
                ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u72b6\u6001\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
                return null;
            }
            viewDto.setFormStatus(formDetailById.getFormStatus());
            viewDto.setFormTitle(formDetailById.getFormName());
            return viewDto;
        }
        return null;
    }

    public FieldControlUnitSchema getFieldControl(String formId, String appId) throws IOException {
        FormDesignResponse<FieldControlUnitSchema> fieldControlResponse;
        FieldControlUnitSchema fieldControl;
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (HussarUtils.isNotEmpty((Object)(fieldControl = (FieldControlUnitSchema)(fieldControlResponse = this.settingService.getFieldControl(formId)).getData()))) {
            return fieldControl;
        }
        return null;
    }

    public SubmitSchema getSubmit(String formId, String appId) {
        SettingSchemaService settingSchemaService;
        FormDesignResponse submitResponse;
        SubmitSchema submit;
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (HussarUtils.isNotEmpty((Object)(submit = (SubmitSchema)(submitResponse = (settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.submit", SettingSchemaService.class)).get(formId)).getData()))) {
            return submit;
        }
        return null;
    }

    public ApiResponse<Boolean> saveStaff(StaffScope staffScope) throws JsonProcessingException {
        return ApiResponse.success((Object)this.staffScopeService.saveStaff(staffScope).getData());
    }

    public ApiResponse<StaffScope> getStaffScope(String formId, String widgetName, String appId) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        return ApiResponse.success((Object)this.staffScopeService.getStaffScope(formId, widgetName).getData());
    }

    public ApiResponse<Boolean> deleteStaff(String formId, String widgetName) throws JsonProcessingException {
        return ApiResponse.success((Object)this.staffScopeService.delete(formId, widgetName).getData());
    }

    public ApiResponse<List<FormDetailVO>> getShowForms(String formId, String appId) throws JsonProcessingException {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        FormDesignResponse<List<FormDetailVO>> showForms = this.settingService.getShowForms(formId);
        List showFormsDate = (List)showForms.getData();
        ArrayList<FormDetailVO> newShowFormsDate = new ArrayList<FormDetailVO>();
        if (showFormsDate != null) {
            FormDesignResponse<List<FormDetailVO>> showReference = this.settingService.getReference(formId);
            List showReferenceDate = (List)showReference.getData();
            for (FormDetailVO detailVO : showFormsDate) {
                String showFormId = detailVO.getFormId();
                for (FormDetailVO formDetailVO : showReferenceDate) {
                    String referenceFormId = formDetailVO.getFormId();
                    if (!showFormId.equals(referenceFormId)) continue;
                    newShowFormsDate.add(detailVO);
                }
            }
        }
        return ApiResponse.success(newShowFormsDate);
    }

    public HideRuleSchema getHideRule(String formId) {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.hideRule", SettingSchemaService.class);
        FormDesignResponse hideRuleSchemaResponse = settingSchemaService.get(formId);
        HideRuleSchema hideRule = (HideRuleSchema)hideRuleSchemaResponse.getData();
        if (HussarUtils.isNotEmpty((Object)hideRule)) {
            return hideRule;
        }
        return null;
    }

    public void exportMid(Long appId, String path, List<Long> formIds) throws JsonProcessingException {
        AppContextUtil.setAppId((String)String.valueOf(appId));
        String appIdStr = String.valueOf(appId);
        for (Long formId : formIds) {
            String formName = ((FormCanvasSchema)((Object)this.canvasService.get(String.valueOf(formId)).getData())).getName();
            String midFilePath = FileUtil.posixPath((String[])new String[]{path, appIdStr, formName});
            FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)this.canvasService.get(String.valueOf(formId)).getData());
            String canvasFin = formName + ".fd";
            String canvasPath = FileUtil.posixPath((String[])new String[]{midFilePath, "canvas", canvasFin});
            String canvasJson = JSONObject.toJSONStringWithDateFormat((Object)((Object)canvasSchema), (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(canvasJson, canvasPath);
            SettingSchemaService bean = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
            FormSettingSchema settingSchema = (FormSettingSchema)((Object)bean.get(String.valueOf(formId)).getData());
            String settingFin = formName + ".setting";
            String settingPath = FileUtil.posixPath((String[])new String[]{midFilePath, "setting", settingFin});
            String settingJson = JSONObject.toJSONStringWithDateFormat((Object)((Object)settingSchema), (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(settingJson, settingPath);
            FormViewSchema viewSchema = (FormViewSchema)this.viewService.get(String.valueOf(formId)).getData();
            String viewFin = formName + ".vd";
            String viewPath = FileUtil.posixPath((String[])new String[]{midFilePath, "view", viewFin});
            String viewJson = JSONObject.toJSONStringWithDateFormat((Object)viewSchema, (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(viewJson, viewPath);
            List staffScopes = (List)this.staffScopeScemaService.list(String.valueOf(formId)).getData();
            String staffFileName = formName + "history" + ".stf";
            String staffFilePath = FileUtil.posixPath((String[])new String[]{midFilePath, "staff", staffFileName});
            String staffJsonStr = JSONObject.toJSONStringWithDateFormat((Object)staffScopes, (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            this.filePublishService.writeStringToFile(staffJsonStr, staffFilePath);
        }
    }
}

