/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.factory;

import com.jxdinfo.hussar.formdesign.common.annotation.BuilderType;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ModelBuilderFactory
implements InitializingBean,
ApplicationContextAware {
    private static final ConcurrentHashMap<String, DataModelBuilder> STRATEGY = new ConcurrentHashMap();
    private ApplicationContext context;

    public static DataModelBuilder strategy(String strategy) {
        Map beansWithAnnotation = SpringUtil.getBeanWithAnnotation(BuilderType.class);
        for (Map.Entry objectEntry : beansWithAnnotation.entrySet()) {
            Object instance;
            Class<?> builder = objectEntry.getValue().getClass();
            String type = builder.getAnnotation(BuilderType.class).type();
            if (!HussarUtils.equals((Object)type, (Object)strategy)) continue;
            try {
                instance = builder.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            return (DataModelBuilder)instance;
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7b56\u7565\u7684\u5339\u914d\u5efa\u9020\u8005");
    }

    public void afterPropertiesSet() {
        this.context.getBeansOfType(DataModelBuilder.class).values().forEach(strategy -> STRATEGY.put(strategy.strategy(), (DataModelBuilder)strategy));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

