/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.staff.StaffScopeHistory;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class StaffScopeScemaStorageImpl
implements StaffScopeScemaService {
    public static final String STAFF_SCOPE_PATH = "staff";
    public static final String STAFF_SCOPE_SUFFIX = ".stf";
    public static final String STAFF_SCOPE_HISTORY = "history";
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private StorageService storage;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(StaffScope staffScope) throws JsonProcessingException {
        String formId = staffScope.getFormId();
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)response.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        String path = FileUtil.posixPath((String[])new String[]{canvasSchema.getName(), STAFF_SCOPE_PATH, canvasSchema.getName() + STAFF_SCOPE_SUFFIX});
        String metaPath = path + ".meta";
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String staffScopeId = formIndexMeta.getStaffScopeId();
        if (HussarUtils.isEmpty((Object)staffScopeId)) {
            staffScopeId = RandomUtil.randomString((int)canvasSchema.getId().length());
            formIndexMeta.setStaffScopeId(staffScopeId);
        }
        this.canvasSchemaService.updateMeta(formIndexMeta);
        ArrayList<StaffScope> staffScopes = new ArrayList<StaffScope>();
        staffScopes.add(staffScope);
        FormDesignResponse<List<StaffScope>> scopes = this.list(formId);
        List oldStaffs = (List)scopes.getData();
        if (HussarUtils.isNotEmpty((Object)oldStaffs)) {
            StaffScope old = oldStaffs.stream().filter(scope -> scope.getWidgetName().equals(staffScope.getWidgetName())).findFirst().orElse(null);
            if (HussarUtils.isNotEmpty((Object)old)) {
                oldStaffs.remove(old);
            }
            staffScopes.addAll(oldStaffs);
        }
        StorageResult jsonResponse = this.storage.uploadByUuid(CategoryEnum.JSON, staffScopeId, path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(staffScopes).getBytes(StandardCharsets.UTF_8), false);
        FormIndexMeta indexMeta = new FormIndexMeta();
        indexMeta.setId(staffScopeId);
        indexMeta.setPath(metaPath);
        StorageResult metaResponse = this.storage.uploadByUuid(CategoryEnum.META, staffScopeId, metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)indexMeta).getBytes(StandardCharsets.UTF_8), false);
        if (jsonResponse.isSuccess() && metaResponse.isSuccess()) {
            String cacheKey = String.format("%s:%s:%s", AppContextUtil.getAppId(), formId, "staffScope");
            HussarCacheUtil.evict((String)"vfg_no-code_schema", (Object)cacheKey);
            return FormDesignResponse.success((Object)true);
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u4eba\u5458\u7ec4\u4ef6\u8303\u56f4 ==> Storage\u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u4eba\u5458\u7ec4\u4ef6\u8303\u56f4 ==> Storage\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<Boolean> saveOrUpdateBatch(List<StaffScope> staffScopes) throws JsonProcessingException {
        if (HussarUtils.isEmpty(staffScopes)) {
            return FormDesignResponse.fail((Object)false, (String)"\u63d0\u4ea4\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        for (StaffScope staffScope : staffScopes) {
            this.saveOrUpdate(staffScope);
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<StaffScope> getByName(String formId, String widgetName) {
        FormDesignResponse<List<StaffScope>> response = this.list(formId);
        if (HussarUtils.isEmpty((Object)response.getData())) {
            return FormDesignResponse.success(null);
        }
        StaffScope scope = ((List)response.getData()).stream().filter(staffScope -> staffScope.getWidgetName().equals(widgetName)).findFirst().orElse(null);
        return FormDesignResponse.success((Object)scope);
    }

    @Override
    public FormDesignResponse<List<StaffScope>> list(String formId) {
        String cacheKey = String.format("%s:%s:%s", AppContextUtil.getAppId(), formId, "staffScope");
        List cacheScopes = (List)HussarCacheUtil.get((String)"vfg_no-code_schema", (Object)cacheKey, ArrayList.class);
        if (HussarUtils.isNotEmpty((Object)cacheScopes)) {
            return FormDesignResponse.success((Object)cacheScopes);
        }
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String staffScopeId = formIndexMeta.getStaffScopeId();
        if (HussarUtils.isEmpty((Object)staffScopeId)) {
            return FormDesignResponse.success(null);
        }
        StorageResult storageResult = this.storage.downloadByUuid(CategoryEnum.JSON, staffScopeId);
        if (storageResult.isSuccess()) {
            List scopes = JSON.parseArray((String)new String((byte[])storageResult.getData(), StandardCharsets.UTF_8), StaffScope.class);
            HussarCacheUtil.put((String)"vfg_no-code_schema", (Object)cacheKey, (Object)scopes);
            return FormDesignResponse.success((Object)scopes);
        }
        return FormDesignResponse.success(null);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId, String widgetName) throws JsonProcessingException {
        FormDesignResponse<FormCanvasSchema> response;
        FormDesignResponse<List<StaffScope>> staffsResponse = this.list(formId);
        FormDesignResponse<StaffScope> staffResponse = this.getByName(formId, widgetName);
        List scopes = (List)staffsResponse.getData();
        if (HussarUtils.isEmpty((Object)scopes) || HussarUtils.isEmpty(staffResponse)) {
            return FormDesignResponse.success((Object)true);
        }
        StaffScope old = scopes.stream().filter(scope -> scope.getWidgetName().equals(widgetName)).findFirst().orElse(null);
        if (HussarUtils.isNotEmpty((Object)old)) {
            scopes.remove(old);
        }
        if (HussarUtils.isEmpty((Object)(response = this.canvasSchemaService.get(formId)).getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        String path = FileUtil.posixPath((String[])new String[]{canvasSchema.getName(), STAFF_SCOPE_PATH, canvasSchema.getName() + STAFF_SCOPE_SUFFIX});
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String staffScopeId = formIndexMeta.getStaffScopeId();
        this.storage.uploadByUuid(CategoryEnum.JSON, staffScopeId, path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)scopes).getBytes(StandardCharsets.UTF_8), false);
        String cacheKey = String.format("%s:%s:%s", AppContextUtil.getAppId(), formId, "staffScope");
        HussarCacheUtil.evict((String)"vfg_no-code_schema", (Object)cacheKey);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<String> saveOrUpdateHistory(StaffScopeHistory staffScopeHistory) throws JsonProcessingException {
        String formId = staffScopeHistory.getFormId();
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)response.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        String path = FileUtil.posixPath((String[])new String[]{canvasSchema.getName(), STAFF_SCOPE_PATH, canvasSchema.getName() + STAFF_SCOPE_HISTORY + STAFF_SCOPE_SUFFIX});
        String metaPath = path + ".meta";
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String staffScopeHistoryId = formIndexMeta.getStaffScopeHistoryId();
        if (HussarUtils.isEmpty((Object)staffScopeHistoryId)) {
            staffScopeHistoryId = RandomUtil.randomString((int)canvasSchema.getId().length());
            formIndexMeta.setStaffScopeHistoryId(staffScopeHistoryId);
        }
        this.canvasSchemaService.updateMeta(formIndexMeta);
        ArrayList<StaffScopeHistory> staffScopeHistories = new ArrayList<StaffScopeHistory>();
        staffScopeHistories.add(staffScopeHistory);
        FormDesignResponse<List<StaffScopeHistory>> listFormDesignResponse = this.listHistory(formId);
        List oldStaffHistory = (List)listFormDesignResponse.getData();
        if (HussarUtils.isNotEmpty((Object)oldStaffHistory)) {
            StaffScopeHistory old = oldStaffHistory.stream().filter(scopeHistory -> scopeHistory.getWidgetName().equals(staffScopeHistory.getWidgetName())).findFirst().orElse(null);
            if (HussarUtils.isEmpty((Object)old)) {
                oldStaffHistory.remove(old);
            }
            staffScopeHistories.addAll(oldStaffHistory);
        }
        StorageResult jsonResponse = this.storage.uploadByUuid(CategoryEnum.JSON, staffScopeHistoryId, path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(staffScopeHistories).getBytes(StandardCharsets.UTF_8), false);
        FormIndexMeta indexMeta = new FormIndexMeta();
        indexMeta.setId(staffScopeHistoryId);
        indexMeta.setPath(metaPath);
        StorageResult metaResponse = this.storage.uploadByUuid(CategoryEnum.META, staffScopeHistoryId, metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)indexMeta).getBytes(StandardCharsets.UTF_8), false);
        if (jsonResponse.isSuccess() && metaResponse.isSuccess()) {
            return FormDesignResponse.success((Object)staffScopeHistory.getStepKey());
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u4eba\u5458\u7ec4\u4ef6\u8303\u56f4 ==> Storage\u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail(null, (String)"\u4fdd\u5b58\u4eba\u5458\u7ec4\u4ef6\u8303\u56f4\u5386\u53f2 ==> Storage\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<List<StaffScopeHistory>> listHistory(String formId) {
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String staffScopeHistoryId = formIndexMeta.getStaffScopeHistoryId();
        if (HussarUtils.isEmpty((Object)staffScopeHistoryId)) {
            return FormDesignResponse.success(null);
        }
        StorageResult storageResult = this.storage.downloadByUuid(CategoryEnum.JSON, staffScopeHistoryId);
        if (storageResult.isSuccess()) {
            return FormDesignResponse.success((Object)JSON.parseArray((String)new String((byte[])storageResult.getData(), StandardCharsets.UTF_8), StaffScopeHistory.class));
        }
        return FormDesignResponse.success(null);
    }

    @Override
    public FormDesignResponse<StaffScopeHistory> getHistoryByName(String formId, String widgetName, String stepKey) {
        FormDesignResponse<List<StaffScopeHistory>> response = this.listHistory(formId);
        if (HussarUtils.isEmpty((Object)response.getData())) {
            return FormDesignResponse.success(null);
        }
        StaffScopeHistory scopeHistory = ((List)response.getData()).stream().filter(staffScopeHistory -> staffScopeHistory.getWidgetName().equals(widgetName)).filter(staffScopeHistory -> staffScopeHistory.getStepKey().equals(stepKey)).findFirst().orElse(null);
        return FormDesignResponse.success((Object)scopeHistory);
    }

    @Override
    public FormDesignResponse<Boolean> deleteScopeHistory(String formId) throws JsonProcessingException {
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String staffScopeHistoryId = formIndexMeta.getStaffScopeHistoryId();
        if (HussarUtils.isEmpty((Object)staffScopeHistoryId)) {
            return FormDesignResponse.success((Object)true);
        }
        this.storage.deleteByUuid(CategoryEnum.JSON, staffScopeHistoryId, false);
        this.storage.deleteByUuid(CategoryEnum.META, staffScopeHistoryId, false);
        return FormDesignResponse.success((Object)true);
    }
}

