/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.Path;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNDate")
public class JXDNDate
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.DATETIME.name());
            this.put("ORACLE", OracleType.TIMESTAMP.name());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField() {
        String name = this.widget.getName();
        String title = this.widget.getTitle();
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        String dbType = DataModelUtil.getDataSourceTypeByName((String)DataModelUtil.currentDsName());
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.DATE.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        return fields;
    }

    @Override
    public int getLength() {
        AtomicInteger length = new AtomicInteger(0);
        return length.get();
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("format", JsonParser.value(this.widget, Path.Widgets.FORMAT.getPath(), String.class).orElse("yyyy-MM-dd"));
    }
}

