/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.mysql.cj.MysqlType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNCheckBoxGroup")
public class JXDNCheckBoxGroup
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.VARCHAR.name());
            this.put("ORACLE", OracleType.VARCHAR2.name());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField() {
        String name = this.widget.getName();
        String title = this.widget.getTitle();
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        String dbType = DataModelUtil.getDataSourceTypeByName((String)DataModelUtil.currentDsName());
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        fields.add(new DataModelFieldBase.Builder().withId(name + "_label").withName(name + "_label").withComment(title + "-\u663e\u793a\u503c").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).build());
        return fields;
    }

    @Override
    public int getLength() throws IOException {
        return super.getLength();
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("derived", String.format("%s%s", this.widget.getName(), "_label"));
    }
}

