/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.model.canvas;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(value="FormCanvasSchema")
public class FormCanvasSchema
extends BaseForm {
    private int version;
    private String isDetails;
    private String namespace;
    private Map<String, Object> props;
    private List<Widget> widgets;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getIsDetails() {
        if (HussarUtils.isNotEmpty(this.widgets)) {
            for (Widget widget : this.widgets) {
                if (!WidgetType.CHILDREN_TABLE.getType().equals(widget.getType())) continue;
                this.isDetails = "1";
                return this.isDetails;
            }
        }
        this.isDetails = "0";
        return this.isDetails;
    }

    public void setIsDetails(String isDetails) {
        this.isDetails = isDetails;
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public void setProps(Map<String, Object> props) {
        this.props = props;
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<Widget> widgetsWithSys() {
        List<Widget> flatWidgets = this.widgets();
        flatWidgets.addAll(this.systemWidgets());
        return flatWidgets;
    }

    public List<Widget> widgetsWithChildren() {
        ArrayList<Widget> flatWidgets = new ArrayList<Widget>();
        List<Widget> widgetList = this.getWidgets();
        if (HussarUtils.isEmpty(widgetList)) {
            return new ArrayList<Widget>();
        }
        this.flatWithChildren(flatWidgets, widgetList);
        return flatWidgets;
    }

    public List<Widget> childTables() {
        ArrayList<Widget> children = new ArrayList<Widget>();
        List<Widget> widgetList = this.getWidgets();
        if (HussarUtils.isEmpty(widgetList)) {
            return children;
        }
        this.flatButChildren(children, widgetList);
        return children;
    }

    public List<Widget> widgets() {
        ArrayList<Widget> flatWidgets = new ArrayList<Widget>();
        List<Widget> widgetList = this.getWidgets();
        if (HussarUtils.isEmpty(widgetList)) {
            return new ArrayList<Widget>();
        }
        this.flatButNotChildren(flatWidgets, widgetList);
        return flatWidgets;
    }

    public List<Widget> systemWidgets() {
        String json = ToolUtil.loadResource(((Object)((Object)this)).getClass(), (String)"/system_widgets.json");
        return JSON.parseArray((String)json, Widget.class);
    }

    private void flatButNotChildren(List<Widget> flatWidgets, List<Widget> widgets) {
        for (Widget widget : widgets) {
            if ("1".equals(this.getIsDetails()) && WidgetType.CHILDREN_TABLE.getType().equals(widget.getType())) continue;
            if (widget.getIsContainer() && HussarUtils.isNotEmpty(widget.getChildren())) {
                this.flatButNotChildren(flatWidgets, widget.getChildren());
            }
            if (widget.getIsContainer() || !HussarUtils.isNotEmpty((Object)widget.getDataType())) continue;
            flatWidgets.add(widget);
        }
    }

    private void flatWithChildren(List<Widget> flatWidgets, List<Widget> widgets) {
        for (Widget widget : widgets) {
            if (WidgetType.GROUP.getType().equals(widget.getType()) && HussarUtils.isNotEmpty(widget.getChildren())) {
                this.flatButNotChildren(flatWidgets, widget.getChildren());
            }
            if (!HussarUtils.isNotEmpty((Object)widget.getDataType())) continue;
            flatWidgets.add(widget);
        }
    }

    private void flatButChildren(List<Widget> children, List<Widget> widgets) {
        for (Widget widget : widgets) {
            if (WidgetType.GROUP.getType().equals(widget.getType())) {
                this.flatButChildren(children, widget.getChildren());
            }
            if (!WidgetType.CHILDREN_TABLE.getType().equals(widget.getType())) continue;
            children.add(widget);
        }
    }
}

