/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControlSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.FieldControlUnitSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.SummarySchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SettingServiceImpl
implements SettingService {
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @Override
    @HussarTransactional
    public FormDesignResponse<Boolean> saveTitle(TitleSchema titleSchema, String formId) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.title", SettingSchemaService.class);
        FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(titleSchema, formId);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6807\u9898\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6807\u9898\u5931\u8d25");
        }
        this.formOperateService.publish(formId);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveSummary(List<String> dataSummary, String formId) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.summary", SettingSchemaService.class);
        SummarySchema summarySchema = new SummarySchema();
        summarySchema.setDataSummary(dataSummary);
        FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(summarySchema, formId);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6458\u8981\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u6570\u636e\u6458\u8981\u5931\u8d25");
        }
        this.formOperateService.publish(formId);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveFieldControl(FieldControlSchema fieldControlSchema, String formId) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class);
        FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(fieldControlSchema, formId);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u5b57\u6bb5\u63a7\u5236\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u5b57\u6bb5\u63a7\u5236\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveSubmit(SubmitSchema submitSchema, String formId) throws Exception {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.submit", SettingSchemaService.class);
        FormDesignResponse<Boolean> updateForm = settingSchemaService.saveOrUpdate(submitSchema, formId);
        if (!((Boolean)updateForm.getData()).booleanValue()) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u8868\u5355\u63d0\u4ea4\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u8bbe\u7f6e ==> \u4fdd\u5b58\u8868\u5355\u63d0\u4ea4\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<TitleSchema> getTitle(String formId) {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.title", SettingSchemaService.class);
        TitleSchema title = (TitleSchema)((Object)settingSchemaService.get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)title))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u6570\u636e\u6807\u9898\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u6570\u636e\u6807\u9898\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)((Object)title));
    }

    @Override
    public FormDesignResponse<List<String>> getSummary(String formId) {
        SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.summary", SettingSchemaService.class);
        SummarySchema summary = (SummarySchema)((Object)settingSchemaService.get(formId).getData());
        if (HussarUtils.isEmpty((Object)((Object)summary))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u6570\u636e\u6458\u8981\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u6570\u636e\u6458\u8981\u5931\u8d25");
        }
        return FormDesignResponse.success(summary.getDataSummary());
    }

    @Override
    public FormDesignResponse<FieldControlUnitSchema> getFieldControl(String formId) throws IOException {
        FormDesignResponse<FormCanvasSchema> canvasResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema canvas = (FormCanvasSchema)((Object)canvasResponse.getData());
        if (HussarUtils.isEmpty((Object)((Object)canvas))) {
            ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u8868\u5355\u8bbe\u7f6e ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        FormDesignResponse fieldControlResponse = ((SettingSchemaService)SpringUtil.getBean((String)"no.code.fieldControl", SettingSchemaService.class)).get(formId);
        FieldControlSchema fieldControlSchema = (FieldControlSchema)fieldControlResponse.getData();
        fieldControlSchema = HussarUtils.isEmpty((Object)fieldControlSchema) ? new FieldControlSchema() : fieldControlSchema;
        FieldControlUnitSchema fieldControlUnitSchema = new FieldControlUnitSchema();
        fieldControlUnitSchema.setFieldControl(fieldControlSchema);
        fieldControlUnitSchema.setFormType(canvas.getFormType());
        return FormDesignResponse.success((Object)fieldControlUnitSchema);
    }

    private FieldControlSchema fieldControlSort(FieldControlSchema fieldControlSchema, FormCanvasSchema canvas) {
        ArrayList newAdd = new ArrayList();
        ArrayList newEdit = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)fieldControlSchema.getAdd()) && HussarUtils.isNotEmpty((Object)fieldControlSchema.getEdit())) {
            int i;
            for (Widget widget : canvas.widgets()) {
                for (i = 0; i < fieldControlSchema.getAdd().size(); ++i) {
                    if (!widget.getName().equals(((FieldControl)fieldControlSchema.getAdd().get(i)).getField())) continue;
                    newAdd.add(fieldControlSchema.getAdd().get(i));
                    newEdit.add(fieldControlSchema.getEdit().get(i));
                }
            }
            fieldControlSchema.setAdd(newAdd);
            fieldControlSchema.setEdit(newEdit);
            for (Widget childTable : canvas.childTables()) {
                for (i = 0; i < fieldControlSchema.getAdd().size(); ++i) {
                    if (!childTable.getName().equals(((FieldControl)fieldControlSchema.getAdd().get(i)).getField())) continue;
                    ArrayList addChildren = new ArrayList();
                    ArrayList editChildren = new ArrayList();
                    for (Widget childWidget : childTable.getChildren()) {
                        for (int j = 0; j < ((FieldControl)fieldControlSchema.getAdd().get(i)).getChildren().size(); ++j) {
                            if (!childWidget.getName().equals(((FieldControl)((FieldControl)fieldControlSchema.getAdd().get(i)).getChildren().get(j)).getField())) continue;
                            addChildren.add(((FieldControl)fieldControlSchema.getAdd().get(i)).getChildren().get(j));
                            editChildren.add(((FieldControl)fieldControlSchema.getEdit().get(i)).getChildren().get(j));
                        }
                    }
                    ((FieldControl)fieldControlSchema.getAdd().get(i)).setChildren(addChildren);
                    ((FieldControl)fieldControlSchema.getEdit().get(i)).setChildren(editChildren);
                }
            }
        }
        return fieldControlSchema;
    }
}

