/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.no.code.constant.Path;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.stereotype.Component;

@Component(value="JXDNInput")
public class JXDNInput
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField() {
        super.init(this.widget, this.form);
        return super.withField();
    }

    @Override
    public int getLength() throws IOException {
        AtomicInteger newLength = new AtomicInteger(255);
        JsonParser.value(this.widget, Path.Widgets.SHOW_WORD_LIMIT.getPath(), Boolean.class).ifPresent(v -> {
            if (v.booleanValue()) {
                JsonParser.value(this.widget, Path.Widgets.MAX_LENGTH.getPath(), Integer.class).ifPresent(newLength::set);
            }
        });
        return newLength.get();
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("inputMode", JsonParser.value(this.widget, Path.Widgets.INPUT_MODE.getPath(), String.class).orElse("text"));
    }
}

