/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class ViewSchemaStorageImpl
implements ViewSchemaService {
    public static final String VIEW_PATH = "view";
    public static final String VIEW_SUFFIX = ".vd";
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private StorageService storage;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormViewSchema formViewSchema) throws JsonProcessingException {
        String formId = formViewSchema.getFormId();
        FormDesignResponse<FormCanvasSchema> response = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)response.getData())) {
            ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25");
        }
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)response.getData());
        String path = FileUtil.posixPath((String[])new String[]{canvasSchema.getName(), VIEW_PATH, canvasSchema.getName() + VIEW_SUFFIX});
        String metaPath = path + ".meta";
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String viewId = formIndexMeta.getViewId();
        StorageResult viewJsonRes = this.storage.uploadByUuid(CategoryEnum.JSON, viewId, path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)formViewSchema).getBytes(StandardCharsets.UTF_8), false);
        FormIndexMeta viewMeta = new FormIndexMeta();
        viewMeta.setId(viewId);
        viewMeta.setPath(metaPath);
        StorageResult viewMetaRes = this.storage.uploadByUuid(CategoryEnum.META, viewId, metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)viewMeta).getBytes(StandardCharsets.UTF_8), false);
        if (viewJsonRes.isSuccess() && viewMetaRes.isSuccess()) {
            return FormDesignResponse.success((Object)true);
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> Storage\u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u6570\u636e\u89c6\u56fe ==> Storage\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<FormViewSchema> get(String formId) {
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String viewId = formIndexMeta.getViewId();
        if (HussarUtils.isEmpty((Object)viewId)) {
            return FormDesignResponse.success(null);
        }
        StorageResult storageResult = this.storage.downloadByUuid(CategoryEnum.JSON, viewId);
        if (storageResult.isSuccess()) {
            return FormDesignResponse.success((Object)JSON.parseObject((byte[])((byte[])storageResult.getData()), FormViewSchema.class, (Feature[])new Feature[0]));
        }
        return FormDesignResponse.success(null);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        FormIndexMeta formIndexMeta = this.canvasSchemaService.getMeta(formId);
        String viewId = formIndexMeta.getViewId();
        if (HussarUtils.isEmpty((Object)viewId)) {
            return FormDesignResponse.success((Object)true);
        }
        StorageResult json = this.storage.deleteByUuid(CategoryEnum.JSON, viewId, false);
        StorageResult meta = this.storage.deleteByUuid(CategoryEnum.META, viewId, false);
        if (json.isSuccess() && meta.isSuccess()) {
            return FormDesignResponse.success((Object)true);
        }
        ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u6570\u636e\u89c6\u56fe ==> Storage\u5220\u9664\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u5220\u9664\u6570\u636e\u89c6\u56fe ==> Storage\u5220\u9664\u5931\u8d25");
    }
}

